/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.componenteditor.inspector;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.part.Page;
import org.objectstyle.wolips.bindings.api.IApiBinding;
import org.objectstyle.wolips.bindings.wod.IWodBinding;
import org.objectstyle.wolips.bindings.wod.IWodElement;
import org.objectstyle.wolips.componenteditor.inspector.BindingsDragHandler;
import org.objectstyle.wolips.componenteditor.inspector.BindingsInspector;
import org.objectstyle.wolips.componenteditor.inspector.BindingsInspectorDropHandler;
import org.objectstyle.wolips.componenteditor.inspector.BindingsTextDropHandler;
import org.objectstyle.wolips.componenteditor.inspector.IWOBrowserDelegate;
import org.objectstyle.wolips.componenteditor.inspector.WOBrowser;
import org.objectstyle.wolips.componenteditor.inspector.WOBrowserColumn;
import org.objectstyle.wolips.componenteditor.part.ComponentEditor;
import org.objectstyle.wolips.components.editor.IWebobjectTagListener;
import org.objectstyle.wolips.wodclipse.core.completion.WodParserCache;
import org.objectstyle.wolips.wodclipse.core.document.ITextWOEditor;
import org.objectstyle.wolips.wodclipse.core.util.ICursorPositionListener;

public class BindingsInspectorPage
extends Page
implements ICursorPositionListener,
ISelectionChangedListener,
IWebobjectTagListener,
IWOBrowserDelegate {
    private ComponentEditor _componentEditor;
    private Composite _container;
    private BindingsInspector _inspector;
    private WOBrowser _browser;
    private boolean _selectionChanging;
    private BindingsTextDropHandler _templateDropHandler;
    private BindingsTextDropHandler _wodDropHandler;
    private BindingsInspectorDropHandler _inspectorDropHandler;

    public BindingsInspectorPage(ComponentEditor componentEditor) {
        this._componentEditor = componentEditor;
        if (componentEditor != null) {
            this._componentEditor.getEditorInteraction().addWebObjectTagListener((IWebobjectTagListener)this);
            if (this._componentEditor.getTemplateEditor() != null) {
                this._templateDropHandler = new BindingsTextDropHandler((ITextWOEditor)this._componentEditor.getTemplateEditor());
            }
            if (this._componentEditor.getWodEditor() != null) {
                this._wodDropHandler = new BindingsTextDropHandler((ITextWOEditor)this._componentEditor.getWodEditor());
            }
        }
    }

    @Override
    public void bindingDragCanceled(WOBrowserColumn column) {
        if (this._templateDropHandler != null) {
            this._templateDropHandler.bindingDragCanceled(column);
        }
        if (this._wodDropHandler != null) {
            this._wodDropHandler.bindingDragCanceled(column);
        }
        if (this._inspectorDropHandler != null) {
            this._inspectorDropHandler.bindingDragCanceled(column);
        }
    }

    @Override
    public void bindingDragging(WOBrowserColumn column, Point dragPoint) {
        if (this._templateDropHandler != null) {
            this._templateDropHandler.bindingDragging(column, dragPoint);
        }
        if (this._wodDropHandler != null) {
            this._wodDropHandler.bindingDragging(column, dragPoint);
        }
        if (this._inspectorDropHandler != null) {
            this._inspectorDropHandler.bindingDragging(column, dragPoint);
        }
    }

    @Override
    public boolean bindingDropped(WOBrowserColumn column, Point dropPoint, BindingsDragHandler dragHandler) {
        boolean dropFinished = true;
        if (this._templateDropHandler != null) {
            dropFinished &= this._templateDropHandler.bindingDropped(column, dropPoint, dragHandler);
        }
        if (this._wodDropHandler != null) {
            dropFinished &= this._wodDropHandler.bindingDropped(column, dropPoint, dragHandler);
        }
        if (this._inspectorDropHandler != null) {
            dropFinished &= this._inspectorDropHandler.bindingDropped(column, dropPoint, dragHandler);
        }
        this._inspector.refresh();
        return dropFinished;
    }

    @Override
    public void browserColumnAdded(WOBrowserColumn column) {
        if (this._templateDropHandler != null) {
            this._templateDropHandler.browserColumnAdded(column);
        }
        if (this._wodDropHandler != null) {
            this._wodDropHandler.browserColumnAdded(column);
        }
        if (this._inspectorDropHandler != null) {
            this._inspectorDropHandler.browserColumnAdded(column);
        }
    }

    @Override
    public void browserColumnRemoved(WOBrowserColumn column) {
        if (this._templateDropHandler != null) {
            this._templateDropHandler.browserColumnRemoved(column);
        }
        if (this._wodDropHandler != null) {
            this._wodDropHandler.browserColumnRemoved(column);
        }
        if (this._inspectorDropHandler != null) {
            this._inspectorDropHandler.browserColumnRemoved(column);
        }
    }

    public void dispose() {
        if (this._templateDropHandler != null) {
            this._templateDropHandler.dispose();
        }
        if (this._wodDropHandler != null) {
            this._wodDropHandler.dispose();
        }
        if (this._inspectorDropHandler != null) {
            this._inspectorDropHandler.dispose();
        }
        super.dispose();
    }

    public void createControl(Composite parent) {
        this._container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        layout.horizontalSpacing = 10;
        this._container.setLayout((Layout)layout);
        this._container.setBackground(parent.getBackground());
        Group inspectorGroup = new Group(this._container, 0);
        GridLayout inspectorGroupLayout = new GridLayout(2, false);
        inspectorGroupLayout.marginHeight = 0;
        inspectorGroupLayout.marginWidth = 0;
        inspectorGroup.setLayout((Layout)inspectorGroupLayout);
        inspectorGroup.setLayoutData((Object)new GridData(1040));
        this._inspector = new BindingsInspector((Composite)inspectorGroup, 0);
        this._inspector.setBackground(this._container.getBackground());
        this._inspector.addSelectionChangedListener(this);
        GridData inspectorLayoutData = new GridData(1040);
        inspectorLayoutData.widthHint = 350;
        this._inspector.setLayoutData(inspectorLayoutData);
        this._inspectorDropHandler = new BindingsInspectorDropHandler(this._inspector);
        Group browserGroup = new Group(this._container, 0);
        GridLayout browserGroupLayout = new GridLayout(2, false);
        browserGroupLayout.marginHeight = 0;
        browserGroupLayout.marginWidth = 0;
        browserGroup.setLayout((Layout)browserGroupLayout);
        browserGroup.setLayoutData((Object)new GridData(1808));
        this._browser = new WOBrowser((Composite)browserGroup, 0);
        this._browser.setBrowserDelegate(this);
        this._browser.setBackground(this._container.getBackground());
        this._browser.addSelectionChangedListener(this);
        this._browser.setLayoutData(new GridData(1808));
        if (this._componentEditor != null) {
            try {
                WodParserCache cache = this._componentEditor.getParserCache();
                if (cache != null) {
                    this._browser.setRootType(cache.getComponentType());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectionChanged(SelectionChangedEvent event) {
        if (!this._selectionChanging) {
            this._selectionChanging = true;
            try {
                if (event.getSource() == this._browser) {
                } else {
                    IWodBinding wodBinding;
                    IWodElement element;
                    IApiBinding apiBinding = (IApiBinding)((IStructuredSelection)event.getSelection()).getFirstElement();
                    boolean keyPathSelected = false;
                    if (apiBinding != null && (element = this._inspector.getWodElement()) != null && (wodBinding = element.getBindingNamed(apiBinding.getName())) != null && wodBinding.isKeyPath()) {
                        String value = wodBinding.getValue();
                        this._browser.setSelection((ISelection)new StructuredSelection((Object)value));
                        keyPathSelected = true;
                    }
                    if (!keyPathSelected) {
                        this._browser.setSelection((ISelection)new StructuredSelection());
                    }
                }
            }
            finally {
                this._selectionChanging = false;
            }
        }
    }

    public Control getControl() {
        return this._container;
    }

    public void setFocus() {
        this._container.setFocus();
    }

    public void webObjectChanged() {
        this._inspector.refresh();
    }

    public void webObjectTagSelected(String name) {
    }

    public void cursorPositionChanged(TextEditor editor, Point selectionRange) {
        this._inspector.cursorPositionChanged(editor, selectionRange);
    }
}

