/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.componenteditor.inspector;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class PopAnimator
implements PaintListener {
    private static final int minBorderWidth = 2;
    private static final int maxBorderWidth = 6;
    private static final int animationDuration = 150;
    private static final int borderRadius = 10;
    private static final int borderRedrawSize = 12;
    private boolean _isAnimating;
    private long _startTime;
    private Rectangle _animationRect;
    private Color _backgroundColor;
    private Control _control;

    public PopAnimator() {
        RGB bindingHoverColorPreference = new RGB(240, 220, 0);
        this._backgroundColor = new Color((Device)Display.getCurrent(), bindingHoverColorPreference);
    }

    public void setControl(Control control) {
        if (this._control != null && !this._control.isDisposed()) {
            this._control.removePaintListener((PaintListener)this);
        }
        this._control = control;
        if (this._control != null) {
            this._control.addPaintListener((PaintListener)this);
        }
    }

    public void setAnimationRect(Rectangle animationRect) {
        this.repaint();
        this._animationRect = animationRect;
    }

    public void step() {
        if (this.isAnimating()) {
            this.repaint();
        }
    }

    public void repaint() {
        this.repaint(this._animationRect);
    }

    public void repaint(Rectangle rect) {
        if (this._control != null && rect != null) {
            this._control.redraw(rect.x - 12, rect.y - 12, rect.width + 24, rect.height + 24, true);
        }
    }

    public boolean isAnimating() {
        return this._isAnimating;
    }

    public void dispose() {
        this.setControl(null);
        if (this._backgroundColor != null) {
            this._backgroundColor.dispose();
        }
        this._backgroundColor = null;
    }

    public synchronized void stopAnimation() {
        this._isAnimating = false;
        Rectangle animationRect = this._animationRect;
        this._animationRect = null;
        if (animationRect != this._animationRect) {
            this.repaint(animationRect);
        }
    }

    public synchronized void startAnimation() {
        this._startTime = System.currentTimeMillis();
        this._isAnimating = true;
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintControl(PaintEvent e) {
        try {
            boolean shouldThrob;
            Rectangle selectionRect;
            double animationTime;
            PopAnimator popAnimator = this;
            synchronized (popAnimator) {
                animationTime = System.currentTimeMillis() - this._startTime;
                if (this._isAnimating && animationTime > 300.0) {
                    this._isAnimating = false;
                }
                selectionRect = this._animationRect != null ? new Rectangle(this._animationRect.x, this._animationRect.y, this._animationRect.width, this._animationRect.height) : null;
                shouldThrob = this._isAnimating;
            }
            if (this._animationRect != null) {
                int lineWidth = 2;
                if (shouldThrob) {
                    lineWidth += (int)(4.0 * Math.sin(1.5707963267948966 * animationTime / 150.0));
                }
                int margin = lineWidth / 2;
                if (lineWidth > 0) {
                    e.gc.setLineWidth(lineWidth);
                    selectionRect.x -= margin;
                    selectionRect.y -= margin;
                    selectionRect.width += 2 * margin;
                    selectionRect.height += 2 * margin;
                    if (selectionRect.x < 1) {
                        selectionRect.x += 2;
                        selectionRect.width -= 2;
                    }
                    if (selectionRect.y < 1) {
                        selectionRect.y += 2;
                        selectionRect.height -= 2;
                    }
                    int shadowHeight = 2 * margin;
                    int shadowMargin = 5 + 2 * margin;
                    e.gc.setAlpha(80);
                    e.gc.setForeground(e.display.getSystemColor(2));
                    e.gc.drawRoundRectangle(selectionRect.x + shadowMargin, selectionRect.y + selectionRect.height, selectionRect.width - 2 * shadowMargin, shadowHeight, 10, 10);
                    e.gc.setForeground(this._backgroundColor);
                    e.gc.setBackground(this._backgroundColor);
                    e.gc.setAlpha(50);
                    e.gc.fillRoundRectangle(selectionRect.x, selectionRect.y, selectionRect.width, selectionRect.height, 10, 10);
                    e.gc.setAlpha(255);
                    e.gc.drawRoundRectangle(selectionRect.x, selectionRect.y, selectionRect.width, selectionRect.height, 10, 10);
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

