/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.core.model;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.objectstyle.wolips.baseforplugins.util.StringUtils;
import org.objectstyle.wolips.eomodeler.core.model.AbstractEOAttributePath;
import org.objectstyle.wolips.eomodeler.core.model.DuplicateFetchSpecNameException;
import org.objectstyle.wolips.eomodeler.core.model.EOEntity;
import org.objectstyle.wolips.eomodeler.core.model.EOModelException;
import org.objectstyle.wolips.eomodeler.core.model.EOModelMap;
import org.objectstyle.wolips.eomodeler.core.model.EOModelVerificationFailure;
import org.objectstyle.wolips.eomodeler.core.model.EOQualifierFactory;
import org.objectstyle.wolips.eomodeler.core.model.EOSortOrdering;
import org.objectstyle.wolips.eomodeler.core.model.EOStoredProcedure;
import org.objectstyle.wolips.eomodeler.core.model.IEOEntityRelative;
import org.objectstyle.wolips.eomodeler.core.model.ISortableEOModelObject;
import org.objectstyle.wolips.eomodeler.core.model.PropertyListMap;
import org.objectstyle.wolips.eomodeler.core.model.PropertyListSet;
import org.objectstyle.wolips.eomodeler.core.model.UserInfoableEOModelObject;
import org.objectstyle.wolips.eomodeler.core.model.qualifier.EOQualifier;
import org.objectstyle.wolips.eomodeler.core.model.qualifier.EOQualifierBinding;

public class EOFetchSpecification
extends UserInfoableEOModelObject<EOEntity>
implements IEOEntityRelative,
ISortableEOModelObject,
PropertyChangeListener {
    public static final String NAME = "name";
    public static final String SORT_ORDERING = "sortOrdering";
    public static final String SORT_ORDERINGS = "sortOrderings";
    public static final String QUALIFIER = "qualifier";
    public static final String QUALIFIER_STRING = "qualifierString";
    public static final String ENTITY = "entity";
    public static final String FETCH_LIMIT = "fetchLimit";
    public static final String DEEP = "deep";
    public static final String LOCKS_OBJECTS = "locksObjects";
    public static final String PREFETCHING_RELATIONSHIP_KEY_PATH = "prefetchingRelationshipKeyPath";
    public static final String PREFETCHING_RELATIONSHIP_KEY_PATHS = "prefetchingRelationshipKeyPaths";
    public static final String PROMPTS_AFTER_FETCH_LIMIT = "promptsAfterFetchLimit";
    public static final String RAW_ROW_KEY_PATH = "rawRowKeyPath";
    public static final String RAW_ROW_KEY_PATHS = "rawRowKeyPaths";
    public static final String REFRESHES_REFETCHED_OBJECTS = "refreshesRefetchedObjects";
    public static final String REQUIRES_ALL_QUALIFIER_BINDING_VARIABLES = "requiresAllQualifierBindingVariables";
    public static final String USES_DISTINCT = "usesDistinct";
    public static final String SHARES_OBJECTS = "sharesObjects";
    public static final String CUSTOM_QUERY_EXPRESSION = "customQueryExpression";
    public static final String STORED_PROCEDURE = "storedProcedure";
    private EOEntity myEntity;
    private String myName;
    private String myClass;
    private Integer myFetchLimit;
    private Boolean myDeep;
    private Boolean myLocksObjects;
    private Set<String> myPrefetchingRelationshipKeyPaths;
    private Boolean myPromptsAfterFetchLimit;
    private Set<String> myRawRowKeyPaths;
    private Boolean myRefreshesRefetchedObjects;
    private Boolean myRequiresAllQualifierBindingVariables;
    private Boolean myUsesDistinct;
    private List<EOSortOrdering> mySortOrderings;
    private EOQualifier myQualifier;
    private String myQualifierString;
    private EOModelMap myFetchSpecMap;
    private Boolean mySharesObjects;
    private String myCustomQueryExpression;
    private EOStoredProcedure myStoredProcedure;

    public EOFetchSpecification(String _name) {
        this.myName = _name;
        this.myClass = "EOFetchSpecification";
        this.mySortOrderings = new LinkedList<EOSortOrdering>();
        this.myFetchSpecMap = new EOModelMap();
        this.myPrefetchingRelationshipKeyPaths = new TreeSet<String>();
    }

    public List<EOQualifierBinding> getAllBindings() {
        return EOQualifierFactory.getQualifierBindingsFromQualifier(this.getEntity(), this.getQualifier());
    }

    public Set<EOQualifierBinding> getDistinctBindings() {
        HashMap<String, EOQualifierBinding> bindings = new HashMap<String, EOQualifierBinding>();
        for (EOQualifierBinding binding : this.getAllBindings()) {
            if (bindings.containsKey(binding.getName())) continue;
            bindings.put(binding.getName(), binding);
        }
        return new PropertyListSet<EOQualifierBinding>(bindings.values());
    }

    public Set<EOQualifierBinding> getQualifierOrderDistinctBindings() {
        LinkedHashMap<String, EOQualifierBinding> bindings = new LinkedHashMap<String, EOQualifierBinding>();
        for (EOQualifierBinding binding : this.getAllBindings()) {
            if (bindings.containsKey(binding.getName())) continue;
            bindings.put(binding.getName(), binding);
        }
        return new LinkedHashSet<EOQualifierBinding>(bindings.values());
    }

    @Override
    public Set getReferenceFailures() {
        return new HashSet();
    }

    public void _setEntity(EOEntity _entity) {
        this.myEntity = _entity;
    }

    @Override
    public void propertyChange(PropertyChangeEvent _event) {
        Object source = _event.getSource();
        if (source instanceof EOSortOrdering) {
            this.firePropertyChange(SORT_ORDERING, null, source);
        }
    }

    @Override
    protected void _propertyChanged(String _propertyName, Object _oldValue, Object _newValue) {
        if (this.myEntity != null) {
            this.myEntity._fetchSpecificationChanged(this, _propertyName, _oldValue, _newValue);
        }
    }

    @Override
    public void setName(String _name) throws DuplicateFetchSpecNameException {
        this.setName(_name, true);
    }

    public void setName(String _name, boolean _fireEvents) throws DuplicateFetchSpecNameException {
        if (this.myEntity != null) {
            this.myEntity._checkForDuplicateFetchSpecName(this, _name, null);
        }
        String oldName = this.myName;
        this.myName = _name;
        if (_fireEvents) {
            this.firePropertyChange(NAME, oldName, this.myName);
        }
    }

    @Override
    public String getName() {
        return this.myName;
    }

    public String getUppercaseUnderscoreName() {
        return StringUtils.camelCaseToUnderscore((String)this.getName()).toUpperCase();
    }

    public String getCapitalizedName() {
        String name = this.getName();
        if (name != null) {
            name = StringUtils.toUppercaseFirstLetter((String)name);
        }
        return name;
    }

    public String getInitialLowercaseName() {
        String name = this.getName();
        if (name != null) {
            name = StringUtils.toLowercaseFirstLetter((String)name);
        }
        return name;
    }

    public void addSortOrdering(EOSortOrdering _sortOrdering, boolean _fireEvents) {
        if (_fireEvents) {
            List<EOSortOrdering> oldSortOrderings = this.mySortOrderings;
            this.mySortOrderings = new LinkedList<EOSortOrdering>(this.mySortOrderings);
            this.mySortOrderings.add(_sortOrdering);
            this.firePropertyChange(SORT_ORDERINGS, oldSortOrderings, this.mySortOrderings);
        } else {
            this.mySortOrderings.add(_sortOrdering);
        }
        _sortOrdering.addPropertyChangeListener(this);
    }

    public void removeSortOrdering(EOSortOrdering _sortOrdering, boolean _fireEvents) {
        if (_fireEvents) {
            List<EOSortOrdering> oldSortOrderings = this.mySortOrderings;
            this.mySortOrderings = new LinkedList<EOSortOrdering>(this.mySortOrderings);
            this.mySortOrderings.remove(_sortOrdering);
            this.firePropertyChange(SORT_ORDERINGS, oldSortOrderings, this.mySortOrderings);
        } else {
            this.mySortOrderings.remove(_sortOrdering);
        }
        _sortOrdering.removePropertyChangeListener(this);
    }

    public void setSortOrderings(List<EOSortOrdering> _sortOrderings, boolean _fireEvents) {
        if (_fireEvents) {
            List<EOSortOrdering> oldSortOrderings = this.mySortOrderings;
            if (oldSortOrderings != null) {
                for (EOSortOrdering sortOrdering : oldSortOrderings) {
                    sortOrdering.removePropertyChangeListener(this);
                }
            }
            this.mySortOrderings = _sortOrderings;
            if (this.mySortOrderings != null) {
                for (EOSortOrdering sortOrdering : this.mySortOrderings) {
                    sortOrdering.addPropertyChangeListener(this);
                }
            }
            this.firePropertyChange(SORT_ORDERINGS, oldSortOrderings, this.mySortOrderings);
        } else {
            this.mySortOrderings = _sortOrderings;
        }
    }

    public List<EOSortOrdering> getSortOrderings() {
        return this.mySortOrderings;
    }

    public Boolean getSharesObjects() {
        return this.isSharesObjects();
    }

    public Boolean isSharesObjects() {
        return this.mySharesObjects;
    }

    public void setSharesObjects(Boolean _sharesObjects) {
        this.setSharesObjects(_sharesObjects, true);
    }

    public void setSharesObjects(Boolean _sharesObjects, boolean _fireEvents) {
        Boolean oldSharesObjects = this.mySharesObjects;
        this.mySharesObjects = _sharesObjects;
        if (_fireEvents) {
            this.firePropertyChange(SHARES_OBJECTS, oldSharesObjects, this.mySharesObjects);
        }
    }

    public void useQualifier() {
        this.setCustomQueryExpression(null);
        this.setStoredProcedure(null);
    }

    public boolean isUsingQualifier() {
        return this.myCustomQueryExpression == null && this.myStoredProcedure == null;
    }

    public boolean isUsingCustomQuery() {
        return this.myCustomQueryExpression != null && this.myStoredProcedure == null;
    }

    public boolean isUsingStoredProcedure() {
        return this.myCustomQueryExpression == null && this.myStoredProcedure != null;
    }

    public void useCustomQueryExpression() {
        this.setCustomQueryExpression("");
    }

    public void setCustomQueryExpression(String _customQueryExpression) {
        if (_customQueryExpression != null) {
            this.setStoredProcedure(null);
        }
        if (_customQueryExpression != null || this.myCustomQueryExpression != null) {
            String oldCustomQueryExpression = this.myCustomQueryExpression;
            this.myCustomQueryExpression = _customQueryExpression;
            this.firePropertyChange(CUSTOM_QUERY_EXPRESSION, oldCustomQueryExpression, this.myCustomQueryExpression);
        }
    }

    public String getCustomQueryExpression() {
        return this.myCustomQueryExpression;
    }

    public void setStoredProcedure(EOStoredProcedure _storedProcedure) {
        if (_storedProcedure != null) {
            this.setCustomQueryExpression(null);
        }
        if (_storedProcedure != null || this.myStoredProcedure != null) {
            EOStoredProcedure oldStoredProcedure = this.myStoredProcedure;
            this.myStoredProcedure = _storedProcedure;
            this.firePropertyChange(STORED_PROCEDURE, oldStoredProcedure, this.myStoredProcedure);
        }
    }

    public EOStoredProcedure getStoredProcedure() {
        return this.myStoredProcedure;
    }

    public void setQualifier(EOQualifier _qualifier) {
        this.setQualifier(_qualifier, true);
    }

    public void setQualifier(EOQualifier _qualifier, boolean updateQualifierString) {
        EOQualifier oldQualifier = this.myQualifier;
        this.myQualifier = _qualifier;
        this.firePropertyChange(QUALIFIER, oldQualifier, this.myQualifier);
        if (updateQualifierString) {
            this.setQualifierString(EOQualifierFactory.toString(this.myQualifier), false);
        }
    }

    public EOQualifier getQualifier() {
        return this.myQualifier;
    }

    public void setQualifierString(String _qualifierString) {
        this.setQualifierString(_qualifierString, true);
    }

    public void setQualifierString(String _qualifierString, boolean updateQualifier) {
        String oldQualifierString = this.myQualifierString;
        this.myQualifierString = _qualifierString;
        if (updateQualifier) {
            try {
                EOQualifier qualifier = EOQualifierFactory.fromString(_qualifierString);
                this.setQualifier(qualifier, false);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                this.setQualifier(null, false);
                throw e;
            }
            finally {
                this.firePropertyChange(QUALIFIER_STRING, oldQualifierString, this.myQualifierString);
            }
        } else {
            this.firePropertyChange(QUALIFIER_STRING, oldQualifierString, this.myQualifierString);
        }
    }

    public String getQualifierString() {
        return this.myQualifierString;
    }

    public void setEntity(EOEntity _entity) {
        EOEntity oldEntity = this.myEntity;
        this._setEntity(_entity);
        this.firePropertyChange(ENTITY, oldEntity, this.myEntity);
    }

    @Override
    public EOEntity getEntity() {
        return this.myEntity;
    }

    public Boolean isDeep() {
        return this.myDeep;
    }

    public Boolean getDeep() {
        return this.isDeep();
    }

    public void setDeep(Boolean _deep) {
        Boolean oldDeep = this.myDeep;
        this.myDeep = _deep;
        this.firePropertyChange(DEEP, oldDeep, this.myDeep);
    }

    public Integer getFetchLimit() {
        return this.myFetchLimit;
    }

    public void setFetchLimit(Integer _fetchLimit) {
        Integer oldFetchLimit = this.myFetchLimit;
        this.myFetchLimit = _fetchLimit;
        this.firePropertyChange(FETCH_LIMIT, oldFetchLimit, this.myFetchLimit);
    }

    public Boolean isLocksObjects() {
        return this.myLocksObjects;
    }

    public Boolean getLocksObjects() {
        return this.isLocksObjects();
    }

    public void setLocksObjects(Boolean _locksObjects) {
        Boolean oldLocksObjects = this.myLocksObjects;
        this.myLocksObjects = _locksObjects;
        this.firePropertyChange(LOCKS_OBJECTS, oldLocksObjects, this.myLocksObjects);
    }

    public Collection<String> getPrefetchingRelationshipKeyPaths() {
        return this.myPrefetchingRelationshipKeyPaths;
    }

    public void addPrefetchingRelationshipKeyPath(String _prefetchingRelationshipKeyPath, boolean _fireEvents) {
        if (_fireEvents) {
            Set<String> oldPrefetchingRelationshipKeyPaths = this.myPrefetchingRelationshipKeyPaths;
            this.myPrefetchingRelationshipKeyPaths = new TreeSet<String>();
            if (oldPrefetchingRelationshipKeyPaths != null) {
                this.myPrefetchingRelationshipKeyPaths.addAll(oldPrefetchingRelationshipKeyPaths);
            }
            this.myPrefetchingRelationshipKeyPaths.add(_prefetchingRelationshipKeyPath);
            this.firePropertyChange(PREFETCHING_RELATIONSHIP_KEY_PATHS, oldPrefetchingRelationshipKeyPaths, this.myPrefetchingRelationshipKeyPaths);
        } else {
            this.myPrefetchingRelationshipKeyPaths.add(_prefetchingRelationshipKeyPath);
        }
    }

    public void removePrefetchingRelationshipKeyPath(String _prefetchingRelationshipKeyPath, boolean _fireEvents) {
        if (_fireEvents) {
            Set<String> oldPrefetchingRelationshipKeyPaths = this.myPrefetchingRelationshipKeyPaths;
            if (oldPrefetchingRelationshipKeyPaths != null) {
                this.myPrefetchingRelationshipKeyPaths = new TreeSet<String>();
                this.myPrefetchingRelationshipKeyPaths.addAll(oldPrefetchingRelationshipKeyPaths);
                this.myPrefetchingRelationshipKeyPaths.remove(_prefetchingRelationshipKeyPath);
            }
            this.firePropertyChange(PREFETCHING_RELATIONSHIP_KEY_PATHS, oldPrefetchingRelationshipKeyPaths, this.myPrefetchingRelationshipKeyPaths);
        } else {
            this.myPrefetchingRelationshipKeyPaths.remove(_prefetchingRelationshipKeyPath);
        }
    }

    public void fetchEnterpriseObjects() {
        Set<String> oldRawRowKeyPaths = this.myRawRowKeyPaths;
        this.myRawRowKeyPaths = null;
        this.firePropertyChange(RAW_ROW_KEY_PATHS, oldRawRowKeyPaths, this.myRawRowKeyPaths);
    }

    public void fetchAllAttributesAsRawRows() {
        Set<String> oldRawRowKeyPaths = this.myRawRowKeyPaths;
        this.myRawRowKeyPaths = new TreeSet<String>();
        this.firePropertyChange(RAW_ROW_KEY_PATHS, oldRawRowKeyPaths, this.myRawRowKeyPaths);
    }

    public void fetchSpecificAttributesAsRawRows() {
        if (this.myEntity != null) {
            for (String attributeName : this.myEntity.getAttributeNames()) {
                this.addRawRowKeyPath(attributeName, true);
            }
        }
    }

    public boolean isFetchEnterpriseObjects() {
        return this.myRawRowKeyPaths == null;
    }

    public boolean isFetchAllAttributesAsRawRows() {
        return this.myRawRowKeyPaths != null && this.myRawRowKeyPaths.isEmpty();
    }

    public boolean isFetchSpecificAttributesAsRawRows() {
        return this.myRawRowKeyPaths != null && !this.myRawRowKeyPaths.isEmpty();
    }

    public void addRawRowKeyPath(String _rawRowKeyPath, boolean _fireEvents) {
        if (_fireEvents) {
            Set<String> oldRawRowKeyPaths = this.myRawRowKeyPaths;
            this.myRawRowKeyPaths = new TreeSet<String>();
            if (oldRawRowKeyPaths != null) {
                this.myRawRowKeyPaths.addAll(oldRawRowKeyPaths);
            }
            this.myRawRowKeyPaths.add(_rawRowKeyPath);
            this.firePropertyChange(RAW_ROW_KEY_PATHS, oldRawRowKeyPaths, this.myRawRowKeyPaths);
        } else {
            this.myRawRowKeyPaths.add(_rawRowKeyPath);
        }
    }

    public void removeRawRowKeyPath(String _rawRowKeyPath, boolean _fireEvents) {
        if (_fireEvents) {
            Set<String> oldRawRowKeyPaths = this.myRawRowKeyPaths;
            if (oldRawRowKeyPaths != null) {
                this.myRawRowKeyPaths = new TreeSet<String>();
                this.myRawRowKeyPaths.addAll(oldRawRowKeyPaths);
                this.myRawRowKeyPaths.remove(_rawRowKeyPath);
            }
            this.firePropertyChange(RAW_ROW_KEY_PATHS, oldRawRowKeyPaths, this.myRawRowKeyPaths);
        } else {
            this.myRawRowKeyPaths.remove(_rawRowKeyPath);
        }
    }

    public Boolean isPromptsAfterFetchLimit() {
        return this.myPromptsAfterFetchLimit;
    }

    public Boolean getPromptsAfterFetchLimit() {
        return this.isPromptsAfterFetchLimit();
    }

    public void setPromptsAfterFetchLimit(Boolean _promptsAfterFetchLimit) {
        Boolean oldPromptsAfterFetchLimit = this.myPromptsAfterFetchLimit;
        this.myPromptsAfterFetchLimit = _promptsAfterFetchLimit;
        this.firePropertyChange(PROMPTS_AFTER_FETCH_LIMIT, oldPromptsAfterFetchLimit, this.myPromptsAfterFetchLimit);
    }

    public Collection<String> getRawRowKeyPaths() {
        return this.myRawRowKeyPaths;
    }

    public void setRawRowKeyPaths(Set<String> _rawRowKeyPaths) {
        this.myRawRowKeyPaths = _rawRowKeyPaths;
        this.firePropertyChange(RAW_ROW_KEY_PATHS, null, null);
    }

    public Boolean isRefreshesRefetchedObjects() {
        return this.myRefreshesRefetchedObjects;
    }

    public Boolean getRefreshesRefetchedObjects() {
        return this.isRefreshesRefetchedObjects();
    }

    public void setRefreshesRefetchedObjects(Boolean _refreshesRefetchedObjects) {
        Boolean oldRefreshesRefetchedObjects = this.myRefreshesRefetchedObjects;
        this.myRefreshesRefetchedObjects = _refreshesRefetchedObjects;
        this.firePropertyChange(REFRESHES_REFETCHED_OBJECTS, oldRefreshesRefetchedObjects, this.myRefreshesRefetchedObjects);
    }

    public Boolean isRequiresAllQualifierBindingVariables() {
        return this.myRequiresAllQualifierBindingVariables;
    }

    public Boolean getRequiresAllQualifierBindingVariables() {
        return this.isRequiresAllQualifierBindingVariables();
    }

    public void setRequiresAllQualifierBindingVariables(Boolean _requiresAllQualifierBindingVariables) {
        Boolean oldRequiresAllQualifierBindingVariables = this.myRequiresAllQualifierBindingVariables;
        this.myRequiresAllQualifierBindingVariables = _requiresAllQualifierBindingVariables;
        this.firePropertyChange(REQUIRES_ALL_QUALIFIER_BINDING_VARIABLES, oldRequiresAllQualifierBindingVariables, this.myRequiresAllQualifierBindingVariables);
    }

    public Boolean isUsesDistinct() {
        return this.myUsesDistinct;
    }

    public Boolean getUsesDistinct() {
        return this.isUsesDistinct();
    }

    public void setUsesDistinct(Boolean _usesDistinct) {
        Boolean oldUsesDistinct = this.myUsesDistinct;
        this.myUsesDistinct = _usesDistinct;
        this.firePropertyChange(USES_DISTINCT, oldUsesDistinct, this.myUsesDistinct);
    }

    public void loadFromMap(EOModelMap _map, Set _failures) {
        Map hintsMap;
        this.myFetchSpecMap = _map;
        this.myClass = _map.getString("class", true);
        this.myFetchLimit = _map.getInteger(FETCH_LIMIT);
        this.myDeep = _map.getBoolean("isDeep");
        this.myLocksObjects = _map.getBoolean(LOCKS_OBJECTS);
        this.myPrefetchingRelationshipKeyPaths = _map.getSet(PREFETCHING_RELATIONSHIP_KEY_PATHS, true);
        this.myPromptsAfterFetchLimit = _map.getBoolean("prompsAfterFetchLimit");
        Map qualifierMap = _map.getMap(QUALIFIER);
        if (qualifierMap != null) {
            this.myQualifier = EOQualifierFactory.createQualifierFromQualifierMap(new EOModelMap(qualifierMap));
            this.myQualifierString = EOQualifierFactory.toString(this.myQualifier);
        }
        this.myRawRowKeyPaths = _map.getSet(RAW_ROW_KEY_PATHS, true);
        this.myRefreshesRefetchedObjects = _map.getBoolean(REFRESHES_REFETCHED_OBJECTS);
        this.myRequiresAllQualifierBindingVariables = _map.getBoolean(REQUIRES_ALL_QUALIFIER_BINDING_VARIABLES);
        this.myUsesDistinct = _map.getBoolean(USES_DISTINCT);
        this.loadUserInfo(_map);
        List sortOrderings = _map.getList(SORT_ORDERINGS);
        if (sortOrderings != null) {
            for (Map originalSortOrderingMap : sortOrderings) {
                EOModelMap sortOrderingMap = new EOModelMap(originalSortOrderingMap);
                EOSortOrdering sortOrdering = new EOSortOrdering();
                sortOrdering.loadFromMap(sortOrderingMap);
                this.addSortOrdering(sortOrdering, false);
            }
        }
        if ((hintsMap = _map.getMap("hints")) != null) {
            this.myCustomQueryExpression = (String)hintsMap.get("EOCustomQueryExpressionHintKey");
        }
    }

    public EOModelMap toMap() {
        EOModelMap fetchSpecMap = this.myFetchSpecMap.cloneModelMap();
        if (this.myEntity != null) {
            fetchSpecMap.setString("entityName", this.myEntity.getName(), true);
        }
        fetchSpecMap.setString("class", this.myClass, true);
        fetchSpecMap.setInteger(FETCH_LIMIT, this.myFetchLimit);
        fetchSpecMap.setBoolean("isDeep", this.myDeep, 1);
        fetchSpecMap.setBoolean(LOCKS_OBJECTS, this.myLocksObjects, 1);
        if (this.myPrefetchingRelationshipKeyPaths == null || !this.myPrefetchingRelationshipKeyPaths.equals(fetchSpecMap.get(PREFETCHING_RELATIONSHIP_KEY_PATHS))) {
            fetchSpecMap.setSet(PREFETCHING_RELATIONSHIP_KEY_PATHS, this.myPrefetchingRelationshipKeyPaths, false);
        }
        fetchSpecMap.setBoolean("prompsAfterFetchLimit", this.myPromptsAfterFetchLimit, 1);
        if (this.myQualifier == null) {
            fetchSpecMap.setMap(QUALIFIER, null, true);
        } else {
            fetchSpecMap.setMap(QUALIFIER, EOQualifierFactory.createQualifierMapFromQualifier(this.myQualifier), true);
        }
        if (this.myRawRowKeyPaths != null && this.myRawRowKeyPaths.equals(this.myFetchSpecMap.get(RAW_ROW_KEY_PATHS))) {
            fetchSpecMap.setSet(RAW_ROW_KEY_PATHS, (Set)this.myFetchSpecMap.get(RAW_ROW_KEY_PATHS), false);
        } else {
            fetchSpecMap.setSet(RAW_ROW_KEY_PATHS, this.myRawRowKeyPaths, false);
        }
        fetchSpecMap.setBoolean(REFRESHES_REFETCHED_OBJECTS, this.myRefreshesRefetchedObjects, 1);
        fetchSpecMap.setBoolean(REQUIRES_ALL_QUALIFIER_BINDING_VARIABLES, this.myRequiresAllQualifierBindingVariables, 1);
        fetchSpecMap.setBoolean(USES_DISTINCT, this.myUsesDistinct, 1);
        this.writeUserInfo(fetchSpecMap);
        LinkedList<EOModelMap> sortOrderings = new LinkedList<EOModelMap>();
        for (EOSortOrdering sortOrdering : this.mySortOrderings) {
            EOModelMap sortOrderingMap = sortOrdering.toMap();
            sortOrderings.add(sortOrderingMap);
        }
        fetchSpecMap.setList(SORT_ORDERINGS, sortOrderings, true);
        PropertyListMap rawHintsMap = fetchSpecMap.getMap("hints", true);
        if (rawHintsMap == null) {
            rawHintsMap = new PropertyListMap();
        }
        EOModelMap hintsMap = new EOModelMap(rawHintsMap);
        hintsMap.setString("EOCustomQueryExpressionHintKey", this.myCustomQueryExpression, false);
        String storedProcedureName = this.myStoredProcedure != null ? this.myStoredProcedure.getName() : null;
        hintsMap.setString("EOStoredProcedureNameHintKey", storedProcedureName, true);
        fetchSpecMap.setMap("hints", hintsMap, true);
        return fetchSpecMap;
    }

    public void resolve(Set<EOModelVerificationFailure> _failures) {
        String storedProcedureName;
        Map hintsMap = this.myFetchSpecMap.getMap("hints");
        if (hintsMap != null && (storedProcedureName = (String)hintsMap.get("EOStoredProcedureNameHintKey")) != null) {
            this.myStoredProcedure = this.myEntity.getModel().getStoredProcedureNamed(storedProcedureName);
            if (this.myStoredProcedure == null) {
                _failures.add(new EOModelVerificationFailure(this.myEntity.getModel(), this, "The fetch specification " + this.getName() + " specifies a stored procedure name '" + this.myStoredProcedure + "' which does not exist.", false));
            }
        }
    }

    public void verify(Set<EOModelVerificationFailure> _failures) {
        if (this.myQualifierString != null && this.myQualifierString.length() > 0 && this.myQualifier == null) {
            String reason;
            try {
                EOQualifierFactory.fromString(this.myQualifierString);
                reason = "Unknown failure.";
            }
            catch (Throwable t) {
                reason = StringUtils.getErrorMessage((Throwable)t);
            }
            _failures.add(new EOModelVerificationFailure(this.myEntity.getModel(), this, "The fetch specification " + this.getName() + " specifies an invalid qualifier, and cannot be saved: " + reason, false));
        } else if (this.myQualifier != null) {
            EOEntity entity = this.getEntity();
            Set<String> qualifierKeys = EOQualifierFactory.getQualifierKeysFromQualifier(this.myQualifier);
            for (String qualifierKey : qualifierKeys) {
                AbstractEOAttributePath definitionPath = entity.resolveKeyPath(qualifierKey);
                if (definitionPath != null && definitionPath.isValid()) continue;
            }
        }
        for (EOSortOrdering sortOrdering : this.mySortOrderings) {
            sortOrdering.verify(_failures);
        }
        if (this.myCustomQueryExpression != null && this.myCustomQueryExpression.trim().length() == 0) {
            _failures.add(new EOModelVerificationFailure(this.myEntity.getModel(), this, "The fetch specification " + this.getName() + " has an empty custom SQL expression.", false));
        }
        if (this.myCustomQueryExpression != null && this.myStoredProcedure != null) {
            _failures.add(new EOModelVerificationFailure(this.myEntity.getModel(), this, "The fetch specification " + this.getName() + " specifies a custom SQL expression AND a stored procedure name, which is invalid.", false));
        }
    }

    @Override
    public String getFullyQualifiedName() {
        return (this.myEntity == null ? "?" : this.myEntity.getFullyQualifiedName()) + "/fspec: " + this.getName();
    }

    public EOFetchSpecification _cloneModelObject() {
        EOFetchSpecification fetchSpec = new EOFetchSpecification(this.myName);
        fetchSpec.myClass = this.myClass;
        fetchSpec.myFetchLimit = this.myFetchLimit;
        fetchSpec.myDeep = this.myDeep;
        fetchSpec.myLocksObjects = this.myLocksObjects;
        if (this.myPrefetchingRelationshipKeyPaths != null) {
            fetchSpec.myPrefetchingRelationshipKeyPaths = new TreeSet<String>();
            fetchSpec.myPrefetchingRelationshipKeyPaths.addAll(this.myPrefetchingRelationshipKeyPaths);
        }
        fetchSpec.myPromptsAfterFetchLimit = this.myPromptsAfterFetchLimit;
        if (this.myRawRowKeyPaths != null) {
            fetchSpec.myRawRowKeyPaths = new TreeSet<String>();
            fetchSpec.myRawRowKeyPaths.addAll(this.myRawRowKeyPaths);
        }
        fetchSpec.myRefreshesRefetchedObjects = this.myRefreshesRefetchedObjects;
        fetchSpec.myRequiresAllQualifierBindingVariables = this.myRequiresAllQualifierBindingVariables;
        fetchSpec.myUsesDistinct = this.myUsesDistinct;
        fetchSpec.mySortOrderings.addAll(this.mySortOrderings);
        if (this.myQualifier != null) {
            fetchSpec.myQualifier = EOQualifierFactory.createQualifierFromQualifierMap(EOQualifierFactory.createQualifierMapFromQualifier(this.myQualifier));
        }
        fetchSpec.mySharesObjects = this.mySharesObjects;
        this._cloneUserInfoInto(fetchSpec);
        return fetchSpec;
    }

    @Override
    public Class<EOEntity> _getModelParentType() {
        return EOEntity.class;
    }

    @Override
    public EOEntity _getModelParent() {
        return this.getEntity();
    }

    @Override
    public void _removeFromModelParent(Set<EOModelVerificationFailure> failures) {
        this.getEntity().removeFetchSpecification(this);
    }

    @Override
    public void _addToModelParent(EOEntity modelParent, boolean findUniqueName, Set<EOModelVerificationFailure> failures) throws EOModelException {
        if (findUniqueName) {
            this.setName(modelParent.findUnusedFetchSpecificationName(this.getName()));
        }
        modelParent.addFetchSpecification(this);
    }

    public String toString() {
        return "[EOFetchSpecification: name = " + this.myName + "]";
    }
}

