/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.core.model.qualifier;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.objectstyle.wolips.eomodeler.core.model.qualifier.EOAndQualifier;
import org.objectstyle.wolips.eomodeler.core.model.qualifier.EOKeyComparisonQualifier;
import org.objectstyle.wolips.eomodeler.core.model.qualifier.EOKeyValueQualifier;
import org.objectstyle.wolips.eomodeler.core.model.qualifier.EONamedQualifierVariable;
import org.objectstyle.wolips.eomodeler.core.model.qualifier.EONotQualifier;
import org.objectstyle.wolips.eomodeler.core.model.qualifier.EOOrQualifier;
import org.objectstyle.wolips.eomodeler.core.model.qualifier.EOQualifier;
import org.objectstyle.wolips.eomodeler.core.model.qualifier.EOQualifierVariable;
import org.objectstyle.wolips.eomodeler.core.model.qualifier.EOTruePredicate;

public class EOQualifierParser {
    private static final int NONE = 0;
    private static final int IN_SINGLE_QUOTE = 1;
    private static final int IN_DOUBLE_QUOTE = 2;
    private static final int ESCAPED = 3;
    private static final int IN_NUMBER = 4;
    private static final int IN_OPERATOR = 5;
    private static final int IN_KEYWORD = 6;
    private static final int IN_VARIABLE = 7;
    private static final int IN_BINDING_KEY = 8;
    private static Set<String> OPERATORS = new HashSet<String>();
    private static Set<String> SELECTORS;
    private List<Token> _tokens;
    private String _qualifierString;
    private int _offset;
    private int _tokenStartOffset;
    private int _length;
    private int _tokenNum;

    protected String caseCorrectedSelectorName(String possibleSelector) {
        for (String selector : SELECTORS) {
            if (!selector.equalsIgnoreCase(possibleSelector)) continue;
            return selector;
        }
        return null;
    }

    protected String caseCorrectedOperatorName(String possibleOperator) {
        for (String operator : OPERATORS) {
            if (!operator.equalsIgnoreCase(possibleOperator)) continue;
            return operator;
        }
        return null;
    }

    public synchronized EOQualifier parseQualifier(String qualifierString) throws ParseException {
        this._tokens = new LinkedList<Token>();
        this._qualifierString = qualifierString;
        this._length = this._qualifierString.length();
        this._offset = 0;
        this._tokenStartOffset = -1;
        this._tokenNum = 0;
        this.tokenize(false);
        EOQualifier qualifier = this.qualifierForTokens(0, true);
        return qualifier;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected EOQualifier qualifierForTokens(int depth, boolean allowAggregateQualifiers) throws ParseException {
        EOQualifier rqualifier;
        Token lvalue;
        EOQualifier lqualifier;
        block17: {
            block19: {
                Token rvalue;
                EOQualifier.Comparison selector;
                Token operator;
                block22: {
                    block21: {
                        block20: {
                            block18: {
                                lqualifier = null;
                                lvalue = this.popToken();
                                if (!(lvalue instanceof OpenParenToken)) break block18;
                                lqualifier = this.qualifierForTokens(depth + 1, true);
                                break block17;
                            }
                            if (!(lvalue instanceof KeywordToken) && !(lvalue instanceof KeypathToken)) break block19;
                            if (!"TRUEPREDICATE".equalsIgnoreCase(lvalue.getValue())) break block20;
                            lqualifier = new EOTruePredicate();
                            break block17;
                        }
                        operator = this.popToken();
                        if (!(operator instanceof OperatorToken) && !(operator instanceof KeywordToken)) {
                            if (operator != null) throw new ParseException(lvalue + ", " + operator + " is an invalid token sequence at offset " + lvalue.getOffset() + ".", lvalue.getOffset());
                            throw new ParseException("Expected an operator after " + lvalue + " at offset " + lvalue.getOffset() + ".", lvalue.getOffset());
                        }
                        selector = new EOQualifier.Comparison(operator.getValue());
                        rvalue = this.popToken();
                        if (!(rvalue instanceof NamedVariableToken)) break block21;
                        lqualifier = new EOKeyValueQualifier(lvalue.getValue(), selector, (Object)new EONamedQualifierVariable(rvalue.getValue()));
                        break block17;
                    }
                    if (!(rvalue instanceof VariableToken) && !(rvalue instanceof NamedVariableToken)) break block22;
                    lqualifier = new EOKeyValueQualifier(lvalue.getValue(), selector, (Object)new EOQualifierVariable(rvalue.getValue()));
                    break block17;
                }
                if (rvalue instanceof NumberToken) {
                    lqualifier = new EOKeyValueQualifier(lvalue.getValue(), selector, (Object)((NumberToken)rvalue).toNumber());
                    break block17;
                } else if (rvalue instanceof LiteralToken) {
                    String value = rvalue.getValue();
                    if (value != null) {
                        value = value.replaceAll("\\\\(.)", "$1");
                    }
                    lqualifier = new EOKeyValueQualifier(lvalue.getValue(), selector, (Object)value);
                    break block17;
                } else {
                    if (!(rvalue instanceof KeywordToken) && !(rvalue instanceof KeypathToken)) {
                        if (rvalue != null) throw new ParseException(lvalue + ", " + operator + ", " + rvalue + " is an invalid token sequence at offset " + lvalue.getOffset() + ".", lvalue.getOffset());
                        throw new ParseException("Expected a qualifier after " + lvalue + " " + operator + " at offset " + lvalue.getOffset() + ".", lvalue.getOffset());
                    }
                    lqualifier = new EOKeyComparisonQualifier(lvalue.getValue(), selector, rvalue.getValue());
                }
                break block17;
            }
            if (lvalue instanceof NotToken) {
                lqualifier = new EONotQualifier(this.qualifierForTokens(depth + 1, false));
            } else if (lvalue != null) {
                throw new ParseException("Invalid token " + lvalue + " at offset " + lvalue.getOffset() + ".", lvalue.getOffset());
            }
        }
        if (lvalue == null) {
            return null;
        }
        Token nextToken = this.popToken();
        if (nextToken == null) {
            return lqualifier;
        }
        if (nextToken instanceof CloseParenToken) {
            if (depth <= 0) throw new ParseException("Invalid close paren at offset " + nextToken.getOffset() + ".", nextToken.getOffset());
            return lqualifier;
        }
        if (!allowAggregateQualifiers) {
            EOQualifier qualifier = lqualifier;
            this.pushToken(nextToken);
            return qualifier;
        }
        if (nextToken instanceof AndToken) {
            rqualifier = this.qualifierForTokens(depth, true);
            if (rqualifier == null) {
                throw new ParseException("'and' requires a second qualifier at offset " + nextToken.getOffset() + ".", nextToken.getOffset());
            }
            return new EOAndQualifier(lqualifier, rqualifier);
        }
        if (!(nextToken instanceof OrToken)) throw new ParseException("Illegal token " + nextToken + " at offset " + nextToken.getOffset() + ".", nextToken.getOffset());
        rqualifier = this.qualifierForTokens(depth, true);
        if (rqualifier == null) {
            throw new ParseException("'or' requires a second qualifier at offset " + nextToken.getOffset() + ".", nextToken.getOffset());
        }
        return new EOOrQualifier(lqualifier, rqualifier);
    }

    protected void pushToken(Token token) {
        this._tokens.add(0, token);
    }

    protected Token popToken() {
        Token token = null;
        if (this._tokenNum < this._tokens.size()) {
            token = this._tokens.get(this._tokenNum++);
        }
        return token;
    }

    protected void tokenize(boolean parentInParen) throws ParseException {
        int groupStartOffset = this._offset;
        boolean inParen = parentInParen;
        int state = 0;
        this._tokenStartOffset = -1;
        int previousState = 0;
        while (this._offset < this._length) {
            char ch = this._qualifierString.charAt(this._offset++);
            if (state == 3) {
                state = previousState;
                continue;
            }
            if (ch == '\\') {
                if (state == 2 || state == 1) {
                    previousState = state;
                    state = 3;
                    continue;
                }
                throw new ParseException("Backslash in invalid state " + state + " at offset " + this._offset + ".", this._offset);
            }
            if (ch == '\"') {
                if (state == 2) {
                    this.endPendingToken(state);
                    state = 0;
                    continue;
                }
                if (state == 1) continue;
                this.endPendingToken(state);
                this._tokenStartOffset = this._offset + 1;
                state = 2;
                continue;
            }
            if (ch == '\'') {
                if (state == 1) {
                    this.endPendingToken(state);
                    state = 0;
                    continue;
                }
                if (state == 2) continue;
                this.endPendingToken(state);
                this._tokenStartOffset = this._offset + 1;
                state = 1;
                continue;
            }
            if (state == 1 || state == 2) continue;
            if (state == 7) {
                if (ch == 's' || ch == 'd' || ch == 'f' || ch == 'f' || ch == '@' || ch == 'K' || ch == '%') {
                    this._tokens.add(new VariableToken(this._offset - 2, "%" + ch));
                    state = 0;
                    this._tokenStartOffset = -1;
                    continue;
                }
                throw new ParseException("Unknown variable %" + ch + " at offset " + (this._offset - 1) + ".", this._offset - 1);
            }
            if (ch == '%') {
                this.endPendingToken(state);
                this._tokenStartOffset = this._offset;
                state = 7;
                continue;
            }
            if (ch == '$') {
                this.endPendingToken(state);
                this._tokenStartOffset = this._offset;
                state = 8;
                continue;
            }
            if (ch == '(') {
                this.endPendingToken(state);
                this._tokens.add(new OpenParenToken(this._offset - 1));
                this.tokenize(true);
                continue;
            }
            if (ch == ')') {
                if (!inParen) {
                    throw new ParseException("Close paren without open paren at offset " + (this._offset - 1) + ".", this._offset - 1);
                }
                this.endPendingToken(state);
                this._tokens.add(new CloseParenToken(this._offset - 1));
                state = 0;
                inParen = false;
                break;
            }
            if (Character.isWhitespace(ch)) {
                this.endPendingToken(state);
                state = 0;
                continue;
            }
            if (ch == '<' || ch == '>' || ch == '=') {
                if (state == 5) continue;
                this.endPendingToken(state);
                this._tokenStartOffset = this._offset;
                state = 5;
                continue;
            }
            if (Character.isJavaIdentifierStart(ch)) {
                if (state == 4) {
                    throw new ParseException("Unexpected character " + ch + " at offset " + (this._offset - 1) + ".", this._offset - 1);
                }
                if (state == 6 || state == 8) continue;
                if (state == 5) {
                    this.endPendingToken(state);
                    state = 6;
                    this._tokenStartOffset = this._offset;
                    continue;
                }
                if (state == 0) {
                    state = 6;
                    this._tokenStartOffset = this._offset;
                    continue;
                }
                throw new ParseException("Unexpected character " + ch + " at offset " + (this._offset - 1) + ".", this._offset - 1);
            }
            if ((Character.isJavaIdentifierPart(ch) || ch == '.') && (state == 6 || state == 8)) continue;
            if (Character.isDigit(ch) || ch == '.' || ch == '-' || ch == ':') {
                if (state == 4 || state == 6 || state == 8) continue;
                if (state == 5) {
                    this.endPendingToken(state);
                    state = 4;
                    this._tokenStartOffset = this._offset;
                    continue;
                }
                if (state == 0) {
                    state = 4;
                    this._tokenStartOffset = this._offset;
                    continue;
                }
                throw new ParseException("Unexpected number " + ch + " at offset " + (this._offset - 1) + ".", this._offset - 1);
            }
            throw new ParseException("Unexpected character " + ch + " at offset " + (this._offset - 1) + ".", this._offset - 1);
        }
        if (state == 1) {
            throw new ParseException("Missing closing ' starting at offset " + this._tokenStartOffset + ".", this._tokenStartOffset);
        }
        if (state == 2) {
            throw new ParseException("Missing closing \" starting at offset " + this._tokenStartOffset + ".", this._tokenStartOffset);
        }
        if (state == 3) {
            throw new ParseException("Backslash found without escaped character at offset " + (this._offset - 1) + ".", this._offset - 1);
        }
        if (state == 7) {
            throw new ParseException("Percent found without variable character at offset " + (this._offset - 1) + ".", this._offset - 1);
        }
        if (inParen) {
            throw new ParseException("Missing closing paren starting at offset " + groupStartOffset + ".", groupStartOffset);
        }
        if (state == 6 || state == 4 || state == 8) {
            ++this._offset;
        }
        this.endPendingToken(state);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void endPendingToken(int state) throws ParseException {
        void var4_19;
        if (this._tokenStartOffset == -1) return;
        int startOffset = this._tokenStartOffset - 1;
        String value = this._qualifierString.substring(startOffset, this._offset - 1);
        if (state == 2 || state == 1) {
            LiteralToken literalToken = new LiteralToken(this._tokenStartOffset - 1, value);
        } else if (state == 5) {
            String operator = this.caseCorrectedOperatorName(value);
            if (operator == null) throw new ParseException("Unknown operator " + value + " at offset " + (this._tokenStartOffset - 1) + ".", this._tokenStartOffset - 1);
            OperatorToken operatorToken = new OperatorToken(startOffset, value);
        } else if (state == 4) {
            NumberToken numberToken = new NumberToken(startOffset, value);
        } else if (state == 8) {
            if (value == null || value.length() == 0) {
                throw new ParseException("A variable has no name at offset " + (this._tokenStartOffset - 1) + ".", this._tokenStartOffset - 1);
            }
            NamedVariableToken namedVariableToken = new NamedVariableToken(startOffset, value.substring(1));
        } else if (state == 6) {
            String operator = this.caseCorrectedOperatorName(value);
            String selector = this.caseCorrectedSelectorName(value);
            if (operator != null) {
                OperatorToken operatorToken = new OperatorToken(startOffset, operator);
            } else if (selector != null) {
                SelectorToken selectorToken = new SelectorToken(startOffset, selector);
            } else if (OPERATORS.contains(value.toLowerCase())) {
                OperatorToken operatorToken = new OperatorToken(startOffset, value);
            } else if (value.equalsIgnoreCase("and")) {
                AndToken andToken = new AndToken(startOffset);
            } else if (value.equalsIgnoreCase("or")) {
                OrToken orToken = new OrToken(startOffset);
            } else if (value.equalsIgnoreCase("not")) {
                NotToken notToken = new NotToken(startOffset);
            } else if (value.equalsIgnoreCase("null") || value.equalsIgnoreCase("nil")) {
                LiteralToken literalToken = new LiteralToken(startOffset, null);
            } else if (value.contains(".")) {
                KeypathToken keypathToken = new KeypathToken(startOffset, value);
            } else {
                KeywordToken keywordToken = new KeywordToken(startOffset, value);
            }
        } else {
            Token token = new Token(startOffset, value);
        }
        this._tokens.add((Token)var4_19);
        this._tokenStartOffset = -1;
    }

    public static void main(String[] args) {
        try {
            EOQualifierParser parser = new EOQualifierParser();
            EOQualifier q1 = parser.parseQualifier("a = b and not (status = $notStatus) and voucherID = $voucherID");
            System.out.println("EOQualifierParser.main: " + q1);
        }
        catch (Throwable t) {
            t.printStackTrace(System.out);
        }
    }

    static {
        OPERATORS.add("=");
        OPERATORS.add(">");
        OPERATORS.add("<");
        OPERATORS.add("==");
        OPERATORS.add(">=");
        OPERATORS.add("<=");
        OPERATORS.add("<>");
        OPERATORS.add("contains");
        OPERATORS.add("like");
        OPERATORS.add("caseinsensitivelike");
        SELECTORS = new HashSet<String>();
        SELECTORS.add("isEqualTo");
        SELECTORS.add("isNotEqualTo");
        SELECTORS.add("isLessThan");
        SELECTORS.add("isGreaterThan");
        SELECTORS.add("isLessThanOrEqualTo");
        SELECTORS.add("isGreaterThanOrEqualTo");
        SELECTORS.add("doesContain");
        SELECTORS.add("isLike");
        SELECTORS.add("isCaseInsensitiveLike");
    }

    protected static class NamedVariableToken
    extends Token {
        public NamedVariableToken(int offset, String value) {
            super(offset, value);
        }

        @Override
        public String toString() {
            return "[NamedVariable: " + this.getValue() + "]";
        }
    }

    protected static class VariableToken
    extends Token {
        public VariableToken(int offset, String value) {
            super(offset, value);
        }

        @Override
        public String toString() {
            return "[Variable: " + this.getValue() + "]";
        }
    }

    protected static class NumberToken
    extends Token {
        public NumberToken(int offset, String value) {
            super(offset, value);
        }

        public Number toNumber() {
            String value = this.getValue();
            Number number = value.contains(".") ? new BigDecimal(value) : Integer.valueOf(Integer.parseInt(value));
            return number;
        }

        @Override
        public String toString() {
            return "[Number: " + this.getValue() + "]";
        }
    }

    protected static class OperatorToken
    extends Token {
        public OperatorToken(int offset, String value) {
            super(offset, value);
        }

        @Override
        public String toString() {
            return "[Operator: " + this.getValue() + "]";
        }
    }

    protected static class LiteralToken
    extends Token {
        public LiteralToken(int offset, String value) {
            super(offset, value);
        }

        @Override
        public String toString() {
            return "[Literal: " + this.getValue() + "]";
        }
    }

    protected static class KeypathToken
    extends Token {
        public KeypathToken(int offset, String value) {
            super(offset, value);
        }

        @Override
        public String toString() {
            return "[Keypath: " + this.getValue() + "]";
        }
    }

    protected static class SelectorToken
    extends OperatorToken {
        public SelectorToken(int offset, String value) {
            super(offset, value);
        }

        @Override
        public String toString() {
            return "[Selector: " + this.getValue() + "]";
        }
    }

    protected static class CloseParenToken
    extends OperatorToken {
        public CloseParenToken(int offset) {
            super(offset, ")");
        }

        @Override
        public String toString() {
            return "[CloseParen]";
        }
    }

    protected static class OpenParenToken
    extends OperatorToken {
        public OpenParenToken(int offset) {
            super(offset, "(");
        }

        @Override
        public String toString() {
            return "[OpenParen]";
        }
    }

    protected static class KeywordToken
    extends Token {
        public KeywordToken(int offset, String value) {
            super(offset, value);
        }

        @Override
        public String toString() {
            return "[Keyword: " + this.getValue() + "]";
        }
    }

    protected static class NotToken
    extends Token {
        public NotToken(int offset) {
            super(offset, "not");
        }

        @Override
        public String toString() {
            return "[Not]";
        }
    }

    protected static class OrToken
    extends Token {
        public OrToken(int offset) {
            super(offset, "or");
        }

        @Override
        public String toString() {
            return "[Or]";
        }
    }

    protected static class AndToken
    extends Token {
        public AndToken(int offset) {
            super(offset, "and");
        }

        @Override
        public String toString() {
            return "[And]";
        }
    }

    protected static class Token {
        private int _offset;
        private String _value;

        public Token(int offset, String value) {
            this._offset = offset;
            this._value = value;
        }

        public int getOffset() {
            return this._offset;
        }

        public String getValue() {
            return this._value;
        }

        public String toString() {
            return "[Token: " + this._value + "]";
        }
    }
}

