/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.baseforplugins.util;

import java.io.File;
import org.eclipse.core.resources.IResource;

public class ResourceUtilities {
    public static String getFileNameWithoutExtension(IResource resource) {
        String fileName = null;
        if (resource != null) {
            fileName = ResourceUtilities.getFileNameWithoutExtension(resource.getName());
        }
        return fileName;
    }

    public static String getFileNameWithoutExtension(File file) {
        String fileName = null;
        if (file != null) {
            fileName = ResourceUtilities.getFileNameWithoutExtension(file.getName());
        }
        return fileName;
    }

    public static String getFileNameWithoutExtension(String fileName) {
        int lastDotIndex;
        String fileNameWithoutExtension = fileName;
        if (fileNameWithoutExtension != null && (lastDotIndex = fileNameWithoutExtension.lastIndexOf(46)) != -1) {
            fileNameWithoutExtension = fileNameWithoutExtension.substring(0, lastDotIndex);
        }
        return fileNameWithoutExtension;
    }

    public static String getLocalizationName(IResource file) {
        String language = null;
        if (file != null && file.exists()) {
            boolean done = false;
            IResource resource = file;
            do {
                if ((resource = resource.getParent()) == null) {
                    done = true;
                    continue;
                }
                String name = resource.getName();
                if (!name.endsWith(".lproj")) continue;
                language = name.substring(0, name.length() - ".lproj".length());
                done = true;
            } while (!done);
        }
        return language;
    }
}

