/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.core.utils;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class NotificationMap<U, V>
implements Map<U, V>,
Cloneable {
    public static final String CONTENTS = "__contents__";
    private Map<U, V> myMap;
    private PropertyChangeSupport myPropertyChangeSupport;

    public NotificationMap() {
        this(null);
    }

    public NotificationMap(Map<U, V> _map) {
        this.myMap = _map == null ? new HashMap<U, V>() : _map;
        this.myPropertyChangeSupport = new PropertyChangeSupport(this);
    }

    public NotificationMap<U, V> clone() throws CloneNotSupportedException {
        NotificationMap<U, V> map = new NotificationMap<U, V>(new HashMap<U, V>(this.myMap));
        return map;
    }

    @Override
    public void clear() {
        this.myMap.clear();
        this.myPropertyChangeSupport.firePropertyChange(CONTENTS, null, null);
    }

    @Override
    public boolean containsKey(Object _key) {
        return this.myMap.containsKey(_key);
    }

    @Override
    public boolean containsValue(Object _value) {
        return this.myMap.containsValue(_value);
    }

    @Override
    public Set<Map.Entry<U, V>> entrySet() {
        return this.myMap.entrySet();
    }

    @Override
    public boolean equals(Object _o) {
        return this.myMap.equals(_o);
    }

    @Override
    public V get(Object _key) {
        return this.myMap.get(_key);
    }

    @Override
    public int hashCode() {
        return this.myMap.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.myMap.isEmpty();
    }

    @Override
    public Set<U> keySet() {
        return this.myMap.keySet();
    }

    @Override
    public V put(U _key, V _value) {
        V oldValue = this.myMap.put(_key, _value);
        if (_key instanceof String) {
            this.myPropertyChangeSupport.firePropertyChange((String)_key, oldValue, _value);
            if (oldValue == null) {
                this.myPropertyChangeSupport.firePropertyChange(CONTENTS, null, null);
            }
        } else {
            this.myPropertyChangeSupport.firePropertyChange(CONTENTS, null, null);
        }
        return oldValue;
    }

    public V _putWithoutEvents(U _key, V _value) {
        V oldValue = this.myMap.put(_key, _value);
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends U, ? extends V> _t) {
        this.myMap.putAll(_t);
        this.myPropertyChangeSupport.firePropertyChange(CONTENTS, null, null);
    }

    @Override
    public V remove(Object _key) {
        V oldValue = this.myMap.remove(_key);
        if (_key instanceof String) {
            this.myPropertyChangeSupport.firePropertyChange((String)_key, oldValue, null);
            this.myPropertyChangeSupport.firePropertyChange(CONTENTS, null, null);
        } else {
            this.myPropertyChangeSupport.firePropertyChange(CONTENTS, null, null);
        }
        return oldValue;
    }

    public V _removeWithoutEvents(Object _key) {
        V oldValue = this.myMap.remove(_key);
        return oldValue;
    }

    @Override
    public int size() {
        return this.myMap.size();
    }

    @Override
    public Collection<V> values() {
        return this.myMap.values();
    }

    public void addPropertyChangeListener(PropertyChangeListener _listener) {
        this.myPropertyChangeSupport.addPropertyChangeListener(_listener);
    }

    public void addPropertyChangeListener(String _propertyName, PropertyChangeListener _listener) {
        this.myPropertyChangeSupport.addPropertyChangeListener(_propertyName, _listener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.myPropertyChangeSupport.getPropertyChangeListeners();
    }

    public PropertyChangeListener[] getPropertyChangeListeners(String _propertyName) {
        return this.myPropertyChangeSupport.getPropertyChangeListeners(_propertyName);
    }

    public boolean hasListeners(String _propertyName) {
        return this.myPropertyChangeSupport.hasListeners(_propertyName);
    }

    public void removePropertyChangeListener(PropertyChangeListener _listener) {
        this.myPropertyChangeSupport.removePropertyChangeListener(_listener);
    }

    public void removePropertyChangeListener(String _propertyName, PropertyChangeListener _listener) {
        this.myPropertyChangeSupport.removePropertyChangeListener(_propertyName, _listener);
    }

    public String toString() {
        return this.myMap.toString();
    }
}

