/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.editors;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.operations.RedoActionHandler;
import org.eclipse.ui.operations.UndoActionHandler;
import org.objectstyle.wolips.eomodeler.actions.CopyAction;
import org.objectstyle.wolips.eomodeler.actions.CutAction;
import org.objectstyle.wolips.eomodeler.actions.DeleteAction;
import org.objectstyle.wolips.eomodeler.actions.PasteAction;
import org.objectstyle.wolips.eomodeler.editors.EOModelEditor;

public class EOModelClipboardHandler
implements ISelectionChangedListener {
    private CutAction _cutAction = new CutAction();
    private CopyAction _copyAction = new CopyAction();
    private PasteAction _pasteAction = new PasteAction();
    private DeleteAction _deleteAction = new DeleteAction();

    public void attach(IActionBars actionBars, final EOModelEditor editor) {
        if (actionBars != null && editor != null) {
            actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this._deleteAction);
            actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)this._cutAction);
            actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this._copyAction);
            actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this._pasteAction);
            actionBars.setGlobalActionHandler(ActionFactory.REVERT.getId(), (IAction)new Action(){

                public void run() {
                    editor.revert();
                }
            });
            actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)new UndoActionHandler(editor.getSite(), editor.getUndoContext()));
            actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)new RedoActionHandler(editor.getSite(), editor.getUndoContext()));
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        this._cutAction.selectionChanged(null, selection);
        this._copyAction.selectionChanged(null, selection);
        this._pasteAction.selectionChanged(null, selection);
        this._deleteAction.selectionChanged(null, selection);
    }
}

