/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.wodclipse.core.util;

import java.util.regex.Pattern;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.objectstyle.wolips.bindings.wod.IWodElement;
import org.objectstyle.wolips.bindings.wod.IWodModel;
import org.objectstyle.wolips.variables.BuildProperties;
import org.objectstyle.wolips.wodclipse.core.completion.WodParserCache;
import org.objectstyle.wolips.wodclipse.core.util.FuzzyXMLWodElement;

public class WodHtmlUtils {
    public static Pattern WEBOBJECTS_PATTERN;

    public static boolean isInline(FuzzyXMLElement element) {
        return element != null && WodHtmlUtils.isInline(element.getName());
    }

    public static boolean isInline(String tagName) {
        String lowercaseTagName;
        boolean isWOTag = false;
        if (tagName != null && (lowercaseTagName = tagName.toLowerCase()).startsWith("wo:")) {
            isWOTag = true;
        }
        return isWOTag;
    }

    public static boolean isWOTag(FuzzyXMLElement element) {
        return element != null && WodHtmlUtils.isWOTag(element.getName());
    }

    public static boolean isWOTag(String tagName) {
        String lowercaseTagName;
        boolean isWOTag = false;
        if (tagName != null && ((lowercaseTagName = tagName.trim().toLowerCase()).startsWith("webobject") || lowercaseTagName.equals("wo") || lowercaseTagName.startsWith("wo ") || lowercaseTagName.startsWith("wo:"))) {
            isWOTag = true;
        }
        return isWOTag;
    }

    public static IFile getHtmlFileForWodFilePath(IPath wodFilePath) {
        IPath templatePath = wodFilePath.removeFileExtension().addFileExtension("html");
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(templatePath);
        return file;
    }

    public static int getLineAtOffset(String contents, int offset) {
        int lineCount = 1;
        for (int i = 0; i < offset + 1; ++i) {
            char ch = contents.charAt(i);
            if (ch != '\n') continue;
            ++lineCount;
        }
        return lineCount;
    }

    public static BindingValue toBindingValue(String rawValue, String inlineBindingPrefix, String inlineBindingSuffix) {
        boolean literal;
        String valueNamespace = null;
        String value = rawValue;
        if (value.startsWith(inlineBindingPrefix) && (inlineBindingSuffix.length() == 0 || value.endsWith(inlineBindingSuffix))) {
            int colonIndex = (value = value.substring(inlineBindingPrefix.length(), value.length() - inlineBindingSuffix.length())).indexOf(58);
            if (colonIndex != -1) {
                valueNamespace = value.substring(0, colonIndex).trim();
                value = value.substring(colonIndex + 1).trim();
            }
            literal = false;
        } else {
            value = "\"" + value + "\"";
            literal = true;
        }
        return new BindingValue(valueNamespace, value, literal);
    }

    public static IWodElement getWodElement(FuzzyXMLElement element, BuildProperties buildProperties, boolean resolveWodElement, WodParserCache cache) throws Exception {
        FuzzyXMLWodElement wodElement;
        if (WodHtmlUtils.isWOTag(element)) {
            if (WodHtmlUtils.isInline(element.getName()) || !resolveWodElement) {
                wodElement = new FuzzyXMLWodElement(element, buildProperties);
            } else {
                String elementName = element.getAttributeValue("name");
                wodElement = cache != null && cache.getWodEntry() != null && cache.getWodEntry().getModel() != null ? ((IWodModel)cache.getWodEntry().getModel()).getElementNamed(elementName) : null;
            }
        } else {
            wodElement = null;
        }
        return wodElement;
    }

    static {
        StringBuffer patterns = new StringBuffer();
        patterns.append("<webobjects{0,1}\\s+name\\s*=\\s*\"{0,1}([^>\"/\\s]+)\"{0,1}\\s*/{0,1}>");
        patterns.append("|");
        patterns.append("<wo\\s+name\\s*=\\s*\"{0,1}([^>\"/\\s]+)\"{0,1}\\s*/{0,1}>");
        WEBOBJECTS_PATTERN = Pattern.compile(patterns.toString(), 10);
    }

    public static class BindingValue {
        private String _valueNamespace;
        private String _value;
        private boolean _literal;

        public BindingValue(String valueNamespace, String value, boolean literal) {
            this._valueNamespace = valueNamespace;
            this._value = value;
            this._literal = literal;
        }

        public String getValue() {
            return this._value;
        }

        public String getValueNamespace() {
            return this._valueNamespace;
        }

        public boolean isLiteral() {
            return this._literal;
        }
    }
}

