/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.wodclipse.core.validation;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.Position;
import org.objectstyle.wolips.wodclipse.core.Activator;

public class HtmlProblem {
    private IFile _htmlFile;
    private String _message;
    private Position _position;
    private int _lineNumber;
    private boolean _warning;

    public HtmlProblem(IFile htmlFile, String message, Position position, int lineNumber, boolean warning) {
        this._htmlFile = htmlFile;
        this._message = message;
        this._position = position;
        this._lineNumber = lineNumber;
        this._warning = warning;
    }

    public IFile getHtmlFile() {
        return this._htmlFile;
    }

    public String getMessage() {
        return this._message;
    }

    public Position getPosition() {
        return this._position;
    }

    public boolean isWarning() {
        return this._warning;
    }

    public String toString() {
        return "[HtmlProblem: message = " + this._message + "]";
    }

    public IMarker createMarker(IFile file, String severityPreference) {
        IMarker marker = null;
        try {
            marker = this._htmlFile.createMarker("org.objectstyle.wolips.wodclipse.core.problem");
            marker.setAttribute("message", (Object)this.getMessage());
            int severity = this.isWarning() || "warning".equals(severityPreference) ? 1 : 2;
            marker.setAttribute("severity", (Object)severity);
            marker.setAttribute("lineNumber", this._lineNumber);
            marker.setAttribute("charStart", this._position.getOffset());
            marker.setAttribute("charEnd", this._position.getOffset() + this._position.getLength());
            marker.setAttribute("transient", false);
        }
        catch (CoreException e) {
            Activator.getDefault().log(e);
        }
        return marker;
    }
}

