/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.launching.exceptionhandler;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Display;
import org.objectstyle.wolips.launching.LaunchingPlugin;
import org.objectstyle.wolips.launching.exceptionhandler.IExceptionHandler;

public abstract class AbstractConsoleHandler
implements IExceptionHandler {
    private IConsole currentConsole;

    @Override
    public int lineAppendedToConsole(String line, IConsole console) {
        this.currentConsole = console;
        int linesToSkip = this.lineAppended(line);
        this.currentConsole = null;
        return linesToSkip;
    }

    public abstract int lineAppended(String var1);

    public IConsole getCurrentConsole() {
        return this.currentConsole;
    }

    public IJavaProject getJavaProject() {
        IJavaProject javaProject = null;
        try {
            javaProject = JavaRuntime.getJavaProject((ILaunchConfiguration)this.currentConsole.getProcess().getLaunch().getLaunchConfiguration());
        }
        catch (CoreException e) {
            LaunchingPlugin.getDefault().log(e);
        }
        return javaProject;
    }

    public void selectAndReveal(IFile file, final String errorMessage, final String errorTitle) {
        LaunchingPlugin.getDefault().selectAndReveal(file);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Status status = new Status(4, "org.objectstyle.wolips.launching", 4, errorMessage, null);
                ErrorDialog.openError(null, (String)errorTitle, (String)"", (IStatus)status);
            }
        });
    }

    public void selectAndReveal(IFile file, String string, int targetEditorID, final String errorMessage, final String errorTitle) {
        LaunchingPlugin.getDefault().selectAndReveal(file, string, targetEditorID);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Status status = new Status(4, "org.objectstyle.wolips.launching", 4, errorMessage, null);
                ErrorDialog.openError(null, (String)errorTitle, (String)"", (IStatus)status);
            }
        });
    }

    public String fileNameWithoutPackage(String fileName) {
        if (fileName == null) {
            return fileName;
        }
        int index = fileName.lastIndexOf(46);
        if (index < 0) {
            return fileName;
        }
        return fileName.substring(index + 1);
    }
}

