/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.refactoring;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.MoveParticipant;
import org.objectstyle.wolips.core.resources.types.project.ProjectAdapter;
import org.objectstyle.wolips.refactoring.PrincipalClassChange;

public class PrincipalClassMoveParticipant
extends MoveParticipant {
    private ProjectAdapter myProject;
    private String myName;
    private IJavaElement myJavaDestination;

    protected boolean initialize(Object _element) {
        Object destination;
        this.myProject = PrincipalClassMoveParticipant.getInitializedProject(_element);
        boolean initialized = false;
        if (this.myProject != null && ((destination = this.getArguments().getDestination()) instanceof IPackageFragment || destination instanceof IType)) {
            this.myName = ((IType)_element).getElementName();
            this.myJavaDestination = (IJavaElement)destination;
            initialized = true;
        }
        return initialized;
    }

    public String getName() {
        return "Move Principal Class";
    }

    public RefactoringStatus checkConditions(IProgressMonitor _pm, CheckConditionsContext _context) throws OperationCanceledException {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        return refactoringStatus;
    }

    public Change createChange(IProgressMonitor _pm) throws CoreException, OperationCanceledException {
        PrincipalClassChange change = null;
        if (this.myProject != null) {
            String newFullyQualifiedName;
            if (this.myJavaDestination instanceof IType) {
                newFullyQualifiedName = ((IType)this.myJavaDestination).getFullyQualifiedName() + '$' + this.myName;
            } else if (this.myJavaDestination instanceof IPackageFragment) {
                IPackageFragment destinationPackage = (IPackageFragment)this.myJavaDestination;
                if (destinationPackage.isDefaultPackage()) {
                    newFullyQualifiedName = this.myName;
                } else {
                    System.out.println("PrincipalClassMoveParticipant.createChange: " + this.myJavaDestination.getElementName() + ", " + this.myName);
                    newFullyQualifiedName = this.myJavaDestination.getElementName() + '.' + this.myName;
                }
            } else {
                newFullyQualifiedName = null;
            }
            if (newFullyQualifiedName != null) {
                change = new PrincipalClassChange(this.myProject, newFullyQualifiedName);
            }
        }
        return change;
    }

    public static ProjectAdapter getInitializedProject(Object _element) {
        ProjectAdapter initializedProject = null;
        try {
            String packageName;
            String principalClassPackage;
            int dotIndex;
            IPackageFragment packageFragment;
            ProjectAdapter project;
            String principalClass;
            if (_element instanceof IType) {
                IType sourceType = (IType)_element;
                ProjectAdapter project2 = (ProjectAdapter)sourceType.getJavaProject().getProject().getAdapter(ProjectAdapter.class);
                String principalClass2 = project2.getBuildProperties().getPrincipalClass(true);
                String fullyQualifiedName = sourceType.getFullyQualifiedName();
                if (principalClass2 != null && principalClass2.equals(fullyQualifiedName)) {
                    initializedProject = project2;
                }
            } else if (_element instanceof IPackageFragment && (principalClass = (project = (ProjectAdapter)(packageFragment = (IPackageFragment)_element).getJavaProject().getProject().getAdapter(ProjectAdapter.class)).getBuildProperties().getPrincipalClass(true)) != null && (dotIndex = principalClass.lastIndexOf(46)) != -1 && (principalClassPackage = principalClass.substring(0, dotIndex)).equals(packageName = packageFragment.getElementName())) {
                initializedProject = project;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return initializedProject;
    }
}

