/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.wizards.actions;

import java.net.URL;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.objectstyle.wolips.baseforplugins.util.URLUtils;
import org.objectstyle.wolips.baseforuiplugins.utils.ErrorUtils;
import org.objectstyle.wolips.eogenerator.core.model.EOGeneratorModel;
import org.objectstyle.wolips.eomodeler.core.model.EOModel;
import org.objectstyle.wolips.eomodeler.core.model.EOModelGroup;
import org.objectstyle.wolips.eomodeler.core.model.IEOModelGroupFactory;
import org.objectstyle.wolips.eomodeler.editors.EOModelErrorDialog;
import org.objectstyle.wolips.wizards.EOGeneratorWizard;

public class CreateEOGenFromEOModelWorkspaceJob
extends WorkspaceJob {
    private IResource _modelFile;
    private boolean _createEOModelGroup;

    public CreateEOGenFromEOModelWorkspaceJob(IResource modelFile, boolean createEOModelGroup) {
        super(createEOModelGroup ? "Creating EOModelGroup File" : "Creating EOGenerator File ...");
        this._modelFile = modelFile;
        this._createEOModelGroup = createEOModelGroup;
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        try {
            String extension = this._createEOModelGroup ? ".eomodelgroup" : ".eogen";
            EOModelGroup modelGroup = new EOModelGroup();
            final HashSet failures = new HashSet();
            IEOModelGroupFactory.Utility.loadModelGroup((Object)this._modelFile, (EOModelGroup)modelGroup, failures, (boolean)true, (URL)this._modelFile.getLocationURI().toURL(), (IProgressMonitor)new NullProgressMonitor());
            EOModel model = modelGroup.getEditingModel();
            if (model != null) {
                EOGeneratorModel eogenModel = EOGeneratorWizard.createEOGeneratorModel(this._modelFile.getParent(), model, false);
                String eogenBasePath = URLUtils.cheatAndTurnIntoFile((URL)model.getModelURL()).getAbsolutePath();
                int dotIndex = eogenBasePath.lastIndexOf(46);
                eogenBasePath = eogenBasePath.substring(0, dotIndex);
                String eogenPath = eogenBasePath + extension;
                IFile eogenFile = this._modelFile.getWorkspace().getRoot().getFileForLocation((IPath)new Path(eogenPath));
                int dupeNum = 0;
                while (eogenFile.exists()) {
                    eogenPath = eogenBasePath + dupeNum + extension;
                    eogenFile = this._modelFile.getWorkspace().getRoot().getFileForLocation((IPath)new Path(eogenPath));
                    ++dupeNum;
                }
                eogenModel.writeToFile(eogenFile, null);
            }
            if (!failures.isEmpty()) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        new EOModelErrorDialog(new Shell(), failures).open();
                    }
                });
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ErrorUtils.openErrorDialog((Shell)new Shell(), (String)"EOGen Creation Failed", (Throwable)t);
                }
            });
        }
        return new Status(0, "org.objectstyle.wolips.eogenerator.ui", 0, "Done", null);
    }
}

