/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.core.resources.tests;

import java.util.ArrayList;
import java.util.Arrays;
import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.objectstyle.wolips.baseforplugins.util.WOLipsNatureUtils;
import org.objectstyle.wolips.core.resources.types.project.ProjectAdapter;

public abstract class AbstractProjectTestCase
extends TestCase {
    private ArrayList<IProject> projects;

    public IProject getProject(String suffix) {
        String projectName = ((Object)((Object)this)).getClass().getName() + "-" + suffix;
        projectName = projectName.replace('.', '-');
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        this.projects.add(project);
        return project;
    }

    public void initIncrementalFrameworkProject(IProject project, IProgressMonitor monitor) {
        AbstractProjectTestCase.assertFalse((boolean)project.exists());
        ProjectAdapter projectAdapter = (ProjectAdapter)project.getAdapter(ProjectAdapter.class);
        AbstractProjectTestCase.assertNull((Object)projectAdapter);
        try {
            project.create(monitor);
            project.open(monitor);
            IProjectDescription description = project.getDescription();
            ArrayList<String> naturesList = new ArrayList<String>(Arrays.asList(description.getNatureIds()));
            naturesList.add("org.eclipse.jdt.core.javanature");
            description.setNatureIds(naturesList.toArray(new String[naturesList.size()]));
            project.setDescription(description, monitor);
            boolean success = WOLipsNatureUtils.addIncrementalFrameworkNatureToProject((IProject)project, (IProgressMonitor)monitor);
            AbstractProjectTestCase.assertTrue((boolean)success);
        }
        catch (CoreException e) {
            AbstractProjectTestCase.assertTrue((boolean)false);
        }
    }

    public void initAntFrameworkProject(IProject project, IProgressMonitor monitor) {
        AbstractProjectTestCase.assertFalse((boolean)project.exists());
        ProjectAdapter projectAdapter = (ProjectAdapter)project.getAdapter(ProjectAdapter.class);
        AbstractProjectTestCase.assertNull((Object)projectAdapter);
        try {
            project.create(monitor);
            project.open(monitor);
            IProjectDescription description = project.getDescription();
            ArrayList<String> naturesList = new ArrayList<String>(Arrays.asList(description.getNatureIds()));
            naturesList.add("org.eclipse.jdt.core.javanature");
            description.setNatureIds(naturesList.toArray(new String[naturesList.size()]));
            project.setDescription(description, monitor);
            boolean success = WOLipsNatureUtils.addAntFrameworkNatureToProject((IProject)project, (IProgressMonitor)monitor);
            AbstractProjectTestCase.assertTrue((boolean)success);
        }
        catch (CoreException e) {
            AbstractProjectTestCase.assertTrue((boolean)false);
        }
    }

    public void initIncrementalApplicationProject(IProject project, IProgressMonitor monitor) {
        AbstractProjectTestCase.assertFalse((boolean)project.exists());
        ProjectAdapter projectAdapter = (ProjectAdapter)project.getAdapter(ProjectAdapter.class);
        AbstractProjectTestCase.assertNull((Object)projectAdapter);
        try {
            project.create(monitor);
            project.open(monitor);
            IProjectDescription description = project.getDescription();
            ArrayList<String> naturesList = new ArrayList<String>(Arrays.asList(description.getNatureIds()));
            naturesList.add("org.eclipse.jdt.core.javanature");
            description.setNatureIds(naturesList.toArray(new String[naturesList.size()]));
            project.setDescription(description, monitor);
            boolean success = WOLipsNatureUtils.addIncrementalApplicationNatureToProject((IProject)project, (IProgressMonitor)monitor);
            AbstractProjectTestCase.assertTrue((boolean)success);
        }
        catch (CoreException e) {
            AbstractProjectTestCase.assertTrue((boolean)false);
        }
    }

    public void initAntApplicationProject(IProject project, IProgressMonitor monitor) {
        AbstractProjectTestCase.assertFalse((boolean)project.exists());
        ProjectAdapter projectAdapter = (ProjectAdapter)project.getAdapter(ProjectAdapter.class);
        AbstractProjectTestCase.assertNull((Object)projectAdapter);
        try {
            project.create(monitor);
            project.open(monitor);
            IProjectDescription description = project.getDescription();
            ArrayList<String> naturesList = new ArrayList<String>(Arrays.asList(description.getNatureIds()));
            naturesList.add("org.eclipse.jdt.core.javanature");
            description.setNatureIds(naturesList.toArray(new String[naturesList.size()]));
            project.setDescription(description, monitor);
            boolean success = WOLipsNatureUtils.addAntApplicationNatureToProject((IProject)project, (IProgressMonitor)monitor);
            AbstractProjectTestCase.assertTrue((boolean)success);
        }
        catch (CoreException e) {
            AbstractProjectTestCase.assertTrue((boolean)false);
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.projects = new ArrayList();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        for (int i = 0; i < this.projects.size(); ++i) {
            IProject project = this.projects.get(i);
            if (!project.exists()) continue;
            project.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
        this.projects = null;
    }
}

