/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.ui.view;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.objectstyle.wolips.baseforplugins.util.ResourceUtilities;

public class RelatedLabelProvider
extends AppearanceAwareLabelProvider
implements ITableLabelProvider {
    private Set<IResource> duplicateResourceSet;

    public RelatedLabelProvider() {
        super(36421324767273L, 3);
        this.addLabelDecorator(PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator());
    }

    public void setResultList(Object[] items) {
        int length = items.length;
        this.duplicateResourceSet = new HashSet<IResource>(length);
        HashMap<String, IResource> filenameToItemMap = new HashMap<String, IResource>(length);
        int i = length;
        while (i-- > 0) {
            if (!(items[i] instanceof IResource)) continue;
            IResource thisResource = (IResource)items[i];
            IResource otherResource = (IResource)filenameToItemMap.get(thisResource.getName());
            if (otherResource != null) {
                this.duplicateResourceSet.add(thisResource);
                this.duplicateResourceSet.add(otherResource);
            }
            filenameToItemMap.put(thisResource.getName(), thisResource);
        }
    }

    public String getColumnText(Object _element, int _columnIndex) {
        String text = null;
        if (_element instanceof IResource) {
            IResource resource = (IResource)_element;
            String ext = resource.getFileExtension();
            String name = resource.getName();
            if (_columnIndex == 0) {
                if (ext != null) {
                    if ("java".equalsIgnoreCase(ext)) {
                        text = "Java";
                    } else if ("groovy".equalsIgnoreCase(ext)) {
                        text = "Groovy";
                    } else if ("eomodeld".equalsIgnoreCase(ext)) {
                        text = "EOM";
                    } else if (ext.matches("^wod|wo|woo|html|api$")) {
                        text = ext.toUpperCase();
                    } else {
                        text = ResourceUtilities.getLocalizationName((IResource)resource);
                        if (text == null) {
                            text = ext.toUpperCase();
                        }
                    }
                }
            } else {
                text = name;
                if (this.duplicateResourceSet.contains(resource)) {
                    StringBuilder sb = new StringBuilder(text);
                    sb.append(" (");
                    String languageName = ResourceUtilities.getLocalizationName((IResource)resource);
                    if (languageName != null) {
                        sb.append(languageName).append(", ");
                    }
                    sb.append(resource.getProject().getName()).append(")");
                    text = sb.toString();
                }
            }
        }
        if (text == null) {
            text = this.getText(_element);
        }
        return text;
    }

    public Image getColumnImage(Object _element, int _columnIndex) {
        Image image = null;
        if (_columnIndex == 0) {
            image = this.getImage(_element);
        }
        return image;
    }
}

