/*
 * Decompiled with CFR 0.152.
 */
package jp.aonir.fuzzyxml.internal;

import jp.aonir.fuzzyxml.FuzzyXMLComment;
import jp.aonir.fuzzyxml.FuzzyXMLFormat;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.internal.FuzzyXMLElementImpl;
import jp.aonir.fuzzyxml.internal.RenderContext;
import jp.aonir.fuzzyxml.internal.RenderDelegate;

public class FuzzyXMLCommentImpl
extends FuzzyXMLElementImpl
implements FuzzyXMLComment,
FuzzyXMLFormat {
    private final String _value;
    private final boolean _hasCloseTag;

    public FuzzyXMLCommentImpl(String value) {
        this(null, value, 0, 0);
    }

    public FuzzyXMLCommentImpl(FuzzyXMLNode parent, String value, int offset, int length) {
        super(parent, "comment", offset, length, -1);
        String text;
        this._hasCloseTag = value.trim().endsWith("-->");
        this._value = text = value.replaceFirst("<!--", "").replaceFirst("-->", "");
    }

    @Override
    public String getValue() {
        return this._value;
    }

    @Override
    public void toXMLString(RenderContext renderContext, StringBuffer xmlBuffer) {
        boolean renderSurroundingTags = true;
        RenderDelegate delegate = renderContext.getDelegate();
        if (delegate != null) {
            renderSurroundingTags = delegate.beforeOpenTag(this, renderContext, xmlBuffer);
        }
        if (renderSurroundingTags) {
            xmlBuffer.append("<!--");
            String commentString = this.getValue();
            if (renderContext.shouldFormat()) {
                // empty if block
            }
            if (commentString != null) {
                if (!commentString.startsWith(" ")) {
                    xmlBuffer.append(" ");
                }
                xmlBuffer.append(commentString);
            }
            if (this._hasCloseTag) {
                if (xmlBuffer.charAt(xmlBuffer.length() - 1) == '\n') {
                    renderContext.appendIndent(xmlBuffer);
                } else if (!commentString.endsWith(" ")) {
                    xmlBuffer.append(" ");
                }
                xmlBuffer.append("-->");
            }
            if (delegate != null) {
                delegate.afterCloseTag(this, renderContext, xmlBuffer);
            }
        }
    }

    @Override
    public String toString() {
        return "comment: " + this.getValue();
    }
}

