/*
 * Decompiled with CFR 0.152.
 */
package jp.aonir.fuzzyxml.internal;

import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.FuzzyXMLText;
import jp.aonir.fuzzyxml.internal.AbstractFuzzyXMLNode;
import jp.aonir.fuzzyxml.internal.FuzzyXMLUtil;
import jp.aonir.fuzzyxml.internal.RenderContext;

public class FuzzyXMLTextImpl
extends AbstractFuzzyXMLNode
implements FuzzyXMLText {
    private String _value;
    private boolean _escape = true;

    public FuzzyXMLTextImpl(String value) {
        this(null, value, -1, -1);
    }

    public FuzzyXMLTextImpl(FuzzyXMLNode parent, String value, int offset, int length) {
        super(parent, offset, length);
        this._value = value;
    }

    @Override
    public String getValue() {
        if (this.getDocument() == null) {
            return FuzzyXMLUtil.decode(this._value, false);
        }
        return FuzzyXMLUtil.decode(this._value, this.getDocument().isHTML());
    }

    @Override
    public String toDebugString() {
        StringBuffer sb = new StringBuffer();
        this.toDebugString(sb, 0);
        return sb.toString();
    }

    @Override
    public void toDebugString(StringBuffer buffer, int indent) {
        for (int i = 0; i < indent; ++i) {
            buffer.append("  ");
        }
        buffer.append("text: '" + this._value + "'\n");
    }

    @Override
    public void toXMLString(RenderContext renderContext, StringBuffer xmlBuffer) {
        String value = this._value;
        if (renderContext.isTrim()) {
            if (value.trim().length() == 0) {
                return;
            }
            value = value.replaceFirst("[\r\n\t ]+$", " ");
            String replace = "";
            if (xmlBuffer.length() >= 1 && !Character.isWhitespace(xmlBuffer.charAt(xmlBuffer.length() - 1))) {
                replace = " ";
            }
            value = value.replaceFirst("^[\r\n\t ]+", replace);
        }
        if (this._escape) {
            boolean isHTML = renderContext.isHtml();
            value = FuzzyXMLUtil.escape(value, isHTML);
        }
        xmlBuffer.append(value);
    }

    public String toString() {
        return "text: " + this.getValue();
    }

    @Override
    public void setEscape(boolean escape) {
        this._escape = escape;
    }

    @Override
    public boolean isEscape() {
        return this._escape;
    }

    @Override
    public boolean isNonBreaking() {
        if (this.isHidden()) {
            return false;
        }
        String value = this.getValue();
        boolean result = FuzzyXMLUtil.isAllWhitescape(value) || FuzzyXMLUtil.getSpaceIndex(value) == -1;
        return result;
    }

    @Override
    public boolean isHidden() {
        boolean result = this._value == null || FuzzyXMLUtil.isAllWhitescape(this._value);
        return result;
    }

    @Override
    public boolean hasLineBreaks() {
        return this._value != null && this._value.trim().contains("\n");
    }
}

