/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.csseditor.editors;

import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import tk.eclipse.plugin.csseditor.editors.CSSAssistProcessor;
import tk.eclipse.plugin.csseditor.editors.CSSBlockScanner;
import tk.eclipse.plugin.htmleditor.ColorProvider;

public class CSSConfiguration
extends SourceViewerConfiguration {
    private ColorProvider colorProvider;
    private RuleBasedScanner commentScanner;
    private CSSBlockScanner defaultScanner;

    public CSSConfiguration(ColorProvider colorProvider) {
        this.colorProvider = colorProvider;
    }

    private RuleBasedScanner getCommentScanner() {
        if (this.commentScanner == null) {
            this.commentScanner = new RuleBasedScanner();
            this.commentScanner.setDefaultReturnToken(this.colorProvider.getToken("_pref_color_csscomment"));
        }
        return this.commentScanner;
    }

    private RuleBasedScanner getDefaultScanner() {
        if (this.defaultScanner == null) {
            this.defaultScanner = new CSSBlockScanner(this.colorProvider);
            this.defaultScanner.setDefaultReturnToken(this.colorProvider.getToken("__pref_color_foreground"));
        }
        return this.defaultScanner;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__css_comment"};
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant assistant = new ContentAssistant();
        assistant.enableAutoInsert(true);
        CSSAssistProcessor processor = new CSSAssistProcessor();
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__dftl_partition_content_type");
        assistant.install((ITextViewer)sourceViewer);
        return assistant;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer dr = null;
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getDefaultScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getCommentScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__css_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "__css_comment");
        return reconciler;
    }
}

