/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.htmleditor;

import java.util.ArrayList;
import java.util.List;
import jp.aonir.fuzzyxml.FuzzyXMLAttribute;
import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLParser;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.IHyperlinkProvider;
import tk.eclipse.plugin.htmleditor.editors.HTMLHyperlinkInfo;
import tk.eclipse.plugin.htmleditor.editors.HTMLSourceEditor;

public class HTMLHyperlinkDetector
implements IHyperlinkDetector {
    private HTMLSourceEditor editor;
    private List<IHyperlinkProvider> providers = new ArrayList<IHyperlinkProvider>();

    public void setEditor(HTMLSourceEditor editor) {
        this.editor = editor;
    }

    public void addHyperlinkProvider(IHyperlinkProvider provider) {
        this.providers.add(provider);
    }

    private IProject getProject() {
        IEditorInput input = this.editor.getEditorInput();
        if (input instanceof IFileEditorInput) {
            return ((IFileEditorInput)input).getFile().getProject();
        }
        return null;
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        IHyperlink hyperlink = this.detectHyperlink(textViewer.getDocument(), region.getOffset());
        if (hyperlink != null) {
            return new IHyperlink[]{hyperlink};
        }
        return null;
    }

    private IHyperlink detectHyperlink(IDocument doc, int offset) {
        FuzzyXMLDocument document = new FuzzyXMLParser(false).parse(this.editor.getHTMLSource());
        FuzzyXMLElement element = document.getElementByOffset(offset);
        if (element == null) {
            return null;
        }
        FuzzyXMLAttribute[] attrs = element.getAttributes();
        HTMLHyperlinkInfo info = this.getOpenFileInfo(document, element, null, null, offset);
        if (info != null) {
            return (IHyperlink)info.getObject();
        }
        for (int i = 0; i < attrs.length; ++i) {
            if (attrs[i].getOffset() >= offset || offset >= attrs[i].getOffset() + attrs[i].getLength()) continue;
            int attrOffset = this.getAttributeValueOffset(doc.get(), attrs[i]);
            int attrLength = attrs[i].getValue().length();
            if (attrOffset < 0 || attrLength < 0 || attrOffset > offset) continue;
            info = this.getOpenFileInfo(document, element, attrs[i].getName(), attrs[i].getValue(), offset - attrOffset);
            Object hyperlink = null;
            if (info != null && info.getObject() != null) {
                hyperlink = info.getObject() instanceof IHyperlink ? (IHyperlink)info.getObject() : new HTMLHyperlink((IRegion)new Region(attrOffset + info.getOffset(), info.getLength()), info.getObject());
            }
            return hyperlink;
        }
        return null;
    }

    private HTMLHyperlinkInfo getOpenFileInfo(FuzzyXMLDocument doc, FuzzyXMLElement element, String attrName, String attrValue, int offset) {
        try {
            IProject project = this.getProject();
            if (project == null) {
                return null;
            }
            IFile file = ((IFileEditorInput)this.editor.getEditorInput()).getFile();
            for (int i = 0; i < this.providers.size(); ++i) {
                IHyperlinkProvider provider = this.providers.get(i);
                HTMLHyperlinkInfo info = provider.getHyperlinkInfo(file, doc, element, attrName, attrValue, offset);
                if (info == null || info.getObject() == null) continue;
                return info;
            }
            if (attrName != null && attrName.equalsIgnoreCase("href")) {
                IPath path;
                IResource resource;
                String href = attrValue;
                if (href.indexOf("#") > 0) {
                    href = href.substring(0, href.indexOf("#"));
                }
                if ((resource = project.findMember((path = file.getParent().getProjectRelativePath()).append(href))) != null && resource.exists() && resource instanceof IFile) {
                    HTMLHyperlinkInfo info = new HTMLHyperlinkInfo();
                    info.setObject(resource);
                    info.setOffset(0);
                    info.setLength(attrValue.length());
                    return info;
                }
            }
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
        }
        return null;
    }

    private int getAttributeValueOffset(String source, FuzzyXMLAttribute attr) {
        int offset = source.indexOf(61, attr.getOffset());
        if (offset == -1) {
            return -1;
        }
        int c = 32;
        while ((c == 32 || c == 9 || c == 13 || c == 10 || c == 34 || c == 39) && source.length() != ++offset + 1) {
            c = source.charAt(offset);
        }
        return offset;
    }

    private class HTMLHyperlink
    implements IHyperlink {
        private IRegion region;
        private Object openObject;

        public HTMLHyperlink(IRegion region, Object openObject) {
            this.region = region;
            this.openObject = openObject;
        }

        public IRegion getHyperlinkRegion() {
            return this.region;
        }

        public String getTypeLabel() {
            return null;
        }

        public String getHyperlinkText() {
            return null;
        }

        public void open() {
            try {
                if (this.openObject instanceof IFile) {
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    IDE.openEditor((IWorkbenchPage)window.getActivePage(), (IFile)((IFile)this.openObject), (boolean)true);
                } else if (this.openObject instanceof IJavaElement) {
                    JavaUI.revealInEditor((IEditorPart)JavaUI.openInEditor((IJavaElement)((IJavaElement)this.openObject)), (IJavaElement)((IJavaElement)this.openObject));
                }
            }
            catch (Exception ex) {
                HTMLPlugin.logException(ex);
            }
        }
    }
}

