/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.htmleditor.tasktag;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.htmleditor.tasktag.ITaskTagDetector;
import tk.eclipse.plugin.htmleditor.tasktag.TaskTag;

public abstract class AbstractTaskTagDetector
implements ITaskTagDetector {
    protected String _contents;
    protected IFile _file;
    protected TaskTag[] _tags;
    private List<String> _extensions = new ArrayList<String>();

    protected void addSupportedExtension(String ext) {
        this._extensions.add(ext);
    }

    @Override
    public boolean isSupported(IFile file) {
        String fileName = file.getName();
        for (int i = 0; i < this._extensions.size(); ++i) {
            String ext = this._extensions.get(i);
            if (!fileName.endsWith("." + ext)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void detect(IFile file, TaskTag[] tags) throws Exception {
        this._file = file;
        this._tags = tags;
        this._contents = new String(HTMLUtil.readStream(file.getContents()), file.getCharset());
        this._contents = this._contents.replaceAll("\r\n", "\n");
        this._contents = this._contents.replaceAll("\r", "\n");
        this.doDetect();
    }

    protected abstract void doDetect() throws Exception;

    protected void detectTaskTag(String value, int offset) {
        String[] lines = value.split("\n");
        block0: for (int i = 0; i < lines.length; ++i) {
            for (int j = 0; j < this._tags.length; ++j) {
                int index = lines[i].indexOf(this._tags[j].getTag());
                if (index < 0) continue;
                HTMLUtil.addTaskMarker((IResource)this._file, 1, this.getLineAtOffset(offset) + i, lines[i].substring(index));
                continue block0;
            }
        }
    }

    private int getLineAtOffset(int offset) {
        String text = this._contents.substring(0, offset);
        int line = 0;
        int index = 0;
        while ((index = text.indexOf(10, index)) >= 0) {
            ++line;
            ++index;
        }
        return line + 1;
    }
}

