/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jseditor.editors;

import java.util.ArrayList;
import java.util.Stack;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.MatchingCharacterPainter;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.ContentAssistAction;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import tk.eclipse.plugin.htmleditor.ColorProvider;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.HTMLProjectParams;
import tk.eclipse.plugin.htmleditor.editors.FoldingInfo;
import tk.eclipse.plugin.htmleditor.editors.SoftTabVerifyListener;
import tk.eclipse.plugin.jseditor.editors.JavaScriptCharacterPairMatcher;
import tk.eclipse.plugin.jseditor.editors.JavaScriptConfiguration;
import tk.eclipse.plugin.jseditor.editors.JavaScriptFileDocumentProvider;
import tk.eclipse.plugin.jseditor.editors.JavaScriptHyperlinkDetector;
import tk.eclipse.plugin.jseditor.editors.JavaScriptOutlinePage;
import tk.eclipse.plugin.jseditor.editors.JavaScriptTextDocumentProvider;
import tk.eclipse.plugin.jseditor.editors.JavaScriptValidator;

public class JavaScriptEditor
extends TextEditor {
    private ColorProvider colorProvider = HTMLPlugin.getDefault().getColorProvider();
    private SoftTabVerifyListener softTabListener;
    private JavaScriptOutlinePage outline;
    private JavaScriptCharacterPairMatcher pairMatcher;
    private ProjectionSupport fProjectionSupport;
    private JavaScriptHyperlinkDetector hyperlinkDetector;
    public static final String GROUP_JAVASCRIPT = "_javascript";
    public static final String ACTION_COMMENT = "_comment";

    public JavaScriptEditor() {
        this.setSourceViewerConfiguration(new JavaScriptConfiguration(this.colorProvider));
        this.setPreferenceStore((IPreferenceStore)new ChainedPreferenceStore(new IPreferenceStore[]{this.getPreferenceStore(), HTMLPlugin.getDefault().getPreferenceStore()}));
        this.outline = new JavaScriptOutlinePage(this);
        IPreferenceStore store = HTMLPlugin.getDefault().getPreferenceStore();
        this.softTabListener = new SoftTabVerifyListener();
        this.softTabListener.setUseSoftTab(store.getBoolean("_pref_use_softtab"));
        this.softTabListener.setSoftTabWidth(store.getInt("_pref_softtab_width"));
        this.setAction(ACTION_COMMENT, (IAction)new CommentAction());
    }

    protected void updateSelectionDependentActions() {
        super.updateSelectionDependentActions();
        ITextSelection sel = (ITextSelection)this.getSelectionProvider().getSelection();
        if (sel.getText().equals("")) {
            this.getAction(ACTION_COMMENT).setEnabled(false);
        } else {
            this.getAction(ACTION_COMMENT).setEnabled(true);
        }
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        ProjectionViewer viewer = new ProjectionViewer(parent, ruler, this.getOverviewRuler(), true, styles);
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        viewer.getTextWidget().addVerifyListener((VerifyListener)this.softTabListener);
        return viewer;
    }

    protected final void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        menu.add((IContributionItem)new Separator(GROUP_JAVASCRIPT));
        this.addAction(menu, GROUP_JAVASCRIPT, ACTION_COMMENT);
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        if (input instanceof IFileEditorInput) {
            this.setDocumentProvider((IDocumentProvider)new JavaScriptTextDocumentProvider());
        } else if (input instanceof IStorageEditorInput) {
            this.setDocumentProvider((IDocumentProvider)new JavaScriptFileDocumentProvider());
        } else {
            this.setDocumentProvider((IDocumentProvider)new JavaScriptTextDocumentProvider());
        }
        super.doSetInput(input);
    }

    public void doSave(IProgressMonitor progressMonitor) {
        super.doSave(progressMonitor);
        this.update();
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
        this.fProjectionSupport = new ProjectionSupport(viewer, this.getAnnotationAccess(), this.getSharedColors());
        this.fProjectionSupport.install();
        viewer.doOperation(19);
        this.updateFolding();
        StyledText widget = viewer.getTextWidget();
        widget.setTabs(this.getPreferenceStore().getInt("tabWidth"));
        widget.addVerifyListener((VerifyListener)this.softTabListener);
        ITextViewerExtension2 extension = (ITextViewerExtension2)this.getSourceViewer();
        this.pairMatcher = new JavaScriptCharacterPairMatcher();
        this.pairMatcher.setEnable(this.getPreferenceStore().getBoolean("__pref_pair_character"));
        MatchingCharacterPainter painter = new MatchingCharacterPainter(this.getSourceViewer(), (ICharacterPairMatcher)this.pairMatcher);
        painter.setColor(Display.getDefault().getSystemColor(15));
        extension.addPainter((IPainter)painter);
        this.hyperlinkDetector = new JavaScriptHyperlinkDetector();
        viewer.setHyperlinkDetectors(new IHyperlinkDetector[]{this.hyperlinkDetector}, 262144);
        this.update();
    }

    protected void update() {
        this.outline.update();
        this.updateFolding();
        if (this.getEditorInput() instanceof IFileEditorInput) {
            this.doValidate();
            IFileEditorInput input = (IFileEditorInput)this.getEditorInput();
            JavaScriptConfiguration config = (JavaScriptConfiguration)this.getSourceViewerConfiguration();
            config.getAssistProcessor().update(input.getFile());
            this.hyperlinkDetector.update(input.getFile());
        }
    }

    protected void doValidate() {
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    try {
                        IFileEditorInput input = (IFileEditorInput)JavaScriptEditor.this.getEditorInput();
                        new JavaScriptValidator(input.getFile()).doValidate();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }, null);
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
        }
    }

    public void dispose() {
        if (this.getEditorInput() instanceof IFileEditorInput) {
            try {
                ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        try {
                            IFileEditorInput input = (IFileEditorInput)JavaScriptEditor.this.getEditorInput();
                            HTMLProjectParams params = new HTMLProjectParams(input.getFile().getProject());
                            if (params.getRemoveMarkers()) {
                                input.getFile().deleteMarkers("org.eclipse.core.resources.problemmarker", false, 0);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.pairMatcher.dispose();
        super.dispose();
    }

    public void doSaveAs() {
        super.doSaveAs();
        this.update();
    }

    protected boolean affectsTextPresentation(PropertyChangeEvent event) {
        return super.affectsTextPresentation(event) || this.colorProvider.affectsTextPresentation(event);
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        this.colorProvider.handlePreferenceStoreChanged(event);
        String key = event.getProperty();
        if (key.equals("__pref_pair_character")) {
            boolean enable = (Boolean)event.getNewValue();
            this.pairMatcher.setEnable(enable);
        }
        super.handlePreferenceStoreChanged(event);
        this.softTabListener.preferenceChanged(event);
    }

    protected void createActions() {
        super.createActions();
        ContentAssistAction action = new ContentAssistAction(HTMLPlugin.getDefault().getResourceBundle(), "ContentAssistProposal", (ITextEditor)this);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)action);
    }

    public Object getAdapter(Class adapter) {
        if (IContentOutlinePage.class.equals((Object)adapter)) {
            return this.outline;
        }
        return super.getAdapter(adapter);
    }

    private void updateFolding() {
        try {
            ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
            if (viewer == null) {
                return;
            }
            ProjectionAnnotationModel model = viewer.getProjectionAnnotationModel();
            if (model == null) {
                return;
            }
            IDocument doc = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
            String source = doc.get();
            ArrayList<FoldingInfo> list = new ArrayList<FoldingInfo>();
            Stack<FoldingInfo> stack = new Stack<FoldingInfo>();
            FoldingInfo prev = null;
            char quote = '\u0000';
            boolean escape = false;
            for (int i = 0; i < source.length(); ++i) {
                FoldingInfo info;
                char c = source.charAt(i);
                if (quote != '\u0000' && escape) {
                    escape = false;
                    continue;
                }
                if (!(prev != null && prev.getType().equals("comment") || c != '\"' && c != '\'')) {
                    if (quote == '\u0000') {
                        quote = c;
                        continue;
                    }
                    if (quote != c) continue;
                    quote = '\u0000';
                    continue;
                }
                if (quote != '\u0000' && c == '\\') {
                    escape = true;
                    continue;
                }
                if (quote != '\u0000' && (c == '\n' || c == '\r')) {
                    quote = '\u0000';
                    continue;
                }
                if (c == '/' && source.length() > i + 1 && quote == '\u0000') {
                    if (source.charAt(i + 1) != '*') continue;
                    prev = new FoldingInfo(i, -1, "comment");
                    stack.push(prev);
                    ++i;
                    continue;
                }
                if (c == '*' && source.length() > i + 1 && !stack.isEmpty() && quote == '\u0000') {
                    if (source.charAt(i + 1) != '/' || !prev.getType().equals("comment")) continue;
                    info = (FoldingInfo)stack.pop();
                    if (doc.getLineOfOffset(info.getStart()) != doc.getLineOfOffset(i)) {
                        list.add(new FoldingInfo(info.getStart(), i + 2 + FoldingInfo.countUpLineDelimiter(source, i + 2), "comment"));
                    }
                    prev = stack.isEmpty() ? null : (FoldingInfo)stack.get(stack.size() - 1);
                    ++i;
                    continue;
                }
                if (c == '{' && quote == '\u0000') {
                    if (prev != null && prev.getType().equals("comment")) continue;
                    prev = this.findFunction(source, i) ? new FoldingInfo(i, -1, "function") : new FoldingInfo(i, -1, "blace");
                    stack.push(prev);
                    continue;
                }
                if (c != '}' || prev == null || prev.getType().equals("comment") || quote != '\u0000') continue;
                info = (FoldingInfo)stack.pop();
                if (info.getType().equals("function") && doc.getLineOfOffset(info.getStart()) != doc.getLineOfOffset(i)) {
                    list.add(new FoldingInfo(info.getStart(), i + 2 + FoldingInfo.countUpLineDelimiter(source, i + 2), "function"));
                }
                prev = stack.isEmpty() ? null : (FoldingInfo)stack.get(stack.size() - 1);
            }
            FoldingInfo.applyModifiedAnnotations(model, list);
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
        }
    }

    private boolean findFunction(String text, int pos) {
        text = text.substring(0, pos);
        int index1 = text.lastIndexOf("function");
        int index2 = text.lastIndexOf("{");
        if (index1 == -1) {
            return false;
        }
        return index1 > index2;
    }

    private class CommentAction
    extends Action {
        public CommentAction() {
            super(HTMLPlugin.getResourceString("JavaScriptEditor.CommentAction"));
            this.setEnabled(false);
            this.setAccelerator(262191);
        }

        public void run() {
            ITextSelection sel = (ITextSelection)JavaScriptEditor.this.getSelectionProvider().getSelection();
            IDocument doc = JavaScriptEditor.this.getDocumentProvider().getDocument((Object)JavaScriptEditor.this.getEditorInput());
            String text = sel.getText();
            text = text.replaceAll("[\r\n \t]+$", "");
            int length = text.length();
            try {
                text = text.startsWith("//") ? text.replaceAll("(^|\r\n|\r|\n)//", "$1") : text.replaceAll("(^|\r\n|\r|\n)", "$1//");
                doc.replace(sel.getOffset(), length, text);
            }
            catch (BadLocationException e) {
                HTMLPlugin.logException(e);
            }
        }
    }
}

