/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.wooeditor.databinding.observable;

import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;

public class ComboObservableValue
extends AbstractObservableValue {
    private final Combo combo;
    private final String attribute;
    private boolean updating = false;
    private String currentValue;
    private ModifyListener modifyListener;
    private SelectionListener selectionListener;

    public ComboObservableValue(Combo combo, String attribute) {
        this.combo = combo;
        this.attribute = attribute;
        if (!attribute.equals("selection") && !attribute.equals("text")) {
            throw new IllegalArgumentException();
        }
        this.currentValue = combo.getText();
        this.modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!ComboObservableValue.this.updating) {
                    String oldValue = ComboObservableValue.this.currentValue;
                    ComboObservableValue.this.currentValue = ComboObservableValue.this.combo.getText();
                    ComboObservableValue.this.fireValueChange(Diffs.createValueDiff((Object)oldValue, (Object)ComboObservableValue.this.currentValue));
                } else {
                    ComboObservableValue.this.currentValue = ComboObservableValue.this.combo.getText();
                }
            }
        };
        this.selectionListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                if (!ComboObservableValue.this.updating) {
                    String oldValue = ComboObservableValue.this.currentValue;
                    ComboObservableValue.this.currentValue = ComboObservableValue.this.combo.getText();
                    ComboObservableValue.this.fireValueChange(Diffs.createValueDiff((Object)oldValue, (Object)ComboObservableValue.this.currentValue));
                } else {
                    ComboObservableValue.this.currentValue = ComboObservableValue.this.combo.getText();
                }
            }

            public void widgetSelected(SelectionEvent e) {
                if (!ComboObservableValue.this.updating) {
                    String oldValue = ComboObservableValue.this.currentValue;
                    ComboObservableValue.this.currentValue = ComboObservableValue.this.combo.getText();
                    ComboObservableValue.this.fireValueChange(Diffs.createValueDiff((Object)oldValue, (Object)ComboObservableValue.this.currentValue));
                } else {
                    ComboObservableValue.this.currentValue = ComboObservableValue.this.combo.getText();
                }
            }
        };
        combo.addModifyListener(this.modifyListener);
        combo.addSelectionListener(this.selectionListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSetValue(Object value) {
        String oldValue = this.combo.getText();
        try {
            this.updating = true;
            if (this.attribute.equals("text")) {
                String stringValue = value != null ? value.toString() : "";
                this.combo.setText(stringValue);
            } else if (this.attribute.equals("selection")) {
                String[] items = this.combo.getItems();
                int index = -1;
                if (items != null && value != null) {
                    for (int i = 0; i < items.length; ++i) {
                        if (!value.equals(items[i])) continue;
                        index = i;
                        break;
                    }
                    if (index == -1) {
                        this.combo.setText((String)value);
                    } else {
                        this.combo.select(index);
                    }
                }
            }
        }
        finally {
            this.updating = false;
        }
        this.fireValueChange(Diffs.createValueDiff((Object)oldValue, (Object)this.combo.getText()));
    }

    public Object doGetValue() {
        if (this.attribute.equals("text")) {
            return this.combo.getText();
        }
        return this.combo.getText();
    }

    public Object getValueType() {
        return String.class;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public synchronized void dispose() {
        super.dispose();
        if (this.modifyListener != null && !this.combo.isDisposed()) {
            this.combo.removeModifyListener(this.modifyListener);
        }
    }
}

