/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.components.input;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.objectstyle.wolips.components.input.ComponentEditorFileEditorInput;
import org.objectstyle.wolips.components.input.ComponentEditorInput;

public class ComponentEditorInputFactory
implements IElementFactory {
    private static final String NAME = "name";
    private static final String TAG_COUNT = "count";
    private static final String TAG_EDITOR = "editor";
    private static final String TAG_INPUT = "input";
    private static final String TAG_DISPLAY_HTML_PART_ON_REVEAL = "html";
    private static final String TAG_DISPLAY_WOD_PART_ON_REVEAL = "wod";
    private static final String TAG_DISPLAY_API_PART_ON_REVEAL = "api";
    private static final String TAG_DISPLAY_WOO_PART_ON_REVEAL = "woo";
    public static final String ID_FACTORY = ComponentEditorInputFactory.class.getName();

    public IAdaptable createElement(IMemento memento) {
        String countString = memento.getString(TAG_COUNT);
        if (countString == null) {
            return null;
        }
        int count = Integer.parseInt(countString);
        String[] editors = new String[count];
        ComponentEditorFileEditorInput[] allInputs = new ComponentEditorFileEditorInput[count];
        ComponentEditorFileEditorInput[] allComponentInputs = new ComponentEditorFileEditorInput[count - 1];
        for (int i = 0; i < count; ++i) {
            editors[i] = memento.getString(TAG_EDITOR + i);
            String fileName = memento.getString(TAG_INPUT + i);
            if (fileName == null) continue;
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(fileName));
            allInputs[i] = new ComponentEditorFileEditorInput(file);
            if (i >= count - 1) continue;
            allComponentInputs[i] = allInputs[i];
        }
        ComponentEditorInput componentEditorInput = new ComponentEditorInput(memento.getString(NAME), editors, (IEditorInput[])allInputs, (IEditorInput[])allComponentInputs, (IEditorInput)allInputs[allInputs.length - 1], null);
        for (int i = 0; i < allInputs.length; ++i) {
            allInputs[i].setComponentEditorInput(componentEditorInput);
        }
        if (memento.getString(TAG_DISPLAY_API_PART_ON_REVEAL) != null) {
            componentEditorInput.setDisplayApiPartOnReveal(true);
        } else if (memento.getString(TAG_DISPLAY_HTML_PART_ON_REVEAL) != null) {
            componentEditorInput.setDisplayHtmlPartOnReveal(true);
        } else if (memento.getString(TAG_DISPLAY_WOD_PART_ON_REVEAL) != null) {
            componentEditorInput.setDisplayWodPartOnReveal(true);
        } else if (memento.getString(TAG_DISPLAY_WOO_PART_ON_REVEAL) != null) {
            componentEditorInput.setDisplayWooPartOnReveal(true);
        } else {
            componentEditorInput.setDisplayHtmlPartOnReveal(true);
        }
        return componentEditorInput;
    }

    public static void saveState(IMemento memento, ComponentEditorInput input) {
        String count = input.getEditors().length + "";
        memento.putString(NAME, input.getName());
        memento.putString(TAG_COUNT, count);
        for (int i = 0; i < input.getEditors().length; ++i) {
            IFile file;
            memento.putString(TAG_EDITOR + i, input.getEditors()[i]);
            ComponentEditorFileEditorInput fileEditorInput = (ComponentEditorFileEditorInput)input.getInput()[i];
            if (fileEditorInput == null || (file = fileEditorInput.getFile()) == null) continue;
            memento.putString(TAG_INPUT + i, file.getFullPath().toString());
        }
        if (input.isDisplayApiPartOnReveal()) {
            memento.putString(TAG_DISPLAY_API_PART_ON_REVEAL, "true");
        } else if (input.isDisplayWodPartOnReveal()) {
            memento.putString(TAG_DISPLAY_WOD_PART_ON_REVEAL, "true");
        } else if (input.isDisplayWooPartOnReveal()) {
            memento.putString(TAG_DISPLAY_WOO_PART_ON_REVEAL, "true");
        }
        if (input.isDisplayHtmlPartOnReveal()) {
            memento.putString(TAG_DISPLAY_HTML_PART_ON_REVEAL, "true");
        }
    }
}

