/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.variables;

import er.extensions.foundation.ERXValueUtilities;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.objectstyle.woenvironment.env.WOVariables;
import org.objectstyle.wolips.baseforplugins.util.ComparisonUtils;

public class ProjectVariables
implements IPersistentPreferenceStore {
    private WOVariables _variables;
    private boolean _dirty;
    private List<IPropertyChangeListener> _listeners = new LinkedList<IPropertyChangeListener>();

    public ProjectVariables(WOVariables variables) {
        this._variables = variables;
    }

    public WOVariables getWOVariables() {
        return this._variables;
    }

    private IPath fixMissingSeparatorAfterDevice(String string) {
        Object path = string != null && string.length() > 1 && string.charAt(1) == ':' ? new Path(string.substring(2)).setDevice(string.substring(0, 2)) : (string != null ? new Path(string) : null);
        return path;
    }

    public IPath getLocalRoot() {
        return this.fixMissingSeparatorAfterDevice(this._variables.localRoot());
    }

    public IPath getLocalFrameworkPath() {
        return this.fixMissingSeparatorAfterDevice(this._variables.localFrameworkPath());
    }

    public IPath getSystemRoot() {
        return this.fixMissingSeparatorAfterDevice(this._variables.systemRoot());
    }

    public IPath getSystemFrameworkPath() {
        return this.fixMissingSeparatorAfterDevice(this._variables.systemFrameworkPath());
    }

    public IPath getNetworkRoot() {
        return this.fixMissingSeparatorAfterDevice(this._variables.networkRoot());
    }

    public IPath getNetworkFrameworkPath() {
        return this.fixMissingSeparatorAfterDevice(this._variables.networkFrameworkPath());
    }

    public IPath getUserRoot() {
        return this.fixMissingSeparatorAfterDevice(this._variables.userRoot());
    }

    public IPath getUserFrameworkPath() {
        return this.fixMissingSeparatorAfterDevice(this._variables.userFrameworkPath());
    }

    public IPath getReferenceApi() {
        String referenceApi = this._variables.referenceApi();
        if (referenceApi == null) {
            return null;
        }
        return this.fixMissingSeparatorAfterDevice(referenceApi);
    }

    public String getReferenceApiAsJavaDocCompatibleString() {
        IPath referenceApi = this.getReferenceApi();
        if (referenceApi == null) {
            return null;
        }
        String referenceApiString = referenceApi.toOSString();
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.indexOf("windows") >= 0) {
            referenceApiString = referenceApiString.replace('\\', '/');
        }
        referenceApiString = "file://" + referenceApiString;
        return referenceApiString;
    }

    public IPath getExternalBuildRoot() {
        String root = this._variables.externalBuildRoot();
        if (root != null) {
            IPath result = this.fixMissingSeparatorAfterDevice(root);
            return result;
        }
        return null;
    }

    public IPath getExternalBuildFrameworkPath() {
        String root = this._variables.externalBuildFrameworkPath();
        if (root != null) {
            IPath result = this.fixMissingSeparatorAfterDevice(root);
            return result;
        }
        return null;
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this._listeners.add(listener);
    }

    public boolean contains(String name) {
        return this.getString(name) != null;
    }

    public void firePropertyChangeEvent(String name, Object oldValue, Object newValue) {
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, name, oldValue, newValue);
        for (IPropertyChangeListener listener : this._listeners) {
            listener.propertyChange(event);
        }
    }

    public boolean getBoolean(String name) {
        return ERXValueUtilities.booleanValue(this.getString(name));
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        return ERXValueUtilities.booleanValueWithDefault(this.getString(name), defaultValue);
    }

    public boolean getDefaultBoolean(String name) {
        return ERXValueUtilities.booleanValue(this.getDefaultString(name));
    }

    public double getDefaultDouble(String name) {
        return ERXValueUtilities.doubleValue(this.getDefaultString(name));
    }

    public float getDefaultFloat(String name) {
        return ERXValueUtilities.floatValue(this.getDefaultString(name));
    }

    public int getDefaultInt(String name) {
        return ERXValueUtilities.intValue(this.getDefaultString(name));
    }

    public long getDefaultLong(String name) {
        return ERXValueUtilities.longValue(this.getDefaultString(name));
    }

    public String getDefaultString(String name) {
        return this._variables.getDefault(name);
    }

    public double getDouble(String name) {
        return ERXValueUtilities.doubleValue(this.getString(name));
    }

    public float getFloat(String name) {
        return ERXValueUtilities.floatValue(this.getString(name));
    }

    public int getInt(String name) {
        return ERXValueUtilities.intValue(this.getString(name));
    }

    public long getLong(String name) {
        return ERXValueUtilities.longValue(this.getString(name));
    }

    public String getString(String name, String defaultValue) {
        String value = this.getString(name);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public String getString(String name) {
        return this._variables.getProperty(name);
    }

    public boolean isDefault(String name) {
        return ComparisonUtils.equals((String)this.getDefaultString(name), (String)this.getString(name), (boolean)false);
    }

    public boolean needsSaving() {
        return this._dirty;
    }

    public void putValue(String name, String value) {
        this._variables.setProperty(name, value);
        this._dirty = true;
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this._listeners.remove(listener);
    }

    public void setDefault(String name, double value) {
        this.setDefault(name, String.valueOf(value));
    }

    public void setDefault(String name, float value) {
        this.setDefault(name, String.valueOf(value));
    }

    public void setDefault(String name, int value) {
        this.setDefault(name, String.valueOf(value));
    }

    public void setDefault(String name, long value) {
        this.setDefault(name, String.valueOf(value));
    }

    public void setDefault(String name, String defaultObject) {
        this._variables.setDefault(name, defaultObject);
        this._dirty = true;
    }

    public void setDefault(String name, boolean value) {
        this.setDefault(name, String.valueOf(value));
    }

    public void setToDefault(String name) {
        this.setValue(name, this.getDefaultString(name));
    }

    public void setValue(String name, double value) {
        this.setValue(name, String.valueOf(value));
    }

    public void setValue(String name, float value) {
        this.setValue(name, String.valueOf(value));
    }

    public void setValue(String name, int value) {
        this.setValue(name, String.valueOf(value));
    }

    public void setValue(String name, long value) {
        this.setValue(name, String.valueOf(value));
    }

    public void setValue(String name, String value) {
        this._variables.setProperty(name, value);
        this._dirty = true;
    }

    public void setValue(String name, boolean value) {
        this.setValue(name, String.valueOf(value));
    }

    public void save() throws IOException {
        this._variables.save();
        this._dirty = false;
    }
}

