/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eogenerator.jdt;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.objectstyle.wolips.baseforplugins.util.ComparisonUtils;
import org.objectstyle.wolips.eogenerator.core.model.EOGeneratorModel;
import org.objectstyle.wolips.jdt.ProjectFrameworkAdapter;

public class EOGeneratorCreator {
    public static EOGeneratorModel createDefaultModel(IProject project) {
        EOGeneratorModel model = new EOGeneratorModel(project);
        model.setJava(Boolean.TRUE);
        model.setPackageDirs(Boolean.TRUE);
        model.setVerbose(Boolean.TRUE);
        model.setLoadModelGroup(Boolean.TRUE);
        try {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            if (javaProject != null) {
                IClasspathEntry[] classpathEntry = javaProject.getRawClasspath();
                for (int classpathEntryNum = 0; classpathEntryNum < classpathEntry.length; ++classpathEntryNum) {
                    IPath path;
                    IClasspathEntry entry = classpathEntry[classpathEntryNum];
                    if (entry.getEntryKind() != 3 || (path = entry.getPath()) == null) continue;
                    IFolder sourceFolder = project.getWorkspace().getRoot().getFolder(path);
                    IPath projectRelativePath = sourceFolder.getProjectRelativePath();
                    String projectRelativePathStr = projectRelativePath.toPortableString();
                    model.setDestination(projectRelativePathStr);
                    model.setSubclassDestination(projectRelativePathStr);
                }
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        try {
            if (ComparisonUtils.equals((String)model.getDefaultJavaTemplate(), null, (boolean)true) && ((ProjectFrameworkAdapter)project.getAdapter(ProjectFrameworkAdapter.class)).isLinkedToFrameworkNamed("ERExtensions")) {
                model.setJavaTemplate("_WonderEntity.java");
                model.setSubclassJavaTemplate("WonderEntity.java");
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return model;
    }
}

