/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.jdt;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Platform;
import org.objectstyle.woenvironment.frameworks.Version;
import org.objectstyle.wolips.core.resources.types.project.ProjectAdapter;
import org.objectstyle.wolips.jdt.JdtPlugin;
import org.objectstyle.wolips.jdt.ProjectFrameworkAdapter;
import org.objectstyle.wolips.jdt.classpath.model.IEclipseFramework;
import org.objectstyle.wolips.variables.BuildProperties;
import org.objectstyle.wolips.variables.IBuildPropertiesInitializer;
import org.objectstyle.wolips.variables.VariablesPlugin;

public class WOBuildPropertiesInitializer
implements IBuildPropertiesInitializer {
    public void initializeDefaults(BuildProperties buildProperties) {
        IProject project = buildProperties.getProject();
        if (!project.isAccessible()) {
            return;
        }
        try {
            ProjectFrameworkAdapter projectFrameworkAdaptor = (ProjectFrameworkAdapter)project.getAdapter(ProjectFrameworkAdapter.class);
            if (projectFrameworkAdaptor != null) {
                boolean wellFormedTemplateRequiredDefault;
                Version version;
                IEclipseFramework foundationFramework = "JavaFoundation".equals(project.getName()) ? (IEclipseFramework)JdtPlugin.getDefault().getFrameworkModel(project).getFrameworkWithName("JavaFoundation") : projectFrameworkAdaptor.getLinkedFrameworkNamed("JavaFoundation");
                if (foundationFramework != null && (version = foundationFramework.getVersion()) != null && !version.isUndefined()) {
                    buildProperties.setWOVersionDefault(version);
                }
                if (projectFrameworkAdaptor.isLinkedToFrameworkNamed("WOOgnl")) {
                    buildProperties.setInlineBindingPrefixDefault("$");
                    buildProperties.setInlineBindingSuffixDefault("");
                    wellFormedTemplateRequiredDefault = false;
                } else if (buildProperties.getWOVersion().isAtLeastVersion(5, 4)) {
                    buildProperties.setInlineBindingPrefixDefault("[");
                    buildProperties.setInlineBindingSuffixDefault("]");
                    wellFormedTemplateRequiredDefault = true;
                } else {
                    buildProperties.setInlineBindingPrefixDefault("[");
                    buildProperties.setInlineBindingSuffixDefault("]");
                    wellFormedTemplateRequiredDefault = false;
                }
                String globalWellFormedTemplateRequiredDefault = Platform.getPreferencesService().getString("org.objectstyle.wolips.bindings", "WellFormedTemplate", null, null);
                if ("yes".equals(globalWellFormedTemplateRequiredDefault)) {
                    wellFormedTemplateRequiredDefault = true;
                } else if ("no".equals(globalWellFormedTemplateRequiredDefault)) {
                    wellFormedTemplateRequiredDefault = false;
                }
                buildProperties.setWellFormedTemplateRequiredDefault(VariablesPlugin.getDefault().getGlobalVariables().getBoolean("component.wellFormedTemplateRequired", wellFormedTemplateRequiredDefault));
                IEclipseFramework framework = projectFrameworkAdaptor.getFramework();
                if (framework != null) {
                    buildProperties.setVersionDefault(framework.getVersion());
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace(System.out);
        }
    }

    public void initialize(BuildProperties buildProperties) {
        int buildPropertiesVersion;
        IProject project = buildProperties.getProject();
        if (!project.isAccessible()) {
            return;
        }
        String buildPropertiesVersionStr = VariablesPlugin.getDefault().getProjectVariables(project).getString("wolips.buildPropertiesVersion");
        int n = buildPropertiesVersion = buildPropertiesVersionStr == null ? Integer.MAX_VALUE : Integer.parseInt(buildPropertiesVersionStr);
        if (!buildProperties.hasValidProjectType() && buildPropertiesVersion > 0) {
            ProjectAdapter projectAdapter = (ProjectAdapter)project.getAdapter(ProjectAdapter.class);
            boolean framework = false;
            if (projectAdapter != null) {
                framework = projectAdapter.isFramework();
            }
            buildProperties.setFramework(framework);
            String projectName = buildProperties.getName();
            if (framework) {
                if (projectName == null) {
                    String frameworkName = buildProperties.get("framework.name");
                    if (frameworkName == null) {
                        buildProperties.setName(project.getName());
                    } else {
                        buildProperties.setName(frameworkName);
                    }
                } else {
                    buildProperties.setName(projectName);
                }
                buildProperties.remove("framework.name");
            } else if (projectName == null) {
                buildProperties.setName(project.getName());
            } else {
                buildProperties.setName(projectName);
            }
        }
    }
}

