/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.jdt.classpath.model;

import java.io.File;
import java.util.LinkedList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.objectstyle.woenvironment.frameworks.AbstractFolderFramework;
import org.objectstyle.woenvironment.frameworks.FrameworkLibrary;
import org.objectstyle.woenvironment.frameworks.Root;
import org.objectstyle.wolips.jdt.classpath.model.IEclipseFramework;
import org.objectstyle.wolips.variables.VariablesPlugin;

public class EclipsePathFramework
extends AbstractFolderFramework
implements IEclipseFramework {
    private IClasspathEntry[] cachedClasspathEntries;

    public EclipsePathFramework(Root root, File frameworkFolder) {
        super(root, frameworkFolder);
    }

    @Override
    public synchronized IClasspathEntry[] getClasspathEntries() {
        if (this.cachedClasspathEntries == null) {
            LinkedList<IClasspathEntry> classpathEntries = new LinkedList<IClasspathEntry>();
            for (FrameworkLibrary library : this.getFrameworkLibraries()) {
                Path jarPath = new Path(library.getLibraryFile().getAbsolutePath());
                Path sourceJarPath = null;
                File sourceJar = library.getSourceJar();
                if (sourceJar != null) {
                    sourceJarPath = new Path(library.getSourceJar().getAbsolutePath());
                }
                String sourcePathStr = library.getSourcePath();
                Path sourcePath = null;
                if (sourcePathStr != null) {
                    sourcePath = new Path(sourcePathStr);
                }
                String docPathStr = library.getDocPath();
                IClasspathAttribute[] attributes = ClasspathEntry.NO_EXTRA_ATTRIBUTES;
                if (docPathStr != null || this.getName().startsWith("Java")) {
                    if (docPathStr == null) {
                        docPathStr = VariablesPlugin.getDefault().getGlobalVariables().getReferenceApiAsJavaDocCompatibleString();
                    }
                    if (docPathStr != null) {
                        IClasspathAttribute javadoc = JavaCore.newClasspathAttribute((String)"javadoc_location", (String)docPathStr);
                        attributes = new IClasspathAttribute[]{javadoc};
                    }
                }
                IClasspathEntry classpathEntry = JavaCore.newLibraryEntry((IPath)jarPath, (IPath)sourceJarPath, (IPath)sourcePath, (IAccessRule[])ClasspathEntry.NO_ACCESS_RULES, (IClasspathAttribute[])attributes, (boolean)false);
                classpathEntries.add(classpathEntry);
            }
            this.cachedClasspathEntries = classpathEntries.toArray(new IClasspathEntry[classpathEntries.size()]);
        }
        return (IClasspathEntry[])this.cachedClasspathEntries.clone();
    }
}

