/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.jdt.classpath.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.objectstyle.woenvironment.frameworks.Root;
import org.objectstyle.wolips.core.resources.types.project.ProjectAdapter;
import org.objectstyle.wolips.jdt.classpath.model.EclipseProjectFramework;
import org.objectstyle.wolips.jdt.classpath.model.IEclipseFramework;

public class EclipseProjectRoot
extends Root<IEclipseFramework> {
    private IWorkspaceRoot workspaceRoot;
    private Set<IEclipseFramework> cachedFrameworks;
    private Map<String, IEclipseFramework> cachedFrameworksByName;
    private Set<IEclipseFramework> cachedApplications;
    private Map<String, IEclipseFramework> cachedApplicationsByName;

    public EclipseProjectRoot(String shortName, String name, IWorkspaceRoot workspaceRoot) {
        super(shortName, name);
        this.workspaceRoot = workspaceRoot;
    }

    public synchronized Set<IEclipseFramework> getFrameworks() {
        Set<IEclipseFramework> frameworks = this.cachedFrameworks;
        if (frameworks == null) {
            IProject[] projects;
            frameworks = new HashSet<IEclipseFramework>();
            HashMap<String, IEclipseFramework> frameworksMap = new HashMap<String, IEclipseFramework>();
            for (IProject project : projects = this.workspaceRoot.getProjects()) {
                ProjectAdapter woProjectAdaptor;
                if (!project.isAccessible() || (woProjectAdaptor = (ProjectAdapter)project.getAdapter(ProjectAdapter.class)) == null || !woProjectAdaptor.isFramework()) continue;
                EclipseProjectFramework framework = new EclipseProjectFramework(this, project);
                frameworks.add(framework);
                frameworksMap.put(framework.getName(), framework);
            }
            this.cachedFrameworks = frameworks;
            this.cachedFrameworksByName = frameworksMap;
        }
        return frameworks;
    }

    public synchronized Set<IEclipseFramework> getApplications() {
        Set<IEclipseFramework> applications = this.cachedApplications;
        if (applications == null) {
            IProject[] projects;
            applications = new HashSet<IEclipseFramework>();
            HashMap<String, IEclipseFramework> applicationsMap = new HashMap<String, IEclipseFramework>();
            for (IProject project : projects = this.workspaceRoot.getProjects()) {
                ProjectAdapter woProjectAdaptor;
                if (!project.isAccessible() || (woProjectAdaptor = (ProjectAdapter)project.getAdapter(ProjectAdapter.class)) == null || !woProjectAdaptor.isApplication()) continue;
                EclipseProjectFramework application = new EclipseProjectFramework(this, project);
                applications.add(application);
                applicationsMap.put(application.getName(), application);
            }
            this.cachedApplications = applications;
            this.cachedApplicationsByName = applicationsMap;
        }
        return applications;
    }

    public IEclipseFramework getApplicationWithName(String applicationName) {
        if (this.cachedApplicationsByName == null) {
            this.getApplications();
        }
        return this.cachedApplicationsByName.get(applicationName);
    }

    public IEclipseFramework getFrameworkWithName(String frameworkName) {
        if (this.cachedFrameworksByName == null) {
            this.getFrameworks();
        }
        return this.cachedFrameworksByName.get(frameworkName);
    }

    public String toString() {
        return "[EclipseProjectRoot]";
    }
}

