/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.core.model;

import java.util.HashSet;
import java.util.Set;
import org.objectstyle.wolips.eomodeler.core.model.DuplicateEntityIndexNameException;
import org.objectstyle.wolips.eomodeler.core.model.EOAttribute;
import org.objectstyle.wolips.eomodeler.core.model.EOEntity;
import org.objectstyle.wolips.eomodeler.core.model.EOModelException;
import org.objectstyle.wolips.eomodeler.core.model.EOModelMap;
import org.objectstyle.wolips.eomodeler.core.model.EOModelReferenceFailure;
import org.objectstyle.wolips.eomodeler.core.model.EOModelVerificationFailure;
import org.objectstyle.wolips.eomodeler.core.model.IEOEntityRelative;
import org.objectstyle.wolips.eomodeler.core.model.ISortableEOModelObject;
import org.objectstyle.wolips.eomodeler.core.model.MissingAttributeFailure;
import org.objectstyle.wolips.eomodeler.core.model.UserInfoableEOModelObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EOEntityIndex
extends UserInfoableEOModelObject<EOEntity>
implements IEOEntityRelative,
ISortableEOModelObject {
    public static final String NAME = "name";
    public static final String ATTRIBUTES = "attributes";
    public static final String CONSTRAINT = "constraint";
    public static final String INDEX_TYPE = "indexType";
    public static final String ORDER = "order";
    private EOEntity _entity;
    private String _name;
    private Constraint _constraint = Constraint.None;
    private IndexType _indexType = IndexType.Clustered;
    private Order _order = Order.Ascending;
    private Set<EOAttribute> _attributes;
    private EOModelMap _entityIndexMap = new EOModelMap();

    public EOEntityIndex() {
        this._attributes = new HashSet<EOAttribute>();
    }

    @Override
    public Set<EOModelReferenceFailure> getReferenceFailures() {
        return new HashSet<EOModelReferenceFailure>();
    }

    @Override
    protected void _propertyChanged(String propertyName, Object oldValue, Object newValue) {
        if (this._entity != null) {
            this._entity._entityIndexChanged(this, propertyName, oldValue, newValue);
        }
    }

    @Override
    public void setName(String name) throws DuplicateEntityIndexNameException {
        this.setName(name, true);
    }

    public void setName(String name, boolean fireEvents) throws DuplicateEntityIndexNameException {
        if (this._entity != null) {
            this._entity._checkForDuplicateEntityIndexName(this, name, null);
        }
        String oldName = this._name;
        this._name = name;
        if (fireEvents) {
            this.firePropertyChange(NAME, oldName, this._name);
        }
    }

    public Constraint getConstraint() {
        return this._constraint;
    }

    public void setConstraint(Constraint constrain) {
        this.setConstraint(constrain, true);
    }

    public void setConstraint(Constraint constraint, boolean fireEvents) {
        Constraint oldConstrain = this._constraint;
        this._constraint = constraint == null ? Constraint.None : constraint;
        if (fireEvents) {
            this.firePropertyChange(CONSTRAINT, (Object)oldConstrain, (Object)this._constraint);
        }
    }

    public IndexType getIndexType() {
        return this._indexType;
    }

    public void setIndexType(IndexType indexType) {
        this.setIndexType(indexType, true);
    }

    public void setIndexType(IndexType indexType, boolean fireEvents) {
        IndexType oldIndexType = this._indexType;
        this._indexType = indexType;
        if (fireEvents) {
            this.firePropertyChange(INDEX_TYPE, (Object)oldIndexType, (Object)this._indexType);
        }
    }

    public Order getOrder() {
        return this._order;
    }

    public void setOrder(Order order) {
        this.setOrder(order, true);
    }

    public void setOrder(Order order, boolean fireEvents) {
        Order oldOrder = this._order;
        this._order = order;
        if (fireEvents) {
            this.firePropertyChange(ORDER, (Object)oldOrder, (Object)this._order);
        }
    }

    @Override
    public String getName() {
        return this._name;
    }

    public void _setEntity(EOEntity entity) {
        this._entity = entity;
    }

    @Override
    public EOEntity getEntity() {
        return this._entity;
    }

    public void addAttribute(EOAttribute attribute) {
        this.addAttribute(attribute, true);
    }

    public synchronized void addAttribute(EOAttribute attribute, boolean fireEvents) {
        Set<EOAttribute> oldAttributes = null;
        if (fireEvents) {
            oldAttributes = this._attributes;
            HashSet<EOAttribute> newAttributes = new HashSet<EOAttribute>();
            newAttributes.addAll(this._attributes);
            newAttributes.add(attribute);
            this._attributes = newAttributes;
            this.firePropertyChange(ATTRIBUTES, oldAttributes, newAttributes);
        } else {
            this._attributes.add(attribute);
        }
    }

    public void removeAttribute(EOAttribute attribute, boolean fireEvents) {
        if (fireEvents) {
            Set<EOAttribute> oldAttributes = this._attributes;
            HashSet<EOAttribute> newAttributes = new HashSet<EOAttribute>();
            newAttributes.addAll(this._attributes);
            newAttributes.remove(attribute);
            this._attributes = newAttributes;
            this.firePropertyChange(ATTRIBUTES, oldAttributes, newAttributes);
        } else {
            this._attributes.remove(attribute);
        }
    }

    public Set<EOAttribute> getAttributes() {
        return this._attributes;
    }

    public void loadFromMap(EOModelMap _map, Set<EOModelVerificationFailure> _failures) {
        this._entityIndexMap = _map;
        this._name = _map.getString(NAME, true);
        this._constraint = Constraint.getConstraintNamed(_map.getString(CONSTRAINT, true));
        this._indexType = IndexType.getIndexTypeNamed(_map.getString(INDEX_TYPE, true));
        this._order = Order.getOrderNamed(_map.getString(ORDER, true));
        this.loadUserInfo(_map);
    }

    public EOModelMap toMap() {
        EOModelMap entityIndexMap = this._entityIndexMap.cloneModelMap();
        entityIndexMap.setString(NAME, this._name, true);
        entityIndexMap.setString(CONSTRAINT, this._constraint.getExternalName(), true);
        entityIndexMap.setString(INDEX_TYPE, this._indexType.getExternalName(), true);
        entityIndexMap.setString(ORDER, this._order.getExternalName(), true);
        HashSet<String> attributeNames = new HashSet<String>();
        for (EOAttribute attribute : this._attributes) {
            attributeNames.add(attribute.getName());
        }
        entityIndexMap.setSet(ATTRIBUTES, attributeNames, false);
        this.writeUserInfo(entityIndexMap);
        return entityIndexMap;
    }

    public void resolve(Set<EOModelVerificationFailure> _failures) {
        this._attributes.clear();
        Set attributeNames = this._entityIndexMap.getSet(ATTRIBUTES);
        for (String attributeName : attributeNames) {
            EOAttribute attribute = this._entity.getAttributeNamed(attributeName);
            if (attribute == null) {
                _failures.add(new MissingAttributeFailure(this._entity, attributeName));
            }
            this._attributes.add(attribute);
        }
    }

    public void verify(Set<EOModelVerificationFailure> _failures) {
    }

    @Override
    public String getFullyQualifiedName() {
        return String.valueOf(this._entity == null ? "?" : this._entity.getFullyQualifiedName()) + "/index: " + this.getName();
    }

    public EOEntityIndex _cloneModelObject() {
        EOEntityIndex entityIndex = new EOEntityIndex();
        entityIndex._name = this._name;
        entityIndex._constraint = this._constraint;
        entityIndex._indexType = this._indexType;
        entityIndex._order = this._order;
        this._cloneUserInfoInto(entityIndex);
        return entityIndex;
    }

    @Override
    public Class<EOEntity> _getModelParentType() {
        return EOEntity.class;
    }

    @Override
    public EOEntity _getModelParent() {
        return this.getEntity();
    }

    @Override
    public void _removeFromModelParent(Set<EOModelVerificationFailure> failures) {
        this.getEntity().removeEntityIndex(this);
    }

    @Override
    public void _addToModelParent(EOEntity modelParent, boolean findUniqueName, Set<EOModelVerificationFailure> failures) throws EOModelException {
        if (findUniqueName) {
            this.setName(modelParent.findUnusedEntityIndexName(this.getName()));
        }
        modelParent.addEntityIndex(this);
    }

    public String toString() {
        return "[EOEntityIndex: name = " + this._name + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Constraint {
        Distinct("distinct"),
        FullText("fulltext"),
        Spatial("spatial"),
        None("none");

        private String _externalName;

        private Constraint(String externalName) {
            this._externalName = externalName;
        }

        public String getExternalName() {
            return this._externalName;
        }

        public static Constraint getConstraintNamed(String externalName) {
            Constraint matchingConstraint = null;
            if (externalName == null) {
                matchingConstraint = None;
            } else {
                Constraint[] constraints = Constraint.values();
                int i = 0;
                while (matchingConstraint == null && i < constraints.length) {
                    if (constraints[i].getExternalName().equalsIgnoreCase(externalName)) {
                        matchingConstraint = constraints[i];
                    }
                    ++i;
                }
            }
            return matchingConstraint;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IndexType {
        Clustered("clustered"),
        Hashed("hashed");

        private String _externalName;

        private IndexType(String externalName) {
            this._externalName = externalName;
        }

        public String getExternalName() {
            return this._externalName;
        }

        public static IndexType getIndexTypeNamed(String externalName) {
            IndexType matchingIndexType = null;
            if (externalName == null) {
                matchingIndexType = Clustered;
            } else {
                IndexType[] indexTypes = IndexType.values();
                int i = 0;
                while (matchingIndexType == null && i < indexTypes.length) {
                    if (indexTypes[i].getExternalName().equalsIgnoreCase(externalName)) {
                        matchingIndexType = indexTypes[i];
                    }
                    ++i;
                }
            }
            return matchingIndexType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Order {
        Ascending("asc"),
        Descending("desc");

        private String _externalName;

        private Order(String externalName) {
            this._externalName = externalName;
        }

        public String getExternalName() {
            return this._externalName;
        }

        public static Order getOrderNamed(String externalName) {
            Order matchingOrder = null;
            if (externalName == null) {
                matchingOrder = Ascending;
            } else {
                Order[] orders = Order.values();
                int i = 0;
                while (matchingOrder == null && i < orders.length) {
                    if (orders[i].getExternalName().equalsIgnoreCase(externalName)) {
                        matchingOrder = orders[i];
                    }
                    ++i;
                }
            }
            return matchingOrder;
        }
    }
}

