/*
 * Decompiled with CFR 0.152.
 */
package com.steadystate.css.dom;

import com.steadystate.css.dom.CSSStyleDeclarationImpl;
import com.steadystate.css.dom.CSSStyleSheetImpl;
import com.steadystate.css.dom.DOMExceptionImpl;
import com.steadystate.css.parser.CSSOMParser;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSPageRule;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleSheet;

public class CSSPageRuleImpl
implements CSSPageRule,
Serializable {
    private CSSStyleSheetImpl _parentStyleSheet = null;
    private CSSRule _parentRule = null;
    private String _ident = null;
    private String _pseudoPage = null;
    private CSSStyleDeclaration _style = null;

    public CSSPageRuleImpl(CSSStyleSheetImpl cSSStyleSheetImpl, CSSRule cSSRule, String string, String string2) {
        this._parentStyleSheet = cSSStyleSheetImpl;
        this._parentRule = cSSRule;
        this._ident = string;
        this._pseudoPage = string2;
    }

    public short getType() {
        return 6;
    }

    public String getCssText() {
        String string = this.getSelectorText();
        return "@page " + string + (string.length() > 0 ? " " : "") + this.getStyle().getCssText();
    }

    public void setCssText(String string) throws DOMException {
        if (this._parentStyleSheet != null && this._parentStyleSheet.isReadOnly()) {
            throw new DOMExceptionImpl(7, 2);
        }
        try {
            InputSource inputSource = new InputSource(new StringReader(string));
            CSSOMParser cSSOMParser = new CSSOMParser();
            CSSRule cSSRule = cSSOMParser.parseRule(inputSource);
            if (cSSRule.getType() != 6) {
                throw new DOMExceptionImpl(13, 9);
            }
            this._ident = ((CSSPageRuleImpl)cSSRule)._ident;
            this._pseudoPage = ((CSSPageRuleImpl)cSSRule)._pseudoPage;
            this._style = ((CSSPageRuleImpl)cSSRule)._style;
        }
        catch (CSSException cSSException) {
            throw new DOMExceptionImpl(12, 0, cSSException.getMessage());
        }
        catch (IOException iOException) {
            throw new DOMExceptionImpl(12, 0, iOException.getMessage());
        }
    }

    public CSSStyleSheet getParentStyleSheet() {
        return this._parentStyleSheet;
    }

    public CSSRule getParentRule() {
        return this._parentRule;
    }

    public String getSelectorText() {
        return (this._ident != null ? this._ident : "") + (this._pseudoPage != null ? ":" + this._pseudoPage : "");
    }

    public void setSelectorText(String string) throws DOMException {
    }

    public CSSStyleDeclaration getStyle() {
        return this._style;
    }

    protected void setIdent(String string) {
        this._ident = string;
    }

    protected void setPseudoPage(String string) {
        this._pseudoPage = string;
    }

    public void setStyle(CSSStyleDeclarationImpl cSSStyleDeclarationImpl) {
        this._style = cSSStyleDeclarationImpl;
    }
}

