/*
 * Decompiled with CFR 0.152.
 */
package er.wojrebel;

import com.webobjects.appserver.WOAction;
import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WORequest;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSNotification;
import com.webobjects.foundation.NSValidation;
import er.wojrebel.WOClassCacheAccessor;
import java.util.Enumeration;
import org.zeroturnaround.javarebel.ClassEventListener;
import org.zeroturnaround.javarebel.Logger;
import org.zeroturnaround.javarebel.LoggerFactory;
import org.zeroturnaround.javarebel.Reloader;
import org.zeroturnaround.javarebel.ReloaderFactory;

public class WOJRebelClassReloadHandler {
    private static boolean initialized = false;
    private boolean resetKVCCaches = false;
    private boolean resetComponentCache = false;
    private boolean resetActionClassCache = false;
    private boolean resetValidationCache = false;
    private static final WOJRebelClassReloadHandler instance = new WOJRebelClassReloadHandler();
    private static final Logger log = LoggerFactory.getInstance();

    private WOJRebelClassReloadHandler() {
    }

    public static WOJRebelClassReloadHandler getInstance() {
        return instance;
    }

    private void doReset() {
        if (this.resetKVCCaches) {
            this.resetKVCCaches = false;
            log.echo("JRebel: Resetting KeyValueCoding caches");
            NSKeyValueCoding.DefaultImplementation._flushCaches();
            NSKeyValueCoding._ReflectionKeyBindingCreation._flushCaches();
            NSKeyValueCoding.ValueAccessor._flushCaches();
        }
        if (this.resetComponentCache) {
            this.resetComponentCache = false;
            log.echo("JRebel: Resetting Component Definition cache");
            WOApplication.application()._removeComponentDefinitionCacheContents();
        }
        if (this.resetActionClassCache) {
            this.resetActionClassCache = false;
            log.echo("JRebel: Resetting Action class cache");
            WOClassCacheAccessor.clearActionClassCache();
        }
        if (this.resetValidationCache) {
            this.resetValidationCache = false;
            log.echo("JRebel: Resetting NSValidation cache");
            NSValidation.DefaultImplementation._flushCaches();
        }
    }

    public void initialize() {
        if (initialized) {
            return;
        }
        initialized = true;
        if (WOApplication.application() != null && WOApplication.application().isCachingEnabled()) {
            System.out.println("Running in deployment mode. Rapid turnaround is disabled");
            return;
        }
        if (!this.isReloadEnabled()) {
            System.out.println("JRebel rapid turnaround mode is disabled because JRebel is not running \n    To use JRebel rapid turnaround you must add the following to your Java VM arguments:\n        -noverify -javaagent:<pathtojar>/jrebel.jar");
            System.out.println("    JRebel can be obtained from www.zeroturnaround.com");
            return;
        }
        log.echo("JRebel: WebObjects support enabled");
        WOEventClassListener listener = new WOEventClassListener();
        Reloader reloader = ReloaderFactory.getInstance();
        reloader.addClassReloadListener((ClassEventListener)listener);
    }

    public void reloaded(Class clazz) {
        this.resetKVCCaches = true;
        if (WOComponent.class.isAssignableFrom(clazz)) {
            this.resetComponentCache = true;
        }
        if (WOAction.class.isAssignableFrom(clazz)) {
            this.resetActionClassCache = true;
        }
        if (NSValidation.class.isAssignableFrom(clazz)) {
            this.resetValidationCache = true;
        }
        this.doReset();
    }

    public synchronized void updateLoadedClasses(NSNotification notification) {
        Reloader reloader = ReloaderFactory.getInstance();
        if (notification != null) {
            WORequest request = (WORequest)notification.object();
            String key = "/" + WOApplication.application().resourceRequestHandlerKey();
            if (request.uri().indexOf(request.adaptorPrefix()) != 0 || request.uri().indexOf(key) >= 0) {
                return;
            }
        }
        NSDictionary classList = WOClassCacheAccessor.getClassCache();
        String unknownClassName = "com.webobjects.foundation._NSUtilities$_NoClassUnderTheSun";
        Class<?> unknownClass = WOClassCacheAccessor.classForName(unknownClassName);
        Enumeration en = classList.keyEnumerator();
        while (en.hasMoreElements()) {
            Class<?> clazz;
            String className = (String)en.nextElement();
            if (className.equals(unknownClassName) || (clazz = WOClassCacheAccessor.classForName(className)) != null && clazz.isPrimitive()) continue;
            if (clazz == null || clazz.equals(unknownClass)) {
                WOClassCacheAccessor.removeClassForName(className);
                continue;
            }
            reloader.checkAndReload(clazz);
        }
        this.doReset();
    }

    public boolean isReloadEnabled() {
        return ReloaderFactory.getInstance().isReloadEnabled();
    }

    private class WOEventClassListener
    implements ClassEventListener {
        private WOEventClassListener() {
        }

        public void onClassEvent(int eventType, Class clazz) {
            if (eventType == 1) {
                WOJRebelClassReloadHandler.this.reloaded(clazz);
            }
        }

        public int priority() {
            return 0;
        }
    }
}

