/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.woenvironment.frameworks;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.objectstyle.woenvironment.frameworks.IFramework;
import org.objectstyle.woenvironment.frameworks.Root;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FrameworkModel<T extends IFramework> {
    private List<Root<T>> roots;

    protected abstract List<Root<T>> createRoots();

    public synchronized void invalidateRoots() {
        this.roots = null;
    }

    public synchronized List<Root<T>> getRoots() {
        if (this.roots == null) {
            this.roots = this.createRoots();
        }
        return this.roots;
    }

    public synchronized Set<T> getAllFrameworks() {
        HashMap<String, IFramework> frameworks = new HashMap<String, IFramework>();
        for (Root<T> root : this.getRoots()) {
            for (IFramework framework : root.getFrameworks()) {
                String frameworkName = framework.getName();
                if (frameworks.containsKey(frameworkName)) continue;
                frameworks.put(frameworkName, framework);
            }
        }
        return new HashSet(frameworks.values());
    }

    public synchronized Set<T> getAllApplications() {
        HashMap<String, IFramework> applications = new HashMap<String, IFramework>();
        for (Root<T> root : this.getRoots()) {
            for (IFramework application : root.getApplications()) {
                String frameworkName = application.getName();
                if (applications.containsKey(frameworkName)) continue;
                applications.put(frameworkName, application);
            }
        }
        return new HashSet(applications.values());
    }

    public synchronized void refreshRoots() {
        this.roots = null;
        this.getRoots();
    }

    public T getFrameworkWithName(String frameworkName) {
        for (Root<T> root : this.getRoots()) {
            T framework = root.getFrameworkWithName(frameworkName);
            if (framework == null) continue;
            return framework;
        }
        return null;
    }

    public T getApplicationWithName(String applicationName) {
        for (Root<T> root : this.getRoots()) {
            T application = root.getApplicationWithName(applicationName);
            if (application == null) continue;
            return application;
        }
        return null;
    }

    public Root<T> getRootWithShortName(String shortName) {
        for (Root<T> root : this.getRoots()) {
            if (!shortName.equals(root.getShortName())) continue;
            return root;
        }
        return null;
    }
}

