/* ====================================================================
 * 
 * The ObjectStyle Group Software License, Version 1.0 
 *
 * Copyright (c) 2002 The ObjectStyle Group 
 * and individual authors of the software.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:  
 *       "This product includes software developed by the 
 *        ObjectStyle Group (http://objectstyle.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "ObjectStyle Group" and "Cayenne" 
 *    must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written 
 *    permission, please contact andrus@objectstyle.org.
 *
 * 5. Products derived from this software may not be called "ObjectStyle"
 *    nor may "ObjectStyle" appear in their names without prior written
 *    permission of the ObjectStyle Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE OBJECTSTYLE GROUP OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the ObjectStyle Group.  For more
 * information on the ObjectStyle Group, please see
 * <http://objectstyle.org/>.
 *
 */
/* Generated By:JavaCC: Do not edit this line. Parser.java */
package org.objectstyle.woenvironment.util;

import java.io.*;
import java.util.*;

@SuppressWarnings("all")
public class Parser implements ParserConstants {
	public Hashtable parseStrings;

	public Parser() {
		this(System.in);
	}

	public Parser(String filename) throws FileNotFoundException {
		this(new FileInputStream(filename));
	}

	public Parser(File f) throws FileNotFoundException {
		this(new FileInputStream(f));
	}

	public Object propertyList() {
		try {
			return object();
		} catch (ParseException pe) {
			System.err.println("Error parsing property list file: " + pe);
			return null;
		}
	}

	public static void main(String args[]) {
		Parser r = new Parser();
		Object o = r.propertyList();
		System.out.println(o);
	}

	final public Object object() throws ParseException {
		Object node;
		switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
		case 10:
			node = array();
			{
				if (true)
					return node;
			}
			break;
		case 12:
			node = dictionary();
			{
				if (true)
					return node;
			}
			break;
		case INT:
		case FLOAT:
		case STRING:
		case QUOTED_STRING:
			node = leaf();
			{
				if (true)
					return node;
			}
			break;
		default:
			jj_la1[0] = jj_gen;
			jj_consume_token(-1);
			throw new ParseException();
		}
		throw new Error("Missing return statement in function");
	}

	final public Object leaf() throws ParseException {
		switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
		case INT:
			jj_consume_token(INT);
			{
				if (true)
					return Integer.valueOf(token.image);
			}
			break;
		case FLOAT:
			jj_consume_token(FLOAT);
			{
				if (true)
					return Double.valueOf(token.image);
			}
			break;
		case QUOTED_STRING:
			jj_consume_token(QUOTED_STRING);
			{
				if (true)
					return token.image;
			}
			break;
		case STRING:
			jj_consume_token(STRING);
			{
				if (true)
					return token.image;
			}
			break;
		default:
			jj_la1[1] = jj_gen;
			jj_consume_token(-1);
			throw new ParseException();
		}
		throw new Error("Missing return statement in function");
	}

	final public HashMap dictionary() throws ParseException {
		HashMap h;
		Object key, val;
		jj_consume_token(12);
		h = new HashMap();
		label_1: while (true) {
			switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
			case INT:
			case FLOAT:
			case 10:
			case 12:
			case STRING:
			case QUOTED_STRING:
				break;
			default:
				jj_la1[2] = jj_gen;
				break label_1;
			}
			key = object();
			jj_consume_token(9);
			val = object();
			jj_consume_token(15);
			h.put(key, val);
		}
		jj_consume_token(13);
		{
			if (true)
				return h;
		}
		throw new Error("Missing return statement in function");
	}

	final public ArrayList array() throws ParseException {
		ArrayList v;
		Object o;
		jj_consume_token(10);
		v = new ArrayList();
		label_2: while (true) {
			switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
			case INT:
			case FLOAT:
			case 10:
			case 12:
			case STRING:
			case QUOTED_STRING:
				break;
			default:
				jj_la1[3] = jj_gen;
				break label_2;
			}
			o = object();
			v.add(o);
			switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
			case 14:
				jj_consume_token(14);
				break;
			default:
				jj_la1[4] = jj_gen;
			}
		}
		jj_consume_token(11);
		{
			if (true)
				return v;
		}
		throw new Error("Missing return statement in function");
	}

	public ParserTokenManager token_source;

	SimpleCharStream jj_input_stream;

	public Token token, jj_nt;

	private int jj_ntk;

	private int jj_gen;

	final private int[] jj_la1 = new int[5];

	static private int[] jj_la1_0;
	static {
		jj_la1_0();
	}

	private static void jj_la1_0() {
		jj_la1_0 = new int[] { 0x20011580, 0x20010180, 0x20011580, 0x20011580, 0x4000, };
	}

	public Parser(java.io.InputStream stream) {
		jj_input_stream = new SimpleCharStream(stream, 1, 1);
		token_source = new ParserTokenManager(jj_input_stream);
		token = new Token();
		jj_ntk = -1;
		jj_gen = 0;
		for (int i = 0; i < 5; i++)
			jj_la1[i] = -1;
	}

	public void ReInit(java.io.InputStream stream) {
		jj_input_stream.ReInit(stream, 1, 1);
		token_source.ReInit(jj_input_stream);
		token = new Token();
		jj_ntk = -1;
		jj_gen = 0;
		for (int i = 0; i < 5; i++)
			jj_la1[i] = -1;
	}

	public Parser(java.io.Reader stream) {
		jj_input_stream = new SimpleCharStream(stream, 1, 1);
		token_source = new ParserTokenManager(jj_input_stream);
		token = new Token();
		jj_ntk = -1;
		jj_gen = 0;
		for (int i = 0; i < 5; i++)
			jj_la1[i] = -1;
	}

	public void ReInit(java.io.Reader stream) {
		jj_input_stream.ReInit(stream, 1, 1);
		token_source.ReInit(jj_input_stream);
		token = new Token();
		jj_ntk = -1;
		jj_gen = 0;
		for (int i = 0; i < 5; i++)
			jj_la1[i] = -1;
	}

	public Parser(ParserTokenManager tm) {
		token_source = tm;
		token = new Token();
		jj_ntk = -1;
		jj_gen = 0;
		for (int i = 0; i < 5; i++)
			jj_la1[i] = -1;
	}

	public void ReInit(ParserTokenManager tm) {
		token_source = tm;
		token = new Token();
		jj_ntk = -1;
		jj_gen = 0;
		for (int i = 0; i < 5; i++)
			jj_la1[i] = -1;
	}

	final private Token jj_consume_token(int kind) throws ParseException {
		Token oldToken;
		if ((oldToken = token).next != null)
			token = token.next;
		else
			token = token.next = token_source.getNextToken();
		jj_ntk = -1;
		if (token.kind == kind) {
			jj_gen++;
			return token;
		}
		token = oldToken;
		jj_kind = kind;
		throw generateParseException();
	}

	final public Token getNextToken() {
		if (token.next != null)
			token = token.next;
		else
			token = token.next = token_source.getNextToken();
		jj_ntk = -1;
		jj_gen++;
		return token;
	}

	final public Token getToken(int index) {
		Token t = token;
		for (int i = 0; i < index; i++) {
			if (t.next != null)
				t = t.next;
			else
				t = t.next = token_source.getNextToken();
		}
		return t;
	}

	final private int jj_ntk() {
		if ((jj_nt = token.next) == null) {
			return (jj_ntk = (token.next = token_source.getNextToken()).kind);
		}
		return (jj_ntk = jj_nt.kind);
	}

	private java.util.Vector jj_expentries = new java.util.Vector();

	private int[] jj_expentry;

	private int jj_kind = -1;

	public ParseException generateParseException() {
		jj_expentries.removeAllElements();
		boolean[] la1tokens = new boolean[30];
		for (int i = 0; i < 30; i++) {
			la1tokens[i] = false;
		}
		if (jj_kind >= 0) {
			la1tokens[jj_kind] = true;
			jj_kind = -1;
		}
		for (int i = 0; i < 5; i++) {
			if (jj_la1[i] == jj_gen) {
				for (int j = 0; j < 32; j++) {
					if ((jj_la1_0[i] & (1 << j)) != 0) {
						la1tokens[j] = true;
					}
				}
			}
		}
		for (int i = 0; i < 30; i++) {
			if (la1tokens[i]) {
				jj_expentry = new int[1];
				jj_expentry[0] = i;
				jj_expentries.addElement(jj_expentry);
			}
		}
		int[][] exptokseq = new int[jj_expentries.size()][];
		for (int i = 0; i < jj_expentries.size(); i++) {
			exptokseq[i] = (int[]) jj_expentries.elementAt(i);
		}
		return new ParseException(token, exptokseq, tokenImage);
	}
}
