/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.woproject.ant;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.objectstyle.woproject.ant.FileUtil;

class TokenFilter {
    private Map tokens;
    private String lineEnd = System.getProperty("line.separator");

    TokenFilter(Map tokens) {
        this.tokens = new HashMap(tokens.size() * 2);
        for (Map.Entry entry : tokens.entrySet()) {
            this.tokens.put(Pattern.compile(entry.getKey().toString()), entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void copy(String fromResource, File to) throws BuildException {
        try {
            InputStream in = this.getClass().getClassLoader().getResourceAsStream(fromResource);
            if (in == null) {
                throw new IOException("Resource not found: " + fromResource);
            }
            FileUtil.ensureParentDirExists(to);
            FileWriter out = new FileWriter(to);
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                while ((line = reader.readLine()) != null) {
                    this.writeLine(out, line);
                }
            }
            finally {
                try {
                    ((Writer)out).close();
                }
                catch (IOException ioex) {}
                try {
                    in.close();
                }
                catch (IOException ioex) {}
            }
        }
        catch (IOException e) {
            throw new BuildException("Error copying resource " + fromResource, (Throwable)e);
        }
    }

    void writeLine(Writer out, String line) throws IOException {
        if (line.length() > 0) {
            StringBuffer buffer = new StringBuffer(line);
            for (Map.Entry entry : this.tokens.entrySet()) {
                Pattern token = (Pattern)entry.getKey();
                String replacement = entry.getValue().toString();
                Matcher matcher = token.matcher(buffer);
                int start = 0;
                while (matcher.find(start)) {
                    buffer.replace(matcher.start(), matcher.end(), replacement);
                    start = matcher.start() + replacement.length();
                }
            }
            out.write(buffer.toString());
        } else {
            out.write(line);
        }
        out.write(this.lineEnd);
    }
}

