/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.templateeditor;

import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.objectstyle.wolips.bindings.wod.IWodBinding;
import org.objectstyle.wolips.bindings.wod.IWodElement;
import org.objectstyle.wolips.variables.BuildProperties;
import org.objectstyle.wolips.wodclipse.core.completion.WodParserCache;
import org.objectstyle.wolips.wodclipse.core.document.WodBindingValueHyperlink;
import org.objectstyle.wolips.wodclipse.core.document.WodElementTypeHyperlink;
import org.objectstyle.wolips.wodclipse.core.util.FuzzyXMLWodElement;
import org.objectstyle.wolips.wodclipse.core.util.WodHtmlUtils;
import tk.eclipse.plugin.htmleditor.IHyperlinkProvider;
import tk.eclipse.plugin.htmleditor.editors.HTMLHyperlinkInfo;

public class InlineWodElementHyperlinkProvider
implements IHyperlinkProvider {
    @Override
    public HTMLHyperlinkInfo getHyperlinkInfo(IFile file, FuzzyXMLDocument doc, FuzzyXMLElement element, String attrName, String attrValue, int offset) {
        HTMLHyperlinkInfo hyperlinkInfo = null;
        try {
            if (WodHtmlUtils.isWOTag((String)element.getName()) && WodHtmlUtils.isInline((String)element.getName())) {
                BuildProperties buildProperties = (BuildProperties)file.getProject().getAdapter(BuildProperties.class);
                if (attrName == null) {
                    WodParserCache cache = WodParserCache.parser((IResource)file);
                    FuzzyXMLWodElement wodElement = new FuzzyXMLWodElement(element, buildProperties);
                    if (wodElement.isTypeWithin((IRegion)new Region(offset, 0))) {
                        hyperlinkInfo = new HTMLHyperlinkInfo();
                        hyperlinkInfo.setOffset(wodElement.getElementTypePosition().getOffset());
                        hyperlinkInfo.setLength(wodElement.getElementTypePosition().getLength());
                        hyperlinkInfo.setObject(WodElementTypeHyperlink.toElementTypeHyperlink((IWodElement)wodElement, (WodParserCache)cache));
                    }
                } else {
                    Position valuePosition;
                    WodParserCache cache = WodParserCache.parser((IResource)file);
                    FuzzyXMLWodElement wodElement = new FuzzyXMLWodElement(element, buildProperties);
                    IWodBinding wodBinding = wodElement.getBindingNamed(attrName);
                    if (wodBinding != null && (valuePosition = wodBinding.getValuePosition()) != null) {
                        hyperlinkInfo = new HTMLHyperlinkInfo();
                        hyperlinkInfo.setOffset(valuePosition.getOffset());
                        hyperlinkInfo.setLength(valuePosition.getLength());
                        hyperlinkInfo.setObject(WodBindingValueHyperlink.toBindingValueHyperlink((IWodElement)wodElement, (String)attrName, (WodParserCache)cache));
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hyperlinkInfo;
    }
}

