/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.csseditor.editors;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ContextInformationValidator;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import tk.eclipse.plugin.csseditor.editors.CSSDefinition;
import tk.eclipse.plugin.csseditor.editors.CSSProperty;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.HTMLUtil;

public class CSSAssistProcessor
implements IContentAssistProcessor {
    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        LinkedList<ICompletionProposal> proposals = new LinkedList<ICompletionProposal>();
        try {
            IDocument document = viewer.getDocument();
            int colonIndex = -1;
            boolean done = false;
            int state = 0;
            for (int currentOffset = offset - 1; !done && currentOffset > 0; --currentOffset) {
                char ch = document.getChar(currentOffset);
                if (ch == '}') {
                    state = 0;
                    done = true;
                    continue;
                }
                if (ch == ':') {
                    colonIndex = currentOffset;
                    state = 2;
                    done = true;
                    continue;
                }
                if (ch == ';') {
                    state = 1;
                    done = true;
                    continue;
                }
                if (ch != '{') continue;
                state = 1;
                done = true;
            }
            if (state != 0) {
                int lineOffset;
                int lineNumber;
                if (state == 1) {
                    int replacementOffset;
                    lineNumber = document.getLineOfOffset(offset);
                    lineOffset = document.getLineOffset(lineNumber);
                    String propertyName = document.get(lineOffset, offset - lineOffset);
                    for (replacementOffset = 0; replacementOffset < propertyName.length() && Character.isWhitespace(propertyName.charAt(replacementOffset)); ++replacementOffset) {
                    }
                    String trimmedPropertyName = propertyName.trim();
                    if (trimmedPropertyName.length() == 0 || !propertyName.endsWith(" ")) {
                        char lastChar = document.getChar(offset - 1);
                        String lowercasePropertyName = propertyName.trim().toLowerCase();
                        for (CSSProperty property : CSSDefinition.PROPERTIES) {
                            String displayPropertyName = property.getName();
                            String replacementPropertyName = displayPropertyName + ": ";
                            if (!displayPropertyName.startsWith(lowercasePropertyName)) continue;
                            proposals.add((ICompletionProposal)new CompletionProposal(replacementPropertyName, lineOffset + replacementOffset, trimmedPropertyName.length(), replacementPropertyName.length(), null, displayPropertyName, null, null));
                        }
                    }
                } else if (state == 2) {
                    lineNumber = document.getLineOfOffset(offset);
                    lineOffset = document.getLineOffset(lineNumber);
                    String propertyName = document.get(lineOffset, colonIndex - lineOffset).trim();
                    CSSProperty matchingProperty = null;
                    for (CSSProperty property : CSSDefinition.PROPERTIES) {
                        if (!property.getName().equalsIgnoreCase(propertyName)) continue;
                        matchingProperty = property;
                    }
                    if (matchingProperty != null) {
                        int replacementOffset;
                        String propertyValue = document.get(colonIndex + 1, offset - colonIndex - 1);
                        for (replacementOffset = 0; replacementOffset < propertyValue.length() && Character.isWhitespace(propertyValue.charAt(replacementOffset)); ++replacementOffset) {
                        }
                        String trimmedPropertyValue = propertyValue.substring(replacementOffset);
                        HashSet<String> valueProposals = new HashSet<String>();
                        matchingProperty.fillInProposals(trimmedPropertyValue, valueProposals);
                        Iterator iterator = valueProposals.iterator();
                        while (iterator.hasNext()) {
                            String valueProposal;
                            String displayValueProposal = valueProposal = (String)iterator.next();
                            String replacementValueProposal = valueProposal;
                            proposals.add((ICompletionProposal)new CompletionProposal(replacementValueProposal, colonIndex + replacementOffset + 1, trimmedPropertyValue.length(), replacementValueProposal.length(), null, displayValueProposal, null, null));
                        }
                    }
                }
            }
            HTMLUtil.sortCompilationProposal(proposals);
        }
        catch (BadLocationException e) {
            HTMLPlugin.logException(e);
        }
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }

    protected String getSource(ITextViewer viewer) {
        return viewer.getDocument().get();
    }

    private String getLastWord(String text) {
        text = HTMLUtil.cssComment2space(text);
        int index1 = text.lastIndexOf(59);
        int index2 = text.lastIndexOf(123);
        if (index1 >= 0 && index1 > index2) {
            return text.substring(index1 + 1).trim();
        }
        if (index2 >= 0) {
            return text.substring(index2 + 1).trim();
        }
        return null;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        ContextInformation[] info = new ContextInformation[]{};
        return info;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[0];
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return new char[0];
    }

    public String getErrorMessage() {
        return "error";
    }

    public IContextInformationValidator getContextInformationValidator() {
        return new ContextInformationValidator((IContentAssistProcessor)this);
    }
}

