/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.csseditor.editors;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import tk.eclipse.plugin.csseditor.editors.CSSValueType;

public class CSSCompositeValueType
extends CSSValueType {
    private List<CSSValueType> _valueTypes = new LinkedList<CSSValueType>();

    public CSSCompositeValueType(CSSValueType ... valueTypes) {
        for (CSSValueType valueType : valueTypes) {
            this._valueTypes.add(valueType);
        }
    }

    public List<CSSValueType> getValueTypes() {
        return this._valueTypes;
    }

    @Override
    public void fillInProposals(String token, Set<String> proposals) {
        String lastToken;
        String start;
        int lastSpaceIndex = token.lastIndexOf(32);
        if (lastSpaceIndex == -1) {
            start = "";
            lastToken = token;
        } else {
            start = token.substring(0, lastSpaceIndex + 1);
            lastToken = token.substring(lastSpaceIndex + 1);
        }
        String[] tokens = token.split("\\s+");
        int tokenCount = tokens.length;
        if (tokenCount < this._valueTypes.size()) {
            HashSet<String> partialProposals = new HashSet<String>();
            this._valueTypes.get(tokenCount).fillInProposals(lastToken, partialProposals);
            for (String partialProposal : partialProposals) {
                proposals.add(start + partialProposal);
            }
        }
    }
}

