/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.htmleditor.tasktag;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.objectstyle.wolips.preferences.TableViewerSupport;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.HTMLProjectBuilder;
import tk.eclipse.plugin.htmleditor.tasktag.TaskTag;

public class HTMLTaskTagPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private TableViewer _viewer;
    private List<TaskTag> _model = new ArrayList<TaskTag>();
    private List<TaskTag> _oldModel = new ArrayList<TaskTag>();

    public HTMLTaskTagPreferencePage() {
        this.setPreferenceStore(HTMLPlugin.getDefault().getPreferenceStore());
        this.setTitle(HTMLPlugin.getResourceString("HTMLEditorPreferencePage.TaskTag"));
    }

    protected Control createContents(Composite parent) {
        TableViewerSupport support = new TableViewerSupport(this._model, parent){

            protected void initTableViewer(TableViewer viewer) {
                Table table = viewer.getTable();
                TableColumn col1 = new TableColumn(table, 16384);
                col1.setText(HTMLPlugin.getResourceString("HTMLEditorPreferencePage.Tag"));
                col1.setWidth(100);
                TableColumn col2 = new TableColumn(table, 16384);
                col2.setText(HTMLPlugin.getResourceString("HTMLEditorPreferencePage.Priority"));
                col2.setWidth(100);
            }

            protected Object doAdd() {
                TaskTagDialog dialog = new TaskTagDialog(HTMLTaskTagPreferencePage.this.getShell());
                if (dialog.open() == 0) {
                    return dialog.getTaskTag();
                }
                return null;
            }

            protected void doEdit(Object obj) {
                TaskTag element = (TaskTag)obj;
                TaskTagDialog dialog = new TaskTagDialog(HTMLTaskTagPreferencePage.this.getShell(), element);
                if (dialog.open() == 0) {
                    TaskTag newElement = dialog.getTaskTag();
                    element.setTag(newElement.getTag());
                    element.setPriority(newElement.getPriority());
                }
            }

            protected ITableLabelProvider createLabelProvider() {
                return new ITableLabelProvider(){

                    public Image getColumnImage(Object element, int columnIndex) {
                        return null;
                    }

                    public String getColumnText(Object element, int columnIndex) {
                        switch (columnIndex) {
                            case 0: {
                                return ((TaskTag)element).getTag();
                            }
                            case 1: {
                                return ((TaskTag)element).getPriorityName();
                            }
                        }
                        return element.toString();
                    }

                    public void addListener(ILabelProviderListener listener) {
                    }

                    public void dispose() {
                    }

                    public boolean isLabelProperty(Object element, String property) {
                        return false;
                    }

                    public void removeListener(ILabelProviderListener listener) {
                    }
                };
            }
        };
        this._viewer = support.getTableViewer();
        this._model.addAll(TaskTag.loadFromPreference(false));
        this.syncModels();
        this._viewer.refresh();
        return support.getControl();
    }

    protected void performDefaults() {
        this._model.clear();
        this._model.addAll(TaskTag.loadFromPreference(true));
        this._viewer.refresh();
        this.processChange();
    }

    public boolean performOk() {
        TaskTag.saveToPreference(this._model);
        this.processChange();
        return true;
    }

    private void syncModels() {
        try {
            this._oldModel.clear();
            for (int i = 0; i < this._model.size(); ++i) {
                this._oldModel.add(this._model.get(i).clone());
            }
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
        }
    }

    public void init(IWorkbench workbench) {
    }

    private void processChange() {
        if (TaskTag.hasChange(this._oldModel, this._model)) {
            this.syncModels();
            try {
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                IProject[] projects = root.getProjects();
                for (int i = 0; i < projects.length; ++i) {
                    if (!projects[i].hasNature("tk.eclipse.plugin.htmleditor.HTMLProjectNature")) continue;
                    HTMLProjectBuilder.doBuild(projects[i]);
                }
            }
            catch (Exception ex) {
                HTMLPlugin.logException(ex);
            }
        }
    }

    private class TaskTagDialog
    extends Dialog {
        private Text textTag;
        private Combo comboPriority;
        private TaskTag element;

        public TaskTagDialog(Shell parentShell) {
            super(parentShell);
            this.setShellStyle(this.getShellStyle() | 0x10);
        }

        public TaskTagDialog(Shell parentShell, TaskTag element) {
            super(parentShell);
            this.element = element;
        }

        protected Point getInitialSize() {
            Point size = super.getInitialSize();
            size.x = 300;
            return size;
        }

        protected Control createDialogArea(Composite parent) {
            this.getShell().setText(HTMLPlugin.getResourceString("HTMLEditorPreferencePage.TaskTag"));
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)new GridData(1808));
            composite.setLayout((Layout)new GridLayout(2, false));
            Label label = new Label(composite, 0);
            label.setText(HTMLPlugin.getResourceString("HTMLEditorPreferencePage.Dialog.Tag"));
            this.textTag = new Text(composite, 2048);
            if (this.element != null) {
                this.textTag.setText(this.element.getTag());
            }
            this.textTag.setLayoutData((Object)new GridData(768));
            label = new Label(composite, 0);
            label.setText(HTMLPlugin.getResourceString("HTMLEditorPreferencePage.Dialog.Priority"));
            this.comboPriority = new Combo(composite, 8);
            this.comboPriority.setLayoutData((Object)new GridData(768));
            for (int i = 0; i < TaskTag.PRIORITIES.length; ++i) {
                this.comboPriority.add(TaskTag.PRIORITIES[i]);
            }
            if (this.element != null) {
                this.comboPriority.setText(this.element.getPriorityName());
            } else {
                this.comboPriority.setText("Normal");
            }
            return composite;
        }

        protected void okPressed() {
            if (this.textTag.getText().length() == 0) {
                HTMLPlugin.openAlertDialog(HTMLPlugin.createMessage(HTMLPlugin.getResourceString("Error.Required"), new String[]{HTMLPlugin.getResourceString("HTMLEditorPreferencePage.Tag")}));
                return;
            }
            this.element = new TaskTag(this.textTag.getText(), TaskTag.convertPriority(this.comboPriority.getText()));
            super.okPressed();
        }

        public TaskTag getTaskTag() {
            return this.element;
        }
    }
}

