/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jspeditor.editors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.aonir.fuzzyxml.FuzzyXMLAttribute;
import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.FuzzyXMLParser;
import jp.aonir.fuzzyxml.XPath;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.HTMLProjectParams;
import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.jspeditor.editors.TLDInfo;

public class JSPInfo {
    private static Map<IFile, JSPInfoCache> _jspInfoMap = new HashMap<IFile, JSPInfoCache>();
    private ArrayList<TLDInfo> _tldInfoList = new ArrayList();
    private FuzzyXMLDocument _doc;
    private Pattern _taglibPattern = Pattern.compile("<%@\\s*taglib\\s+(.+?)%>", 32);
    private Pattern _uriPattern = Pattern.compile("uri\\s*=\\s*\"(.+?)\"");
    private Pattern _tagdirPattern = Pattern.compile("tagdir\\s*=\\s*\"(.+?)\"");
    private Pattern _prefixPattern = Pattern.compile("prefix\\s*=\\s*\"(.+?)\"");
    private Pattern _includePattern = Pattern.compile("<%@\\s*include\\s+(.+?)%>", 32);
    private Pattern _filePattern = Pattern.compile("file\\s*=\\s*\"(.+?)\"");

    public static JSPInfo getJSPInfo(IFile file, String source) {
        JSPInfoCache cache = _jspInfoMap.get(file);
        if (cache != null && file.getLocalTimeStamp() == cache.timestamp) {
            return cache.jspInfo;
        }
        JSPInfo info = new JSPInfo(file, source);
        cache = new JSPInfoCache();
        cache.jspInfo = info;
        cache.timestamp = file.getLocalTimeStamp();
        _jspInfoMap.put(file, cache);
        return info;
    }

    private JSPInfo(IFile file, String source) {
        this(file, source, true);
    }

    public FuzzyXMLDocument getDocument() {
        return this._doc;
    }

    private JSPInfo(IFile file, String source, boolean include) {
        try {
            Object info;
            String content;
            HTMLProjectParams params = new HTMLProjectParams(file.getProject());
            String webapproot = params.getRoot();
            IProject basedir = file.getProject();
            if (!webapproot.equals("") && !webapproot.equals("/")) {
                basedir = basedir.getFolder((IPath)new Path(webapproot));
            }
            Matcher matcher = this._includePattern.matcher(source);
            while (matcher.find()) {
                content = matcher.group(1);
                String fileInc = this.getAttribute(content, this._filePattern);
                if (fileInc == null) continue;
                IFile incJspFile = null;
                incJspFile = fileInc.startsWith("/") ? basedir.getFile((IPath)new Path(fileInc)) : file.getParent().getFile((IPath)new Path(fileInc));
                try {
                    if (incJspFile == null || !incJspFile.exists()) continue;
                    String contents = new String(HTMLUtil.readStream(incJspFile.getContents()));
                    info = new JSPInfo(incJspFile, contents);
                    TLDInfo[] tldInfos = ((JSPInfo)info).getTLDInfo();
                    for (int i = 0; i < tldInfos.length; ++i) {
                        this._tldInfoList.add(tldInfos[i]);
                    }
                }
                catch (IOException ioe) {
                    HTMLPlugin.logException(ioe);
                }
                catch (CoreException ce) {
                    HTMLPlugin.logException(ce);
                }
            }
            matcher = this._taglibPattern.matcher(source);
            while (matcher.find()) {
                content = matcher.group(1);
                String tagdir = this.getAttribute(content, this._tagdirPattern);
                if (tagdir != null) {
                    String prefix = this.getAttribute(content, this._prefixPattern);
                    TLDInfo info2 = TLDInfo.getTLDInfoFromTagdir(file, prefix, tagdir);
                    if (info2 == null) continue;
                    this._tldInfoList.add(info2);
                    continue;
                }
                String uri = this.getAttribute(content, this._uriPattern);
                String prefix = this.getAttribute(content, this._prefixPattern);
                info = TLDInfo.getTLDInfo(file, prefix, uri);
                if (info == null) continue;
                this._tldInfoList.add((TLDInfo)info);
            }
            try {
                this._doc = new FuzzyXMLParser(false).parse(HTMLUtil.scriptlet2space(source, false));
                FuzzyXMLElement root = (FuzzyXMLElement)XPath.selectSingleNode(this._doc.getDocumentElement(), "*");
                if (root != null) {
                    FuzzyXMLAttribute[] attrs = root.getAttributes();
                    for (int i = 0; i < attrs.length; ++i) {
                        String[] dim;
                        if (!attrs[i].getName().startsWith("xmlns:") || (dim = attrs[i].getName().split(":")).length <= 1) continue;
                        info = null;
                        String value = attrs[i].getValue();
                        if (value.startsWith("urn:jsptagdir:")) {
                            value = value.replaceFirst("^urn:jsptagdir:", "");
                            info = TLDInfo.getTLDInfoFromTagdir(file, dim[1], value);
                        } else if (value.startsWith("urn:jsptld:")) {
                            value = value.replaceFirst("^urn:jsptld:", "");
                            info = TLDInfo.getTLDInfo(file, dim[1], value);
                        } else {
                            info = TLDInfo.getTLDInfo(file, dim[1], value);
                        }
                        if (info == null) continue;
                        this._tldInfoList.add((TLDInfo)info);
                    }
                }
            }
            catch (Exception ex) {
                HTMLPlugin.logException(ex);
            }
            try {
                if (include) {
                    IPath path = new Path(webapproot).append("/WEB-INF/web.xml");
                    IFile webXML = file.getProject().getFile(path);
                    if (webXML != null && webXML.exists()) {
                        FuzzyXMLDocument doc = new FuzzyXMLParser(false).parse(webXML.getContents());
                        FuzzyXMLNode[] nodes = HTMLUtil.selectXPathNodes(doc.getDocumentElement(), "/web-app/jsp-config/jsp-property-group[url-pattern='*.jsp']");
                        for (int i = 0; i < nodes.length; ++i) {
                            FuzzyXMLNode[] includes = HTMLUtil.selectXPathNodes((FuzzyXMLElement)nodes[i], "/include-prelude|/include-coda");
                            for (int j = 0; j < includes.length; ++j) {
                                IFile incFile = basedir.getFile((IPath)new Path(((FuzzyXMLElement)includes[j]).getValue()));
                                if (incFile == null || !incFile.exists()) continue;
                                String contents = new String(HTMLUtil.readStream(incFile.getContents()));
                                JSPInfo info3 = new JSPInfo(incFile, contents, false);
                                TLDInfo[] tldInfos = info3.getTLDInfo();
                                for (int k = 0; k < tldInfos.length; ++k) {
                                    this._tldInfoList.add(tldInfos[k]);
                                }
                            }
                        }
                    }
                }
            }
            catch (Exception ex) {
                HTMLPlugin.logException(ex);
            }
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
        }
    }

    private String getAttribute(String source, Pattern pattern) {
        Matcher matcher = pattern.matcher(source);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public String getTaglibUri(String prefix) {
        String uri = null;
        TLDInfo[] tlds = this.getTLDInfo();
        for (int i = 0; i < tlds.length; ++i) {
            if (!tlds[i].getPrefix().equals(prefix)) continue;
            uri = tlds[i].getTaglibUri();
            break;
        }
        return uri;
    }

    public TLDInfo[] getTLDInfo() {
        return this._tldInfoList.toArray(new TLDInfo[this._tldInfoList.size()]);
    }

    private static class JSPInfoCache {
        private JSPInfo jspInfo;
        private long timestamp;

        private JSPInfoCache() {
        }
    }
}

