/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.core.sql;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.objectstyle.wolips.eomodeler.core.sql.EOFSQLUtils53;
import org.objectstyle.wolips.eomodeler.core.sql.IEOSQLGenerator;

public class EOFSQLGenerator53
implements IEOSQLGenerator {
    private Object _entities;
    private Object _model;
    private Object _modelGroup;
    private Object _modelProcessor;

    public EOFSQLGenerator53(String modelName, List modelURLs, List entityNames, Map selectedDatabaseConfig, boolean runInEntityModeler) {
        try {
            this.init(modelName, modelURLs, entityNames, selectedDatabaseConfig, runInEntityModeler);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private void init(String modelName, List modelURLs, List entityNames, Map selectedDatabaseConfig, boolean runInEntityModeler) throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object connectionDictionary;
        Object entity;
        Object defaultConnectionDictionary;
        this.fixClassPath();
        Class<?> eomodelgroup = Class.forName("com.webobjects.eoaccess.EOModelGroup");
        Class<?> eomodel = Class.forName("com.webobjects.eoaccess.EOModel");
        Class<?> nsarray = Class.forName("com.webobjects.foundation.NSArray");
        Class<?> nsdictionary = Class.forName("com.webobjects.foundation.NSDictionary");
        Class<?> nsmutarray = Class.forName("com.webobjects.foundation.NSMutableArray");
        Class<?> nsmutdictionary = Class.forName("com.webobjects.foundation.NSMutableDictionary");
        HashMap databaseConfig = selectedDatabaseConfig;
        if (databaseConfig == null) {
            databaseConfig = new HashMap();
        }
        this._modelGroup = eomodelgroup.getConstructor(new Class[0]).newInstance(new Object[0]);
        for (URL modelURL : modelURLs) {
            eomodelgroup.getMethod("addModelWithPathURL", URL.class).invoke(this._modelGroup, modelURL);
        }
        String prototypeEntityName = (String)databaseConfig.get("prototypeEntityName");
        if (prototypeEntityName != null) {
            this.replacePrototypes(this._modelGroup, prototypeEntityName);
        }
        this._entities = nsmutarray.getConstructor(new Class[0]).newInstance(new Object[0]);
        this._model = eomodelgroup.getMethod("modelNamed", String.class).invoke(this._modelGroup, modelName);
        Map overrideConnectionDictionary = (Map)databaseConfig.get("connectionDictionary");
        if (overrideConnectionDictionary != null) {
            Object connectionDictionary2 = EOFSQLUtils53.toWOCollections(overrideConnectionDictionary);
            eomodel.getMethod("setConnectionDictionary", nsdictionary).invoke(this._model, connectionDictionary2);
            String eomodelProcessorClassName = (String)nsdictionary.getMethod("valueForKey", String.class).invoke(connectionDictionary2, "eomodelProcessorClassName");
            if (eomodelProcessorClassName != null) {
                this.findModelProcessor(eomodelProcessorClassName, true);
            }
            defaultConnectionDictionary = connectionDictionary2;
        } else {
            defaultConnectionDictionary = eomodel.getMethod("connectionDictionary", new Class[0]).invoke(this._model, new Object[0]);
        }
        Object modelsarr = eomodelgroup.getMethod("models", new Class[0]).invoke(this._modelGroup, new Object[0]);
        Enumeration modelsEnum = (Enumeration)nsarray.getMethod("objectEnumerator", new Class[0]).invoke(modelsarr, new Object[0]);
        while (modelsEnum.hasMoreElements()) {
            Object model = modelsEnum.nextElement();
            if (eomodel.getMethod("connectionDictionary", new Class[0]).invoke(model, new Object[0]) != null) continue;
            eomodel.getMethod("setConnectionDictionary", nsdictionary).invoke(model, defaultConnectionDictionary);
        }
        if (this._modelProcessor == null) {
            this.findModelProcessor("org.objectstyle.wolips.eomodeler.EOModelProcessor", false);
        }
        if (entityNames == null || entityNames.size() == 0) {
            Object entitiesarr = eomodel.getMethod("entities", new Class[0]).invoke(this._model, new Object[0]);
            Enumeration entitiesEnum = (Enumeration)nsarray.getMethod("objectEnumerator", new Class[0]).invoke(entitiesarr, new Object[0]);
            while (entitiesEnum.hasMoreElements()) {
                entity = entitiesEnum.nextElement();
                if (this.isPrototype(entity)) continue;
                nsmutarray.getMethod("addObject", Object.class).invoke(this._entities, entity);
            }
        } else {
            for (String entityName : entityNames) {
                entity = eomodel.getMethod("entityNamed", String.class).invoke(this._model, entityName);
                if (entity == null) continue;
                nsmutarray.getMethod("addObject", Object.class).invoke(this._entities, entity);
            }
        }
        if ((connectionDictionary = eomodel.getMethod("connectionDictionary", new Class[0]).invoke(this._model, new Object[0])) != null) {
            Object mutableConnectionDictionary = nsdictionary.getMethod("mutableClone", new Class[0]).invoke(connectionDictionary, new Object[0]);
            nsmutdictionary.getMethod("removeObjectForKey", Object.class).invoke(mutableConnectionDictionary, "jdbc2Info");
            eomodel.getMethod("setConnectionDictionary", nsdictionary).invoke(this._model, mutableConnectionDictionary);
        }
        if (runInEntityModeler) {
            Object infodict = eomodel.getMethod("userInfo", new Class[0]).invoke(this._model, new Object[0]);
            Object modelUserInfo = nsdictionary.getMethod("mutableClone", new Class[0]).invoke(infodict, new Object[0]);
            Object entityModelerDict = nsmutdictionary.getMethod("valueForKey", String.class).invoke(modelUserInfo, "_EntityModeler");
            Object mutableEntityModelerDict = entityModelerDict == null ? nsmutdictionary.getConstructor(new Class[0]).newInstance(new Object[0]) : nsdictionary.getMethod("mutableClone", new Class[0]).invoke(entityModelerDict, new Object[0]);
            nsmutdictionary.getMethod("takeValueForKey", Object.class, String.class).invoke(mutableEntityModelerDict, Boolean.TRUE, "inEntityModeler");
            nsmutdictionary.getMethod("takeValueForKey", Object.class, String.class).invoke(modelUserInfo, mutableEntityModelerDict, "_EntityModeler");
            eomodel.getMethod("setUserInfo", nsdictionary).invoke(this._model, modelUserInfo);
        }
        this.ensureSingleTableInheritanceParentEntitiesAreIncluded();
        this.ensureSingleTableInheritanceChildEntitiesAreIncluded();
        this.fixAllowsNullOnSingleTableInheritance();
        this.localizeEntities();
    }

    protected void replacePrototypes(Object modelGroup, String prototypeEntityName) {
        try {
            this.replacePrototypesReflect(modelGroup, prototypeEntityName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    private void replacePrototypesReflect(Object modelGroup, String prototypeEntityName) throws ClassNotFoundException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, InstantiationException {
        Object prototypesEntity;
        Class<?> eomodelgroup = Class.forName("com.webobjects.eoaccess.EOModelGroup");
        Class<?> eomodel = Class.forName("com.webobjects.eoaccess.EOModel");
        Class<?> eoentity = Class.forName("com.webobjects.eoaccess.EOEntity");
        Class<?> nsarray = Class.forName("com.webobjects.foundation.NSArray");
        Class<?> nsmutdictionary = Class.forName("com.webobjects.foundation.NSMutableDictionary");
        String replacementPrototypeName = "EOPrototypes";
        if (eomodelgroup.getMethod("entityNamed", String.class).invoke(modelGroup, prototypeEntityName) == null) {
            return;
        }
        if (replacementPrototypeName.equals(prototypeEntityName)) {
            return;
        }
        Object removedPrototypeEntities = nsmutdictionary.getConstructor(new Class[0]).newInstance(new Object[0]);
        Object prototypesModel = null;
        Object modelsarr = eomodelgroup.getMethod("models", new Class[0]).invoke(this._modelGroup, new Object[0]);
        Enumeration modelsEnum = (Enumeration)nsarray.getMethod("objectEnumerator", new Class[0]).invoke(modelsarr, new Object[0]);
        while (modelsEnum.hasMoreElements()) {
            Object model = modelsEnum.nextElement();
            String adaptorName = (String)eomodel.getMethod("adaptorName", new Class[0]).invoke(model, new Object[0]);
            Object eoAdaptorPrototypesEntity = eomodelgroup.getMethod("entityNamed", String.class).invoke(this._modelGroup, "EO" + adaptorName + "Prototypes");
            if (eoAdaptorPrototypesEntity == null) continue;
            prototypesModel = eoentity.getMethod("model", new Class[0]).invoke(eoAdaptorPrototypesEntity, new Object[0]);
            eomodel.getMethod("removeEntity", eoentity).invoke(prototypesModel, eoAdaptorPrototypesEntity);
            String entityName = (String)eoentity.getMethod("name", new Class[0]).invoke(eoAdaptorPrototypesEntity, new Object[0]);
            nsmutdictionary.getMethod("takeValueForKey", Object.class, String.class).invoke(removedPrototypeEntities, eoAdaptorPrototypesEntity, entityName);
        }
        Object eoPrototypesEntity = eomodelgroup.getMethod("entityNamed", String.class).invoke(this._modelGroup, replacementPrototypeName);
        if (eoPrototypesEntity != null) {
            prototypesModel = eoentity.getMethod("model", new Class[0]).invoke(eoPrototypesEntity, new Object[0]);
            eomodel.getMethod("removeEntity", eoentity).invoke(prototypesModel, eoPrototypesEntity);
            nsmutdictionary.getMethod("takeValueForKey", Object.class, String.class).invoke(removedPrototypeEntities, eoPrototypesEntity, replacementPrototypeName);
        }
        if ((prototypesEntity = eomodelgroup.getMethod("entityNamed", String.class).invoke(this._modelGroup, prototypeEntityName)) == null) {
            prototypesEntity = nsmutdictionary.getMethod("valueForKey", String.class).invoke(removedPrototypeEntities, prototypeEntityName);
        } else {
            prototypesModel = eoentity.getMethod("model", new Class[0]).invoke(prototypesEntity, new Object[0]);
            eomodel.getMethod("removeEntity", eoentity).invoke(prototypesModel, prototypesEntity);
        }
        if (prototypesEntity != null && prototypesModel != null) {
            eoentity.getMethod("setName", String.class).invoke(prototypesEntity, replacementPrototypeName);
            eomodel.getMethod("addEntity", eoentity).invoke(prototypesModel, prototypesEntity);
        }
        modelsarr = eomodelgroup.getMethod("models", new Class[0]).invoke(this._modelGroup, new Object[0]);
        Enumeration resetModelsEnum = (Enumeration)nsarray.getMethod("objectEnumerator", new Class[0]).invoke(modelsarr, new Object[0]);
        while (resetModelsEnum.hasMoreElements()) {
            Object model = resetModelsEnum.nextElement();
            eomodel.getMethod("_resetPrototypeCache", new Class[0]).invoke(model, new Object[0]);
        }
    }

    protected void localizeEntities() {
        try {
            this.localizeEntitiesReflect();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private void localizeEntitiesReflect() throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Class<?> nsarray = Class.forName("com.webobjects.foundation.NSArray");
        Object entities = nsarray.getConstructor(nsarray).newInstance(this._entities);
        Enumeration entitiesEnum = (Enumeration)nsarray.getMethod("objectEnumerator", new Class[0]).invoke(entities, new Object[0]);
        while (entitiesEnum.hasMoreElements()) {
            Object entity = entitiesEnum.nextElement();
            this.createLocalizedAttributes(entity);
        }
    }

    protected void fixAllowsNullOnSingleTableInheritance() {
        try {
            this.fixAllowsNullOnSingleTableInheritanceReflect();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private void fixAllowsNullOnSingleTableInheritanceReflect() throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Class<?> eoentity = Class.forName("com.webobjects.eoaccess.EOEntity");
        Class<?> nsarray = Class.forName("com.webobjects.foundation.NSArray");
        Class<?> eoattribute = Class.forName("com.webobjects.eoaccess.EOAttribute");
        Object entities = nsarray.getConstructor(nsarray).newInstance(this._entities);
        Enumeration entitiesEnum = (Enumeration)nsarray.getMethod("objectEnumerator", new Class[0]).invoke(entities, new Object[0]);
        while (entitiesEnum.hasMoreElements()) {
            Object entity = entitiesEnum.nextElement();
            if (!this.isSingleTableInheritance(entity)) continue;
            Object attributesarr = eoentity.getMethod("attributes", new Class[0]).invoke(entity, new Object[0]);
            Enumeration attributeEnum = (Enumeration)nsarray.getMethod("objectEnumerator", new Class[0]).invoke(attributesarr, new Object[0]);
            while (attributeEnum.hasMoreElements()) {
                Object attribute = attributeEnum.nextElement();
                if (this.isInherited(attribute)) continue;
                eoattribute.getMethod("setAllowsNull", Boolean.class).invoke(attribute, Boolean.TRUE);
            }
        }
    }

    protected void ensureSingleTableInheritanceParentEntitiesAreIncluded() {
        try {
            this.ensureSingleTableInheritanceParentEntitiesAreIncludedReflect();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private void ensureSingleTableInheritanceParentEntitiesAreIncludedReflect() throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Class<?> nsarray = Class.forName("com.webobjects.foundation.NSArray");
        Object entities = nsarray.getConstructor(nsarray).newInstance(this._entities);
        Enumeration entitiesEnum = (Enumeration)nsarray.getMethod("objectEnumerator", new Class[0]).invoke(entities, new Object[0]);
        while (entitiesEnum.hasMoreElements()) {
            Object entity = entitiesEnum.nextElement();
            this.ensureSingleTableInheritanceParentEntitiesAreIncluded(entity);
        }
    }

    protected void ensureSingleTableInheritanceChildEntitiesAreIncluded() {
        try {
            this.ensureSingleTableInheritanceChildEntitiesAreIncludedReflect();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private void ensureSingleTableInheritanceChildEntitiesAreIncludedReflect() throws ClassNotFoundException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Class<?> eomodel = Class.forName("com.webobjects.eoaccess.EOModel");
        Class<?> eoentity = Class.forName("com.webobjects.eoaccess.EOEntity");
        Class<?> nsarray = Class.forName("com.webobjects.foundation.NSArray");
        Class<?> nsmutarray = Class.forName("com.webobjects.foundation.NSMutableArray");
        Object entitiesarr = eomodel.getMethod("entities", new Class[0]).invoke(this._model, new Object[0]);
        Enumeration entitiesEnum = (Enumeration)nsarray.getMethod("objectEnumerator", new Class[0]).invoke(entitiesarr, new Object[0]);
        while (entitiesEnum.hasMoreElements()) {
            Object entity = entitiesEnum.nextElement();
            if (!this.isSingleTableInheritance(entity)) continue;
            Object parentEntity = eoentity.getMethod("parentEntity", new Class[0]).invoke(entity, new Object[0]);
            Boolean containsParent = (Boolean)nsmutarray.getMethod("containsObject", Object.class).invoke(this._entities, parentEntity);
            Boolean containsEntity = (Boolean)nsmutarray.getMethod("containsObject", Object.class).invoke(this._entities, entity);
            if (!containsParent.booleanValue() || containsEntity.booleanValue()) continue;
            nsmutarray.getMethod("addObject", Object.class).invoke(this._entities, entity);
        }
    }

    protected void ensureSingleTableInheritanceParentEntitiesAreIncluded(Object entity) {
        try {
            this.ensureSingleTableInheritanceParentEntitiesAreIncludedReflect(entity);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private void ensureSingleTableInheritanceParentEntitiesAreIncludedReflect(Object entity) throws ClassNotFoundException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Class<?> eoentity = Class.forName("com.webobjects.eoaccess.EOEntity");
        Class<?> nsmutarray = Class.forName("com.webobjects.foundation.NSMutableArray");
        if (this.isSingleTableInheritance(entity)) {
            Object parentEntity = eoentity.getMethod("parentEntity", new Class[0]).invoke(entity, new Object[0]);
            Boolean containsParent = (Boolean)nsmutarray.getMethod("containsObject", Object.class).invoke(this._entities, parentEntity);
            if (!containsParent.booleanValue()) {
                nsmutarray.getMethod("addObject", Object.class).invoke(this._entities, parentEntity);
                this.ensureSingleTableInheritanceParentEntitiesAreIncluded(entity);
            }
        }
    }

    protected boolean isPrototype(Object _entity) throws ClassNotFoundException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        Class<?> eoentity = Class.forName("com.webobjects.eoaccess.EOEntity");
        String entityName = (String)eoentity.getMethod("name", new Class[0]).invoke(_entity, new Object[0]);
        boolean isPrototype = entityName.startsWith("EO") && entityName.endsWith("Prototypes");
        return isPrototype;
    }

    protected boolean isSingleTableInheritance(Object entity) {
        try {
            return this.isSingleTableInheritanceReflect(entity);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isSingleTableInheritanceReflect(Object entity) throws ClassNotFoundException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Class<?> eoentity = Class.forName("com.webobjects.eoaccess.EOEntity");
        Object parentEntity = eoentity.getMethod("parentEntity", new Class[0]).invoke(entity, new Object[0]);
        String entityExternalName = (String)eoentity.getMethod("externalName", new Class[0]).invoke(entity, new Object[0]);
        String parentEntityExternalName = (String)eoentity.getMethod("externalName", new Class[0]).invoke(parentEntity, new Object[0]);
        return parentEntity != null && entityExternalName != null && entityExternalName.equalsIgnoreCase(parentEntityExternalName);
    }

    protected void createLocalizedAttributes(Object entity) {
        try {
            this.createLocalizedAttributesReflect(entity);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    private void createLocalizedAttributesReflect(Object entity) throws ClassNotFoundException, IllegalAccessException, NoSuchFieldException, InvocationTargetException, NoSuchMethodException, InstantiationException {
        Class<?> eoentity = Class.forName("com.webobjects.eoaccess.EOEntity");
        Class<?> eomodel = Class.forName("com.webobjects.eoaccess.EOModel");
        Class<?> eoattribute = Class.forName("com.webobjects.eoaccess.EOAttribute");
        Class<?> nsarray = Class.forName("com.webobjects.foundation.NSArray");
        Class<?> nsdictionary = Class.forName("com.webobjects.foundation.NSDictionary");
        Class<?> nsmutarray = Class.forName("com.webobjects.foundation.NSMutableArray");
        Object emptyarr = nsarray.getField("EmptyArray").get(null);
        Object attributes = nsarray.getMethod("immutableClone", new Class[0]).invoke(eoentity.getMethod("attributes", new Class[0]).invoke(entity, new Object[0]), new Object[0]);
        Object classProperties = nsarray.getMethod("immutableClone", new Class[0]).invoke(eoentity.getMethod("classProperties", new Class[0]).invoke(entity, new Object[0]), new Object[0]);
        Object attributesUsedForLocking = nsarray.getMethod("immutableClone", new Class[0]).invoke(eoentity.getMethod("attributesUsedForLocking", new Class[0]).invoke(entity, new Object[0]), new Object[0]);
        if (attributes == null) {
            attributes = emptyarr;
        }
        if (classProperties == null) {
            classProperties = emptyarr;
        }
        if (attributesUsedForLocking == null) {
            attributesUsedForLocking = emptyarr;
        }
        Object mutableClassProperties = nsarray.getMethod("mutableClone", new Class[0]).invoke(classProperties, new Object[0]);
        Object mutableAttributesUsedForLocking = nsarray.getMethod("mutableClone", new Class[0]).invoke(attributesUsedForLocking, new Object[0]);
        Enumeration e = (Enumeration)nsarray.getMethod("objectEnumerator", new Class[0]).invoke(attributes, new Object[0]);
        while (e.hasMoreElements()) {
            Object attribute = e.nextElement();
            Object userInfo = eoattribute.getMethod("userInfo", new Class[0]).invoke(attribute, new Object[0]);
            String name = (String)eoattribute.getMethod("name", new Class[0]).invoke(attribute, new Object[0]);
            if (userInfo != null) {
                Object l = nsdictionary.getMethod("valueForKey", String.class).invoke(userInfo, "ERXLanguages");
                if (l != null && !nsarray.isInstance(l)) {
                    Object modelUserInfo = eomodel.getMethod("userInfo", new Class[0]).invoke(eoentity.getMethod("model", new Class[0]).invoke(entity, new Object[0]), new Object[0]);
                    Object object = l = modelUserInfo != null ? nsdictionary.getMethod("valueForKey", String.class).invoke(modelUserInfo, "ERXLanguages") : null;
                }
                if (l != null && (Integer)nsarray.getMethod("count", new Class[0]).invoke(l, new Object[0]) > 0) {
                    List languages = (List)EOFSQLUtils53.toJavaCollections(l);
                    String columnName = (String)eoattribute.getMethod("columnName", new Class[0]).invoke(attribute, new Object[0]);
                    for (int i = 0; i < languages.size(); ++i) {
                        String language = (String)languages.get(i);
                        String newName = name + "_" + language;
                        String newColumnName = columnName + "_" + language;
                        Object newAttribute = eoattribute.getConstructor(new Class[0]).newInstance(new Object[0]);
                        eoattribute.getMethod("setName", String.class).invoke(newAttribute, newName);
                        eoentity.getMethod("addAttribute", eoattribute).invoke(entity, newAttribute);
                        eoattribute.getMethod("setPrototype", eoattribute).invoke(newAttribute, eoattribute.getMethod("prototype", new Class[0]).invoke(attribute, new Object[0]));
                        eoattribute.getMethod("setColumnName", String.class).invoke(newAttribute, newColumnName);
                        eoattribute.getMethod("setAllowsNull", Boolean.class).invoke(newAttribute, eoattribute.getMethod("allowsNull", new Class[0]).invoke(attribute, new Object[0]));
                        eoattribute.getMethod("setClassName", String.class).invoke(newAttribute, eoattribute.getMethod("className", new Class[0]).invoke(attribute, new Object[0]));
                        eoattribute.getMethod("setExternalType", String.class).invoke(newAttribute, eoattribute.getMethod("externalType", new Class[0]).invoke(attribute, new Object[0]));
                        eoattribute.getMethod("setWidth", Integer.class).invoke(newAttribute, eoattribute.getMethod("width", new Class[0]).invoke(attribute, new Object[0]));
                        eoattribute.getMethod("setUserInfo", nsdictionary).invoke(newAttribute, eoattribute.getMethod("userInfo", new Class[0]).invoke(attribute, new Object[0]));
                        if (((Boolean)nsarray.getMethod("containsObject", Object.class).invoke(classProperties, attribute)).booleanValue()) {
                            nsmutarray.getMethod("addObject", Object.class).invoke(mutableClassProperties, newAttribute);
                        }
                        if (!((Boolean)nsarray.getMethod("containsObject", Object.class).invoke(attributesUsedForLocking, attribute)).booleanValue()) continue;
                        nsmutarray.getMethod("addObject", Object.class).invoke(mutableAttributesUsedForLocking, newAttribute);
                    }
                    eoentity.getMethod("removeAttribute", eoattribute).invoke(entity, attribute);
                    nsmutarray.getMethod("removeObject", Object.class).invoke(mutableClassProperties, attribute);
                    nsmutarray.getMethod("removeObject", Object.class).invoke(mutableAttributesUsedForLocking, attribute);
                }
            }
            eoentity.getMethod("setClassProperties", nsarray).invoke(entity, mutableClassProperties);
            eoentity.getMethod("setAttributesUsedForLocking", nsarray).invoke(entity, mutableAttributesUsedForLocking);
        }
    }

    protected boolean isInherited(Object attribute) {
        try {
            return this.isInheritedReflect(attribute);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isInheritedReflect(Object attribute) throws ClassNotFoundException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Class<?> eoattribute = Class.forName("com.webobjects.eoaccess.EOAttribute");
        Class<?> eoentity = Class.forName("com.webobjects.eoaccess.EOEntity");
        boolean inherited = false;
        Object entity = eoattribute.getMethod("entity", new Class[0]).invoke(attribute, new Object[0]);
        Object parentEntity = eoentity.getMethod("parentEntity", new Class[0]).invoke(entity, new Object[0]);
        String attributeName = (String)eoattribute.getMethod("name", new Class[0]).invoke(attribute, new Object[0]);
        while (!inherited && parentEntity != null) {
            inherited = eoentity.getMethod("attributeNamed", String.class).invoke(parentEntity, attributeName) != null;
            parentEntity = eoentity.getMethod("parentEntity", new Class[0]).invoke(parentEntity, new Object[0]);
        }
        return inherited;
    }

    protected void fixDuplicateSingleTableInheritanceDropStatements(Object syncFactory, Object flags, StringBuffer sqlBuffer) {
        try {
            this.fixDuplicateSingleTableInheritanceDropStatementsReflect(syncFactory, flags, sqlBuffer);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    private void fixDuplicateSingleTableInheritanceDropStatementsReflect(Object syncFactory, Object flags, StringBuffer sqlBuffer) throws ClassNotFoundException, IllegalAccessException, NoSuchFieldException, InvocationTargetException, NoSuchMethodException, InstantiationException {
        Class<?> eoschemageneration = Class.forName("com.webobjects.eoaccess.EOSchemaGeneration");
        Class<?> eosynchronizationfactory = Class.forName("com.webobjects.eoaccess.EOSynchronizationFactory");
        Class<?> nsarray = Class.forName("com.webobjects.foundation.NSArray");
        Class<?> nsdictionary = Class.forName("com.webobjects.foundation.NSDictionary");
        Class<?> nsmutarray = Class.forName("com.webobjects.foundation.NSMutableArray");
        Class<?> nsmutdictionary = Class.forName("com.webobjects.foundation.NSMutableDictionary");
        String DropTablesKey = (String)eoschemageneration.getField("DropTablesKey").get(null);
        Object flag = nsmutdictionary.getMethod("valueForKey", String.class).invoke(flags, DropTablesKey);
        if ("YES".equals(flag)) {
            int entitiesCount;
            Object dropEntities = nsmutarray.getConstructor(nsarray).newInstance(this._entities);
            int count = (Integer)nsmutarray.getMethod("count", new Class[0]).invoke(dropEntities, new Object[0]);
            for (int entityNum = count - 1; entityNum >= 0; --entityNum) {
                Object entity = nsmutarray.getMethod("objectAtIndex", Integer.class).invoke(dropEntities, entityNum);
                if (!this.isSingleTableInheritance(entity)) continue;
                nsmutarray.getMethod("removeObjectAtIndex", Integer.class).invoke(dropEntities, entityNum);
            }
            int dropCount = (Integer)nsmutarray.getMethod("count", new Class[0]).invoke(dropEntities, new Object[0]);
            if (dropCount != (entitiesCount = ((Integer)nsmutarray.getMethod("count", new Class[0]).invoke(this._entities, new Object[0])).intValue())) {
                Object dropFlags = nsmutdictionary.getConstructor(new Class[0]).newInstance(new Object[0]);
                nsmutdictionary.getMethod("takeValueForKey", Object.class, String.class).invoke(dropFlags, "YES", DropTablesKey);
                String DropPrimaryKeySupportKey = (String)eoschemageneration.getField("DropPrimaryKeySupportKey").get(null);
                nsmutdictionary.getMethod("takeValueForKey", Object.class, String.class).invoke(dropFlags, "NO", DropPrimaryKeySupportKey);
                String CreateTablesKey = (String)eoschemageneration.getField("CreateTablesKey").get(null);
                nsmutdictionary.getMethod("takeValueForKey", Object.class, String.class).invoke(dropFlags, "NO", CreateTablesKey);
                String CreatePrimaryKeySupportKey = (String)eoschemageneration.getField("CreatePrimaryKeySupportKey").get(null);
                nsmutdictionary.getMethod("takeValueForKey", Object.class, String.class).invoke(dropFlags, "NO", CreatePrimaryKeySupportKey);
                String PrimaryKeyConstraintsKey = (String)eoschemageneration.getField("PrimaryKeyConstraintsKey").get(null);
                nsmutdictionary.getMethod("takeValueForKey", Object.class, String.class).invoke(dropFlags, "NO", PrimaryKeyConstraintsKey);
                String ForeignKeyConstraintsKey = (String)eoschemageneration.getField("ForeignKeyConstraintsKey").get(null);
                nsmutdictionary.getMethod("takeValueForKey", Object.class, String.class).invoke(dropFlags, "NO", ForeignKeyConstraintsKey);
                String CreateDatabaseKey = (String)eoschemageneration.getField("CreateDatabaseKey").get(null);
                nsmutdictionary.getMethod("takeValueForKey", Object.class, String.class).invoke(dropFlags, "NO", CreateDatabaseKey);
                String DropDatabaseKey = (String)eoschemageneration.getField("DropDatabaseKey").get(null);
                nsmutdictionary.getMethod("takeValueForKey", Object.class, String.class).invoke(dropFlags, "NO", DropDatabaseKey);
                nsmutdictionary.getMethod("takeValueForKey", Object.class, String.class).invoke(flags, "NO", DropTablesKey);
                String dropSql = (String)eosynchronizationfactory.getMethod("schemaCreationScriptForEntities", nsarray, nsdictionary).invoke(syncFactory, dropEntities, dropFlags);
                sqlBuffer.append(dropSql);
                sqlBuffer.append("\n");
            }
        }
    }

    private String getClassPath() {
        URL[] urls = ((URLClassLoader)this.getClass().getClassLoader()).getURLs();
        Object classPath = "";
        for (int i = 0; i < urls.length; ++i) {
            URL url = urls[i];
            classPath = (String)classPath + url.getFile() + File.pathSeparator;
        }
        return classPath;
    }

    private void fixClassPath() {
        String classPath = this.getClassPath();
        System.setProperty("java.class.path", classPath);
        System.setProperty("com.webobjects.classpath", classPath);
    }

    @Override
    public String generateSchemaCreationScript(Map flagsMap) {
        try {
            return this.generateSchemaCreationScriptReflect(flagsMap);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateSchemaCreationScriptReflect(Map flagsMap) throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        this.fixClassPath();
        Class<?> eodatabasecontext = Class.forName("com.webobjects.eoaccess.EODatabaseContext");
        Class<?> eodatabase = Class.forName("com.webobjects.eoaccess.EODatabase");
        Class<?> eomodel = Class.forName("com.webobjects.eoaccess.EOModel");
        Class<?> eosynchronizationfactory = Class.forName("com.webobjects.eoaccess.EOSynchronizationFactory");
        Class<?> eoadaptorcontext = Class.forName("com.webobjects.eoaccess.EOAdaptorContext");
        Class<?> jdbcadaptor = Class.forName("com.webobjects.jdbcadaptor.JDBCAdaptor");
        Class<?> jdbcplugin = Class.forName("com.webobjects.jdbcadaptor.JDBCPlugIn");
        Class<?> eoadaptorchannel = Class.forName("com.webobjects.eoaccess.EOAdaptorChannel");
        Class<?> nsarray = Class.forName("com.webobjects.foundation.NSArray");
        Class<?> nsdictionary = Class.forName("com.webobjects.foundation.NSDictionary");
        Class<?> nsmutarray = Class.forName("com.webobjects.foundation.NSMutableArray");
        Object flags = EOFSQLUtils53.toWOCollections(flagsMap);
        this.callModelProcessorMethodIfExists("processModel", new Object[]{this._model, this._entities, flags});
        Object db = eodatabase.getConstructor(eomodel).newInstance(this._model);
        Object dbc = eodatabasecontext.getConstructor(eodatabase).newInstance(db);
        Object ac = eodatabasecontext.getMethod("adaptorContext", new Class[0]).invoke(dbc, new Object[0]);
        Object ad = eoadaptorcontext.getMethod("adaptor", new Class[0]).invoke(ac, new Object[0]);
        Object plug = jdbcadaptor.getMethod("plugIn", new Class[0]).invoke(ad, new Object[0]);
        Object sf = jdbcplugin.getMethod("synchronizationFactory", new Class[0]).invoke(plug, new Object[0]);
        Object beforeOpenChannels = nsmutarray.getConstructor(new Class[0]).newInstance(new Object[0]);
        Object channelsarr = eoadaptorcontext.getMethod("channels", new Class[0]).invoke(ac, new Object[0]);
        Enumeration beforeChannelsEnum = (Enumeration)nsarray.getMethod("objectEnumerator", new Class[0]).invoke(channelsarr, new Object[0]);
        while (beforeChannelsEnum.hasMoreElements()) {
            Object channel = beforeChannelsEnum.nextElement();
            Boolean isOpen = (Boolean)eoadaptorchannel.getMethod("isOpen", new Class[0]).invoke(channel, new Object[0]);
            if (!isOpen.booleanValue()) continue;
            nsmutarray.getMethod("addObject", Object.class).invoke(beforeOpenChannels, channel);
        }
        StringBuffer sqlBuffer = new StringBuffer();
        this.fixDuplicateSingleTableInheritanceDropStatements(sf, flags, sqlBuffer);
        try {
            String sql = (String)eosynchronizationfactory.getMethod("schemaCreationScriptForEntities", nsarray, nsdictionary).invoke(sf, this._entities, flags);
            sql = sql.replaceAll("CREATE TABLE ([^\\s(]+)\\(", "CREATE TABLE $1 (");
            sqlBuffer.append(sql);
            this.callModelProcessorMethodIfExists("processSQL", new Object[]{sqlBuffer, this._model, this._entities, flags});
        }
        catch (Throwable throwable) {
            Object channelsarr2 = eoadaptorcontext.getMethod("channels", new Class[0]).invoke(ac, new Object[0]);
            Enumeration afterChannelsEnum = (Enumeration)nsarray.getMethod("objectEnumerator", new Class[0]).invoke(channelsarr2, new Object[0]);
            while (afterChannelsEnum.hasMoreElements()) {
                Object channel = afterChannelsEnum.nextElement();
                Boolean isOpen = (Boolean)eoadaptorchannel.getMethod("isOpen", new Class[0]).invoke(channel, new Object[0]);
                Boolean contains = (Boolean)nsmutarray.getMethod("containsObject", Object.class).invoke(beforeOpenChannels, channel);
                if (!isOpen.booleanValue() || contains.booleanValue()) continue;
                eoadaptorchannel.getMethod("closeChannel", new Class[0]).invoke(channel, new Object[0]);
            }
            throw throwable;
        }
        Object channelsarr2 = eoadaptorcontext.getMethod("channels", new Class[0]).invoke(ac, new Object[0]);
        Enumeration afterChannelsEnum = (Enumeration)nsarray.getMethod("objectEnumerator", new Class[0]).invoke(channelsarr2, new Object[0]);
        while (afterChannelsEnum.hasMoreElements()) {
            Object channel = afterChannelsEnum.nextElement();
            Boolean isOpen = (Boolean)eoadaptorchannel.getMethod("isOpen", new Class[0]).invoke(channel, new Object[0]);
            Boolean contains = (Boolean)nsmutarray.getMethod("containsObject", Object.class).invoke(beforeOpenChannels, channel);
            if (!isOpen.booleanValue() || contains.booleanValue()) continue;
            eoadaptorchannel.getMethod("closeChannel", new Class[0]).invoke(channel, new Object[0]);
        }
        String sqlBufferStr = sqlBuffer.toString();
        if (sqlBufferStr != null) {
            sqlBufferStr = Pattern.compile("([\\w\\)])(NOT NULL)", 2).matcher(sqlBufferStr).replaceAll("$1 $2");
        }
        return sqlBufferStr;
    }

    public Object callModelProcessorMethodIfExists(String methodName, Object[] _objs) {
        try {
            Object results = null;
            if (this._modelProcessor != null) {
                Method[] methods = this._modelProcessor.getClass().getMethods();
                Method matchingMethod = null;
                for (int methodNum = 0; matchingMethod == null && methodNum < methods.length; ++methodNum) {
                    Method method = methods[methodNum];
                    if (!method.getName().equals(methodName)) continue;
                    Class<?>[] parameterTypes = method.getParameterTypes();
                    boolean parametersMatch = false;
                    if ((_objs == null || _objs.length == 0) && parameterTypes.length == 0) {
                        parametersMatch = true;
                    } else if (_objs != null && _objs.length == parameterTypes.length) {
                        parametersMatch = true;
                        for (int parameterTypeNum = 0; parametersMatch && parameterTypeNum < parameterTypes.length; ++parameterTypeNum) {
                            Class<?> parameterType = parameterTypes[parameterTypeNum];
                            if (_objs[parameterTypeNum] == null || parameterType.isAssignableFrom(_objs.getClass())) continue;
                            parametersMatch = false;
                        }
                    }
                    matchingMethod = method;
                }
                if (matchingMethod != null) {
                    results = matchingMethod.invoke(this._modelProcessor, _objs);
                } else {
                    System.out.println("EOFSQLGenerator.callModelProcessorMethodIfExists: Missing delegate " + methodName);
                }
            }
            return results;
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to execute " + methodName + " on " + this._modelProcessor + ".", t);
        }
    }

    public void findModelProcessor(String modelProcessorClassName, boolean throwExceptionIfMissing) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        try {
            Class<?> modelProcessorClass = Class.forName(modelProcessorClassName);
            this._modelProcessor = modelProcessorClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            if (throwExceptionIfMissing) {
                throw e;
            }
        }
        catch (InstantiationException e) {
            if (throwExceptionIfMissing) {
                throw e;
            }
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            if (throwExceptionIfMissing) {
                throw e;
            }
            e.printStackTrace();
        }
        catch (RuntimeException e) {
            if (throwExceptionIfMissing) {
                throw e;
            }
            e.printStackTrace();
        }
    }

    @Override
    public void executeSQL(String sql) throws SQLException {
        try {
            this.executeSQLReflect(sql);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeSQLReflect(String sql) throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, SQLException {
        this.fixClassPath();
        Class<?> eodatabasecontext = Class.forName("com.webobjects.eoaccess.EODatabaseContext");
        Class<?> eodatabase = Class.forName("com.webobjects.eoaccess.EODatabase");
        Class<?> eodatabasechannel = Class.forName("com.webobjects.eoaccess.EODatabaseChannel");
        Class<?> eomodel = Class.forName("com.webobjects.eoaccess.EOModel");
        Class<?> eoadaptorcontext = Class.forName("com.webobjects.eoaccess.EOAdaptorContext");
        Class<?> eoadaptorchannel = Class.forName("com.webobjects.eoaccess.EOAdaptorChannel");
        Class<?> jdbccontext = Class.forName("com.webobjects.jdbcadaptor.JDBCContext");
        Class<?> nsarray = Class.forName("com.webobjects.foundation.NSArray");
        Class<?> nsmutarray = Class.forName("com.webobjects.foundation.NSMutableArray");
        Object db = eodatabase.getConstructor(eomodel).newInstance(this._model);
        Object dbc = eodatabasecontext.getConstructor(eodatabase).newInstance(db);
        Object ac = eodatabasecontext.getMethod("adaptorContext", new Class[0]).invoke(dbc, new Object[0]);
        Object beforeOpenChannels = nsmutarray.getConstructor(new Class[0]).newInstance(new Object[0]);
        Object channelsarr = eoadaptorcontext.getMethod("channels", new Class[0]).invoke(ac, new Object[0]);
        Enumeration beforeChannelsEnum = (Enumeration)nsarray.getMethod("objectEnumerator", new Class[0]).invoke(channelsarr, new Object[0]);
        while (beforeChannelsEnum.hasMoreElements()) {
            Object channel = beforeChannelsEnum.nextElement();
            Boolean isOpen = (Boolean)eoadaptorchannel.getMethod("isOpen", new Class[0]).invoke(channel, new Object[0]);
            if (!isOpen.booleanValue()) continue;
            nsmutarray.getMethod("addObject", Object.class).invoke(beforeOpenChannels, channel);
        }
        try {
            Object databaseChannel = eodatabasecontext.getMethod("availableChannel", new Class[0]).invoke(dbc, new Object[0]);
            Object adaptorChannel = eodatabasechannel.getMethod("adaptorChannel", new Class[0]).invoke(databaseChannel, new Object[0]);
            Boolean channelOpen = (Boolean)eoadaptorchannel.getMethod("isOpen", new Class[0]).invoke(adaptorChannel, new Object[0]);
            if (!channelOpen.booleanValue()) {
                eoadaptorchannel.getMethod("openChannel", new Class[0]).invoke(adaptorChannel, new Object[0]);
            }
            try {
                Object jdbcContext = eoadaptorchannel.getMethod("adaptorContext", new Class[0]).invoke(adaptorChannel, new Object[0]);
                try {
                    jdbccontext.getMethod("beginTransaction", new Class[0]).invoke(jdbcContext, new Object[0]);
                    Connection conn = (Connection)jdbccontext.getMethod("connection", new Class[0]).invoke(jdbcContext, new Object[0]);
                    Statement stmt = conn.createStatement();
                    stmt.executeUpdate(sql);
                    conn.commit();
                }
                catch (SQLException sqlexception) {
                    sqlexception.printStackTrace(System.out);
                    jdbccontext.getMethod("rollbackTransaction", new Class[0]).invoke(jdbcContext, new Object[0]);
                    throw sqlexception;
                }
            }
            finally {
                if (!channelOpen.booleanValue()) {
                    eoadaptorchannel.getMethod("closeChannel", new Class[0]).invoke(adaptorChannel, new Object[0]);
                }
            }
        }
        catch (Throwable throwable) {
            Object channelsarr2 = eoadaptorcontext.getMethod("channels", new Class[0]).invoke(ac, new Object[0]);
            Enumeration afterChannelsEnum = (Enumeration)nsarray.getMethod("objectEnumerator", new Class[0]).invoke(channelsarr2, new Object[0]);
            while (afterChannelsEnum.hasMoreElements()) {
                Object channel = afterChannelsEnum.nextElement();
                Boolean isOpen = (Boolean)eoadaptorchannel.getMethod("isOpen", new Class[0]).invoke(channel, new Object[0]);
                Boolean contains = (Boolean)nsmutarray.getMethod("containsObject", Object.class).invoke(beforeOpenChannels, channel);
                if (!isOpen.booleanValue() || contains.booleanValue()) continue;
                eoadaptorchannel.getMethod("closeChannel", new Class[0]).invoke(channel, new Object[0]);
            }
            throw throwable;
        }
        Object channelsarr2 = eoadaptorcontext.getMethod("channels", new Class[0]).invoke(ac, new Object[0]);
        Enumeration afterChannelsEnum = (Enumeration)nsarray.getMethod("objectEnumerator", new Class[0]).invoke(channelsarr2, new Object[0]);
        while (afterChannelsEnum.hasMoreElements()) {
            Object channel = afterChannelsEnum.nextElement();
            Boolean isOpen = (Boolean)eoadaptorchannel.getMethod("isOpen", new Class[0]).invoke(channel, new Object[0]);
            Boolean contains = (Boolean)nsmutarray.getMethod("containsObject", Object.class).invoke(beforeOpenChannels, channel);
            if (!isOpen.booleanValue() || contains.booleanValue()) continue;
            eoadaptorchannel.getMethod("closeChannel", new Class[0]).invoke(channel, new Object[0]);
        }
    }

    public Map externalTypes() {
        try {
            return this.externalTypesReflect();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private Map externalTypesReflect() throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Class<?> eodatabasecontext = Class.forName("com.webobjects.eoaccess.EODatabaseContext");
        Class<?> eodatabase = Class.forName("com.webobjects.eoaccess.EODatabase");
        Class<?> eomodel = Class.forName("com.webobjects.eoaccess.EOModel");
        Class<?> eoadaptorcontext = Class.forName("com.webobjects.eoaccess.EOAdaptorContext");
        Class<?> jdbcadaptor = Class.forName("com.webobjects.jdbcadaptor.JDBCAdaptor");
        Class<?> jdbcplugin = Class.forName("com.webobjects.jdbcadaptor.JDBCPlugIn");
        Object db = eodatabase.getConstructor(eomodel).newInstance(this._model);
        Object dbc = eodatabasecontext.getConstructor(eodatabase).newInstance(db);
        Object ac = eodatabasecontext.getMethod("adaptorContext", new Class[0]).invoke(dbc, new Object[0]);
        Object ad = eoadaptorcontext.getMethod("adaptor", new Class[0]).invoke(ac, new Object[0]);
        Object plug = jdbcadaptor.getMethod("plugIn", new Class[0]).invoke(ad, new Object[0]);
        Object jdbc2Info = jdbcplugin.getMethod("jdbcInfo", new Class[0]).invoke(plug, new Object[0]);
        return (Map)EOFSQLUtils53.toJavaCollections(jdbc2Info);
    }
}

