/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.wodclipse.core.refactoring;

import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.objectstyle.wolips.bindings.wod.IWodElement;
import org.objectstyle.wolips.wodclipse.core.completion.WodParserCache;
import org.objectstyle.wolips.wodclipse.core.refactoring.TemplateRefactoring;
import org.objectstyle.wolips.wodclipse.core.util.WodDocumentUtils;

public class ChangeElementTypeRefactoring
implements IRunnableWithProgress {
    private IWodElement _element;
    private String _newType;
    private WodParserCache _cache;

    public ChangeElementTypeRefactoring(String newType, IWodElement element, WodParserCache cache) {
        this._newType = newType;
        this._element = element;
        this._cache = cache;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException {
        try {
            Position typePosition = this._element.getElementTypePosition();
            if (this._element.isInline()) {
                IDocument htmlDocument = this._cache.getHtmlEntry().getDocument();
                if (htmlDocument != null) {
                    FuzzyXMLElement xmlElement;
                    LinkedList<TextEdit> htmlEdits = new LinkedList<TextEdit>();
                    FuzzyXMLDocument xmlDocument = (FuzzyXMLDocument)this._cache.getHtmlEntry().getModel();
                    if (xmlDocument != null && (xmlElement = xmlDocument.getElementByOffset(typePosition.getOffset())) != null && xmlElement.hasCloseTag()) {
                        htmlEdits.add((TextEdit)new ReplaceEdit(xmlElement.getCloseTagOffset() + xmlElement.getCloseNameOffset() + 1, xmlElement.getCloseNameLength(), "wo:" + this._newType));
                    }
                    htmlEdits.add((TextEdit)new ReplaceEdit(typePosition.getOffset(), typePosition.getLength(), this._newType));
                    WodDocumentUtils.applyEdits(htmlDocument, htmlEdits);
                }
            } else {
                IDocument wodDocument = this._cache.getWodEntry().getDocument();
                if (wodDocument != null) {
                    LinkedList<TextEdit> wodEdits = new LinkedList<TextEdit>();
                    wodEdits.add((TextEdit)new ReplaceEdit(typePosition.getOffset(), typePosition.getLength(), this._newType));
                    WodDocumentUtils.applyEdits(wodDocument, wodEdits);
                }
            }
        }
        catch (Exception e) {
            throw new InvocationTargetException(e, "Failed to refactor.");
        }
    }

    public static void run(String newType, IWodElement element, WodParserCache cache, IProgressMonitor progressMonitor) throws CoreException, InvocationTargetException, InterruptedException {
        TemplateRefactoring.processHtmlAndWod(new ChangeElementTypeRefactoring(newType, element, cache), cache, progressMonitor);
    }
}

