/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.wodclipse.core.refactoring;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.LinkedList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.objectstyle.wolips.bindings.wod.IWodElement;
import org.objectstyle.wolips.bindings.wod.IWodModel;
import org.objectstyle.wolips.wodclipse.core.completion.WodParserCache;
import org.objectstyle.wolips.wodclipse.core.refactoring.ElementRename;
import org.objectstyle.wolips.wodclipse.core.refactoring.RenameElementsRefactoring;
import org.objectstyle.wolips.wodclipse.core.refactoring.TemplateRefactoring;

public class CleanWOBuilderRefactoring
implements IRunnableWithProgress {
    private WodParserCache _cache;
    private boolean _forceRename;

    public CleanWOBuilderRefactoring(WodParserCache cache, boolean forceRename) {
        this._cache = cache;
        this._forceRename = forceRename;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException {
        try {
            this._cache.clearCache();
            LinkedList<ElementRename> elementRenames = new LinkedList<ElementRename>();
            HashSet<String> elementNames = new HashSet<String>();
            IWodModel wodModel = (IWodModel)this._cache.getWodEntry().getModel();
            for (IWodElement wodElement : wodModel.getElements()) {
                ElementRename elementRename = ElementRename.newUniqueName(wodModel, wodElement, elementNames, this._forceRename);
                if (elementRename == null) continue;
                elementRenames.add(elementRename);
            }
            new RenameElementsRefactoring(elementRenames, this._cache).run(monitor);
        }
        catch (Exception e) {
            throw new InvocationTargetException(e);
        }
    }

    public static void run(WodParserCache cache, boolean forceRename, IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException, CoreException {
        TemplateRefactoring.processHtmlAndWod(new CleanWOBuilderRefactoring(cache, forceRename), cache, progressMonitor);
    }
}

