/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.wodclipse.editor;

import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.objectstyle.wolips.bindings.api.ApiUtils;
import org.objectstyle.wolips.bindings.utils.BindingReflectionUtils;
import org.objectstyle.wolips.bindings.wod.TypeCache;
import org.objectstyle.wolips.wodclipse.WodclipsePlugin;
import org.objectstyle.wolips.wodclipse.core.completion.WodCompletionProposal;
import org.objectstyle.wolips.wodclipse.core.completion.WodCompletionUtils;
import org.objectstyle.wolips.wodclipse.core.completion.WodParserCache;
import org.objectstyle.wolips.wodclipse.core.parser.AssignmentOperatorWordDetector;
import org.objectstyle.wolips.wodclipse.core.parser.BindingNameRule;
import org.objectstyle.wolips.wodclipse.core.parser.BindingValueRule;
import org.objectstyle.wolips.wodclipse.core.parser.CloseDefinitionWordDetector;
import org.objectstyle.wolips.wodclipse.core.parser.ElementNameRule;
import org.objectstyle.wolips.wodclipse.core.parser.ElementTypeOperatorWordDetector;
import org.objectstyle.wolips.wodclipse.core.parser.ElementTypeRule;
import org.objectstyle.wolips.wodclipse.core.parser.EndAssignmentWordDetector;
import org.objectstyle.wolips.wodclipse.core.parser.OpenDefinitionWordDetector;
import org.objectstyle.wolips.wodclipse.core.parser.OperatorRule;
import org.objectstyle.wolips.wodclipse.core.parser.RulePosition;
import org.objectstyle.wolips.wodclipse.core.parser.WodScanner;
import org.objectstyle.wolips.wodclipse.editor.WodEditor;

public class WodCompletionProcessor
implements IContentAssistProcessor {
    private WodEditor _editor;

    public WodCompletionProcessor(WodEditor editor) {
        this._editor = editor;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[]{':', '.', '='};
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int _offset) {
        TreeSet<WodCompletionProposal> completionProposalsSet;
        block45: {
            completionProposalsSet = new TreeSet<WodCompletionProposal>();
            try {
                IRule rule;
                int tokenOffset;
                int offset = _offset;
                TypeCache typeCache = WodParserCache.getTypeCache();
                IDocument document = viewer.getDocument();
                IEditorInput input = this._editor.getEditorInput();
                if (!(input instanceof IPathEditorInput)) break block45;
                IPathEditorInput pathInput = (IPathEditorInput)input;
                IPath path = pathInput.getPath();
                IFile wodFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(path);
                IProject project = wodFile.getProject();
                IJavaProject javaProject = JavaCore.create((IProject)project);
                IRegion lineRegion = document.getLineInformationOfOffset(offset);
                WodScanner scanner = WodScanner.newWODScanner();
                scanner.setRange(document, lineRegion.getOffset(), lineRegion.getLength());
                boolean foundToken = false;
                RulePosition rulePosition = null;
                while (!foundToken && (rulePosition = scanner.nextRulePosition()) != null) {
                    tokenOffset = rulePosition.getTokenOffset();
                    if (offset == lineRegion.getOffset() && offset == tokenOffset) {
                        foundToken = true;
                        continue;
                    }
                    if (offset <= tokenOffset || offset > rulePosition.getTokenEndOffset()) continue;
                    foundToken = true;
                }
                tokenOffset = scanner.getTokenOffset();
                int tokenLength = scanner.getTokenLength();
                IRule iRule = rule = rulePosition == null ? null : rulePosition.getRule();
                if (rule instanceof WhitespaceRule) {
                    int partialOffset = offset - tokenOffset;
                    offset += partialOffset;
                    tokenOffset += partialOffset;
                    tokenLength = 0;
                } else {
                    viewer.setSelectedRange(offset, tokenLength - (offset - tokenOffset));
                }
                String token = document.get(tokenOffset, tokenLength);
                String tokenType = null;
                if (foundToken && rulePosition != null) {
                    if (rulePosition.isRuleOfType(ElementNameRule.class)) {
                        tokenType = "ComponentName";
                    } else if (rulePosition.isRuleOfType(ElementTypeRule.class)) {
                        tokenType = "ComponentType";
                    } else if (rulePosition.isRuleOfType(BindingNameRule.class)) {
                        tokenType = "BindingName";
                    } else if (rulePosition.isRuleOfType(BindingValueRule.class)) {
                        tokenType = "BindingValue";
                    } else if (rulePosition.isRuleOfType(OperatorRule.class)) {
                        tokenOffset += tokenLength;
                        tokenLength = 0;
                        if (RulePosition.isOperatorOfType(rulePosition, CloseDefinitionWordDetector.class)) {
                            tokenType = "ComponentName";
                        } else if (RulePosition.isOperatorOfType(rulePosition, ElementTypeOperatorWordDetector.class)) {
                            tokenType = "ComponentType";
                        } else if (RulePosition.isOperatorOfType(rulePosition, OpenDefinitionWordDetector.class) || RulePosition.isOperatorOfType(rulePosition, EndAssignmentWordDetector.class)) {
                            tokenType = "BindingName";
                        } else if (RulePosition.isOperatorOfType(rulePosition, AssignmentOperatorWordDetector.class)) {
                            tokenType = "BindingValue";
                        }
                    }
                }
                boolean guessed = false;
                if (tokenType == null) {
                    int startOffset = tokenOffset;
                    if (startOffset != 0 && startOffset == document.getLength()) {
                        --startOffset;
                    }
                    boolean tentativeElementType = false;
                    while (tokenType == null && startOffset > 0) {
                        char ch = document.getChar(startOffset);
                        if (ch == ':') {
                            tentativeElementType = true;
                        } else if (ch == '{' || ch == ';') {
                            tokenType = "BindingName";
                            guessed = true;
                        } else if (ch == '=') {
                            tokenType = "BindingValue";
                            guessed = true;
                        } else if (ch == '}') {
                            tokenType = "ComponentName";
                            guessed = true;
                        }
                        --startOffset;
                    }
                    if (tentativeElementType && tokenType == "BindingValue") {
                        tokenType = "BindingValueNamespace";
                        guessed = true;
                    } else if (tentativeElementType) {
                        tokenType = "ComponentType";
                        guessed = true;
                    }
                }
                if (tokenType == null) {
                    tokenType = "ComponentName";
                    guessed = true;
                }
                if (tokenType == "ComponentName") {
                    Set<String> alreadyUsedElementNames = WodScanner.getTextForRulesOfType(document, ElementNameRule.class);
                    WodParserCache wodParserCache = WodParserCache.parser((IResource)((FileEditorInput)this._editor.getEditorInput()).getFile());
                    WodCompletionUtils.fillInElementNameCompletionProposals(alreadyUsedElementNames, token, tokenOffset, offset, completionProposalsSet, guessed, wodParserCache.getHtmlEntry().getHtmlElementCache());
                    break block45;
                }
                if (tokenType == "ComponentType") {
                    WodCompletionUtils.fillInElementTypeCompletionProposals(javaProject, token, tokenOffset, offset, completionProposalsSet, guessed, null);
                    break block45;
                }
                if (tokenType == "BindingName") {
                    IType elementType = this.findNearestElementType(javaProject, document, scanner, tokenOffset, typeCache);
                    WodCompletionUtils.fillInBindingNameCompletionProposals(javaProject, elementType, token, tokenOffset, offset, completionProposalsSet, guessed, typeCache);
                    break block45;
                }
                if (tokenType != "BindingValue") break block45;
                IType elementType = this._editor.getComponentsLocateResults().getDotJavaType();
                boolean checkBindingValue = false;
                if (elementType != null) {
                    checkBindingValue = WodCompletionUtils.fillInBindingValueCompletionProposals(javaProject, elementType, token, tokenOffset, offset, completionProposalsSet, typeCache);
                }
                if (!checkBindingValue) break block45;
                try {
                    int equalsIndex = WodCompletionProcessor.scanBackFor(document, offset, new char[]{'='}, false);
                    int noSpaceIndex = WodCompletionProcessor.scanBackFor(document, equalsIndex - 1, new char[]{' ', '\t', '\n', '\r'}, true);
                    int spaceIndex = WodCompletionProcessor.scanBackFor(document, noSpaceIndex, new char[]{' ', '\t', '\n', '\r'}, false);
                    String bindingName = document.get(spaceIndex + 1, noSpaceIndex - spaceIndex);
                    elementType = this.findNearestElementType(javaProject, document, scanner, offset, typeCache);
                    String[] validValues = ApiUtils.getValidValues((String)token, (IJavaProject)javaProject, (IType)this._editor.getComponentsLocateResults().getDotJavaType(), (IType)elementType, (String)bindingName, (TypeCache)typeCache);
                    if (validValues != null) {
                        String partialToken = WodCompletionUtils.partialToken(token, tokenOffset, offset);
                        String lowercasePartialToken = partialToken.toLowerCase();
                        for (int i = 0; i < validValues.length; ++i) {
                            if (!validValues[i].toLowerCase().startsWith(lowercasePartialToken)) continue;
                            completionProposalsSet.add(new WodCompletionProposal(token, tokenOffset, offset, validValues[i]));
                        }
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    WodclipsePlugin.getDefault().log(t);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                WodclipsePlugin.getDefault().log(e);
            }
        }
        return completionProposalsSet.toArray(new WodCompletionProposal[completionProposalsSet.size()]);
    }

    public String getErrorMessage() {
        return null;
    }

    protected IType findNearestElementType(IJavaProject _project, IDocument _document, WodScanner _scanner, int _offset, TypeCache cache) throws BadLocationException, JavaModelException {
        IType type = null;
        int offset = _offset;
        while (offset != -1 && type == null) {
            int colonOffset = WodCompletionProcessor.scanBackFor(_document, offset = WodCompletionProcessor.scanBackFor(_document, offset, new char[]{'{'}, false, true), new char[]{':'}, false, true);
            if (colonOffset != -1) {
                _scanner.setRange(_document, colonOffset, _offset - colonOffset);
                RulePosition elementRulePosition = _scanner.getFirstRulePositionOfType(ElementTypeRule.class);
                if (elementRulePosition != null) {
                    String elementTypeName = elementRulePosition.getText();
                    type = BindingReflectionUtils.findElementType((IJavaProject)_project, (String)elementTypeName, (boolean)false, (TypeCache)cache);
                    offset = -1;
                    continue;
                }
                --offset;
                continue;
            }
            type = null;
        }
        return type;
    }

    protected static int scanBackFor(IDocument _document, int _offset, char[] _lookForChars, boolean _negate) throws BadLocationException {
        return WodCompletionProcessor.scanBackFor(_document, _offset, _lookForChars, _negate, false);
    }

    protected static int scanBackFor(IDocument _document, int _offset, char[] _lookForChars, boolean _negate, boolean excludeQuoted) throws BadLocationException {
        int offset = _offset;
        if (offset >= _document.getLength()) {
            --offset;
        }
        int foundIndex = -1;
        boolean inQuote = false;
        char quoteChar = '\u0000';
        for (int i = offset; foundIndex == -1 && i >= 0; --i) {
            char ch = _document.getChar(i);
            if (ch == '\'' || ch == '\"') {
                boolean escaped;
                boolean bl = escaped = i > 0 && _document.getChar(i - 1) == '\\';
                if (inQuote && quoteChar == ch && !escaped) {
                    inQuote = false;
                    quoteChar = '\u0000';
                } else if (!inQuote) {
                    inQuote = true;
                    quoteChar = ch;
                }
            }
            for (int lookForCharNum = 0; foundIndex == -1 && lookForCharNum < _lookForChars.length; ++lookForCharNum) {
                if (ch != _lookForChars[lookForCharNum] || inQuote && excludeQuoted) continue;
                foundIndex = i;
            }
            if (!_negate) continue;
            foundIndex = foundIndex != -1 ? -1 : i;
        }
        return foundIndex;
    }
}

