/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.wodclipse.editor;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.ui.IFileEditorInput;
import org.objectstyle.wolips.bindings.wod.IWodBinding;
import org.objectstyle.wolips.bindings.wod.IWodElement;
import org.objectstyle.wolips.bindings.wod.IWodModel;
import org.objectstyle.wolips.wodclipse.core.Activator;
import org.objectstyle.wolips.wodclipse.core.completion.WodParserCache;
import org.objectstyle.wolips.wodclipse.core.document.WodBindingNameHyperlink;
import org.objectstyle.wolips.wodclipse.core.document.WodBindingValueHyperlink;
import org.objectstyle.wolips.wodclipse.core.document.WodElementTypeHyperlink;
import org.objectstyle.wolips.wodclipse.editor.WodEditor;

public class WodElementHyperlinkDetector
implements IHyperlinkDetector {
    private WodEditor _editor;

    public WodElementHyperlinkDetector(WodEditor editor) {
        this._editor = editor;
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        LinkedList<Object> hyperlinks = new LinkedList<Object>();
        try {
            List wodElements;
            IFile file;
            WodParserCache cache;
            IWodModel model;
            IFileEditorInput input = (IFileEditorInput)this._editor.getEditorInput();
            if (input != null && (model = (IWodModel)(cache = WodParserCache.parser((IResource)(file = input.getFile()))).getWodEntry().getModel()) != null && (wodElements = model.getElements()) != null) {
                for (IWodElement element : wodElements) {
                    WodElementTypeHyperlink typeHyperlink;
                    if (!element.isWithin(region)) continue;
                    if (element.isTypeWithin(region) && (typeHyperlink = WodElementTypeHyperlink.toElementTypeHyperlink(element, cache)) != null) {
                        hyperlinks.add(typeHyperlink);
                    }
                    for (IWodBinding binding : element.getBindings()) {
                        Object bindingHyperlink;
                        if (binding.isNameWithin(region)) {
                            bindingHyperlink = WodBindingNameHyperlink.toBindingNameHyperlink(element, binding.getName(), cache);
                            if (bindingHyperlink == null) continue;
                            hyperlinks.add(bindingHyperlink);
                            continue;
                        }
                        if (!binding.isValueWithin(region) || (bindingHyperlink = WodBindingValueHyperlink.toBindingValueHyperlink(element, binding.getName(), cache)) == null) continue;
                        hyperlinks.add(bindingHyperlink);
                    }
                }
            }
        }
        catch (Exception e) {
            Activator.getDefault().log(e);
        }
        IHyperlink[] hyperlinksArray = hyperlinks.size() == 0 ? null : hyperlinks.toArray(new IHyperlink[hyperlinks.size()]);
        return hyperlinksArray;
    }
}

