/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.refactoring;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.objectstyle.wolips.core.resources.types.project.ProjectAdapter;
import org.objectstyle.wolips.refactoring.PrincipalClassChange;
import org.objectstyle.wolips.refactoring.PrincipalClassMoveParticipant;

public class PrincipalClassRenameParticipant
extends RenameParticipant {
    private ProjectAdapter myProject;
    private Object _element;

    protected boolean initialize(Object element) {
        this.myProject = PrincipalClassMoveParticipant.getInitializedProject(element);
        this._element = element;
        boolean initialized = this.myProject != null;
        return initialized;
    }

    public String getName() {
        return "Rename Principal Class";
    }

    public RefactoringStatus checkConditions(IProgressMonitor _pm, CheckConditionsContext _context) throws OperationCanceledException {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        return refactoringStatus;
    }

    public Change createChange(IProgressMonitor _pm) throws CoreException, OperationCanceledException {
        PrincipalClassChange change = null;
        if (this.myProject != null) {
            String principalClass = this.myProject.getBuildProperties().getPrincipalClass(true);
            int nameIndex = principalClass.lastIndexOf(36);
            if (nameIndex == -1) {
                nameIndex = principalClass.lastIndexOf(46);
            }
            if (this._element instanceof IType) {
                String newName = principalClass.substring(0, nameIndex + 1) + this.getArguments().getNewName();
                change = new PrincipalClassChange(this.myProject, newName);
            } else if (this._element instanceof IPackageFragment) {
                String newPackageName = this.getArguments().getNewName();
                String className = principalClass.substring(nameIndex + 1);
                change = new PrincipalClassChange(this.myProject, newPackageName + "." + className);
            }
        }
        return change;
    }
}

