/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.refactoring;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.changes.RenameCompilationUnitChange;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.resource.RenameResourceChange;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.objectstyle.wolips.locate.LocateException;
import org.objectstyle.wolips.locate.LocatePlugin;
import org.objectstyle.wolips.locate.result.LocalizedComponentsLocateResult;
import org.objectstyle.wolips.refactoring.RefactoringPlugin;

public final class RenameWOComponentChange
extends CompositeChange {
    private final String _comment;
    private final RefactoringDescriptor _descriptor;
    private final String _newName;
    private final IPath _resourcePath;
    private final boolean _renameClass;
    private final LocatePlugin locate = LocatePlugin.getDefault();
    private ICompilationUnit _compilationUnit;
    private IFile _groovyFile;

    public static IPath renamedResourcePath(IPath path, String newName) {
        return path.removeLastSegments(1).append(newName);
    }

    private RenameWOComponentChange(RefactoringDescriptor descriptor, IPath resourcePath, String newName, String comment, boolean renameClass) {
        super("Rename WOComponent");
        this._descriptor = descriptor;
        this._resourcePath = resourcePath;
        this._newName = newName;
        this._comment = comment;
        this._renameClass = renameClass;
        try {
            this.createChanges();
        }
        catch (OperationCanceledException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public RenameWOComponentChange(RefactoringDescriptor descriptor, IResource resource, String newName, String comment, boolean renameClass) {
        this(descriptor, resource.getFullPath(), newName, comment, renameClass);
    }

    public RenameWOComponentChange(RefactoringDescriptor descriptor, IResource resource, String newName, String comment) {
        this(descriptor, resource.getFullPath(), newName, comment, true);
    }

    public ChangeDescriptor getDescriptor() {
        if (this._descriptor != null) {
            return new RefactoringChangeDescriptor(this._descriptor);
        }
        return super.getDescriptor();
    }

    public Object getModifiedElement() {
        return this.getResource();
    }

    public String getName() {
        return "Rename WOComponent " + this.getOldName() + " to " + this.getNewName();
    }

    public String getNewName() {
        return this.locate.fileNameWithoutExtension(this._newName);
    }

    public String getOldName() {
        return this.locate.fileNameWithoutExtension(this._resourcePath.lastSegment());
    }

    private IResource getResource() {
        return ResourcesPlugin.getWorkspace().getRoot().findMember(this._resourcePath);
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        IResource resource = this.getResource();
        if (resource == null || !resource.exists()) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format((String)RefactoringCoreMessages.RenameResourceChange_does_not_exist, (Object)this._resourcePath.toString()));
        }
        return new RefactoringStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Change perform(IProgressMonitor pm) throws CoreException {
        try {
            pm.beginTask("Renaming WO Component", 1);
            IPath newPath = RenameWOComponentChange.renamedResourcePath(this._resourcePath, this._newName);
            String oldName = this._resourcePath.lastSegment();
            super.perform(pm);
            RenameWOComponentChange renameWOComponentChange = new RenameWOComponentChange(null, newPath, oldName, this._comment, this._renameClass);
            return renameWOComponentChange;
        }
        finally {
            pm.done();
        }
    }

    private void createChanges() throws CoreException, OperationCanceledException {
        IFile oldApiFile = null;
        IFolder[] oldWoFolders = new IFolder[]{};
        try {
            LocalizedComponentsLocateResult result = LocatePlugin.getDefault().getLocalizedComponentsLocateResult(this.getResource());
            if (result != null) {
                oldWoFolders = result.getComponents();
                oldApiFile = result.getDotApi();
            }
        }
        catch (LocateException e) {
            throw new CoreException((IStatus)new Status(4, RefactoringPlugin.getDefault().getBundleID(), 4, "Could not locate component: " + this._resourcePath.lastSegment(), null));
        }
        if (oldApiFile != null || oldWoFolders.length > 0) {
            CompositeChange compositeChange = new CompositeChange("Rename WOComponent Files");
            if (oldApiFile != null) {
                int dotPosition;
                String javaFileName = this.getCompilationUnit().getElementName();
                if (!this.renameJavaClassInAPIFile(compositeChange, oldApiFile, javaFileName) && (dotPosition = javaFileName.indexOf(46)) > -1) {
                    javaFileName = javaFileName.substring(0, dotPosition);
                    this.renameJavaClassInAPIFile(compositeChange, oldApiFile, javaFileName);
                }
                compositeChange.add((Change)new RenameResourceChange(oldApiFile.getFullPath(), this.getNewName() + ".api"));
            }
            for (int i = 0; i < oldWoFolders.length; ++i) {
                IFolder oldWoFolder = oldWoFolders[i];
                if (oldWoFolder == null) continue;
                CompositeChange renameWoFolderChange = new CompositeChange("Rename " + oldWoFolder.getName());
                String[] renameExtensions = new String[]{".html", ".wod", ".woo", ".xml", ".xhtml"};
                for (int j = 0; j < renameExtensions.length; ++j) {
                    IFile woFile = oldWoFolder.getFile(this.getOldName() + renameExtensions[j]);
                    if (!woFile.exists()) continue;
                    renameWoFolderChange.add((Change)new RenameResourceChange(woFile.getFullPath(), this.getNewName() + renameExtensions[j]));
                }
                renameWoFolderChange.add((Change)new RenameResourceChange(oldWoFolder.getFullPath(), this.getNewName() + ".wo"));
                compositeChange.add((Change)renameWoFolderChange);
            }
            this.add((Change)compositeChange);
            if (this._renameClass && this.getCompilationUnit() != null) {
                this.add((Change)new RenameCompilationUnitChange(this.getCompilationUnit(), this.getNewName() + ".java"));
            }
        }
    }

    private boolean renameJavaClassInAPIFile(CompositeChange compositeChange, IFile oldApiFile, String javaFileName) throws CoreException {
        TextFileChange apiTextFileChange = new TextFileChange("Rename Java class name in API file", oldApiFile);
        apiTextFileChange.setTextType("xml");
        String apiContent = apiTextFileChange.getCurrentContent(null);
        int javaFileNamePosition = apiContent.indexOf(javaFileName);
        if (javaFileNamePosition > -1) {
            apiTextFileChange.setEdit((TextEdit)new ReplaceEdit(javaFileNamePosition, javaFileName.length(), this.getNewName() + ".java"));
            compositeChange.add((Change)apiTextFileChange);
            return true;
        }
        return false;
    }

    private ICompilationUnit getCompilationUnit() {
        if (this._compilationUnit != null) {
            return this._compilationUnit;
        }
        try {
            IType javaType;
            LocalizedComponentsLocateResult results = this.locate.getLocalizedComponentsLocateResult(this.getResource());
            if (results != null && (javaType = results.getDotJavaType()) != null) {
                this._compilationUnit = javaType.getCompilationUnit();
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (LocateException e) {
            e.printStackTrace();
        }
        return this._compilationUnit;
    }

    private IFile getGroovyFile() {
        if (this._groovyFile != null) {
            return this._groovyFile;
        }
        try {
            LocalizedComponentsLocateResult results = this.locate.getLocalizedComponentsLocateResult(this.getResource());
            if (results != null) {
                this._groovyFile = results.getDotGroovy();
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (LocateException e) {
            e.printStackTrace();
        }
        return this._groovyFile;
    }
}

