/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.launching;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.launching.IRuntimeClasspathEntryResolver;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.objectstyle.wolips.baseforuiplugins.AbstractBaseUIActivator;
import org.objectstyle.wolips.launching.classpath.WORuntimeClasspathEntryResolver;
import org.objectstyle.wolips.launching.exceptionhandler.IExceptionHandler;
import org.objectstyle.wolips.launching.exceptionhandler.internal.ExceptionHandlerWrapper;
import org.osgi.framework.BundleContext;

public class LaunchingPlugin
extends AbstractBaseUIActivator {
    private static LaunchingPlugin plugin;
    public static final String PLUGIN_ID = "org.objectstyle.wolips.launching";
    private ExceptionHandlerWrapper[] exceptionHandlerWrapper;
    private static final String EXTENSION_POINT_ID = "org.objectstyle.wolips.launching.exceptionhandlers";

    public LaunchingPlugin() {
        plugin = this;
        JavaRuntime.addContainerResolver((IRuntimeClasspathEntryResolver)new WORuntimeClasspathEntryResolver(), (String)"WOFramework");
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static LaunchingPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    private void loadExceptionHandlerExtensionPoint() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(EXTENSION_POINT_ID);
        IExtension[] extensions = extensionPoint.getExtensions();
        ArrayList<ExceptionHandlerWrapper> arrayList = new ArrayList<ExceptionHandlerWrapper>();
        for (int i = 0; i < extensions.length; ++i) {
            IConfigurationElement[] configurationElements = extensions[i].getConfigurationElements();
            for (int j = 0; j < configurationElements.length; ++j) {
                IConfigurationElement configurationElement = configurationElements[j];
                IExceptionHandler currentBuilder = null;
                try {
                    currentBuilder = (IExceptionHandler)configurationElement.createExecutableExtension("class");
                    String name = configurationElement.getAttribute("name");
                    arrayList.add(new ExceptionHandlerWrapper(currentBuilder, name));
                    continue;
                }
                catch (CoreException e) {
                    this.log("Could not create executable from configuration element: " + configurationElement, e);
                }
            }
        }
        this.exceptionHandlerWrapper = arrayList.toArray(new ExceptionHandlerWrapper[arrayList.size()]);
    }

    public ExceptionHandlerWrapper[] getExceptionHandlerWrapper() {
        if (this.exceptionHandlerWrapper == null) {
            this.loadExceptionHandlerExtensionPoint();
        }
        return this.exceptionHandlerWrapper;
    }
}

