/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.launching.browsersupport;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.debug.ui.console.IConsoleLineTracker;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.internal.browser.WebBrowserUIPlugin;
import org.objectstyle.wolips.launching.LaunchingPlugin;

public class ConsoleLineTracker
implements IConsoleLineTracker {
    private boolean urlFound;
    private IConsole currentConsole;
    private boolean webserverURLFound;
    private boolean webserverConnect;

    public void init(IConsole console) {
        String openBrowser = null;
        try {
            openBrowser = console.getProcess().getLaunch().getLaunchConfiguration().getAttribute("WOJavaLocalApplicationLaunchConfigurationDelegate.OpenInBrowser", "false");
        }
        catch (CoreException e) {
            LaunchingPlugin.getDefault().log(e);
        }
        String webServerConnectString = null;
        try {
            webServerConnectString = console.getProcess().getLaunch().getLaunchConfiguration().getAttribute("WOJavaLocalApplicationLaunchConfigurationDelegate.WebServerConnect", "false");
        }
        catch (CoreException e) {
            LaunchingPlugin.getDefault().log(e);
        }
        if (openBrowser != null && openBrowser.equals("true")) {
            this.urlFound = false;
            this.webserverConnect = webServerConnectString != null && webServerConnectString.equals("true");
            this.webserverURLFound = false;
            this.currentConsole = console;
        } else {
            this.urlFound = true;
        }
    }

    public void lineAppended(IRegion line) {
        if (this.urlFound) {
            return;
        }
        int offset = line.getOffset();
        int length = line.getLength();
        String text = null;
        try {
            text = this.currentConsole.getDocument().get(offset, length);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        if (text != null && text.startsWith("http://")) {
            final String urlString = text;
            if (!this.webserverConnect && !this.webserverURLFound) {
                this.webserverURLFound = true;
                return;
            }
            this.urlFound = true;
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        URL url = new URL(urlString);
                        IWorkbenchBrowserSupport browserSupport = WebBrowserUIPlugin.getInstance().getWorkbench().getBrowserSupport();
                        IWebBrowser browser = browserSupport.createBrowser(6, null, null, null);
                        browser.openURL(url);
                    }
                    catch (MalformedURLException e1) {
                        LaunchingPlugin.getDefault().log(e1);
                    }
                    catch (PartInitException e) {
                        LaunchingPlugin.getDefault().log(e);
                    }
                }
            });
        }
    }

    public void dispose() {
        this.currentConsole = null;
    }
}

