/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.builder.internal;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.objectstyle.woenvironment.pb.PBXProject;
import org.objectstyle.woenvironment.pb.XcodeProjProject;
import org.objectstyle.woenvironment.pb.XcodeProject;
import org.objectstyle.woenvironment.plist.PropertyListParserException;
import org.objectstyle.wolips.builder.BuilderPlugin;
import org.objectstyle.wolips.core.resources.builder.IBuilder;
import org.objectstyle.wolips.core.resources.builder.IFullBuilder;
import org.objectstyle.wolips.core.resources.builder.IIncrementalBuilder;
import org.objectstyle.wolips.core.resources.internal.build.BuilderWrapper;
import org.objectstyle.wolips.core.resources.internal.build.FullBuildDeltaVisitor;
import org.objectstyle.wolips.jdt.ProjectFrameworkAdapter;
import org.objectstyle.wolips.preferences.Preferences;

public class DotXcodeBuilder
implements IIncrementalBuilder,
IFullBuilder {
    private XcodeProject myXcodeProject;
    private XcodeProjProject myXcodeProjProject;
    private Map myXcodeProjects = new HashMap();
    private Map myXcodeProjProjects = new HashMap();
    private boolean myProjectChanged;

    public boolean isEnabled() {
        return Preferences.shouldWriteXcodeOnBuild();
    }

    private XcodeProject getXcodeProject(IProject project, boolean create) {
        String key = project.getName();
        XcodeProject xcodeproject = (XcodeProject)this.myXcodeProjects.get(key);
        if (xcodeproject == null && create) {
            xcodeproject = new XcodeProject();
            this.myXcodeProjects.put(key, xcodeproject);
            this.myProjectChanged = true;
        }
        return xcodeproject;
    }

    private XcodeProjProject getXcodeProjProject(IProject project, boolean create) {
        String key = project.getName();
        XcodeProjProject xcodeproject = (XcodeProjProject)this.myXcodeProjProjects.get(key);
        if (xcodeproject == null && create) {
            xcodeproject = new XcodeProjProject();
            this.myXcodeProjProjects.put(key, xcodeproject);
            this.myProjectChanged = true;
        }
        return xcodeproject;
    }

    public boolean buildStarted(int kind, Map args, IProgressMonitor monitor, IProject project, Map buildCache) {
        boolean exists;
        boolean fullRebuild;
        boolean bl = fullRebuild = kind == 6;
        if (Preferences.shouldWriteXcodeOnBuild()) {
            exists = project.getFolder(project.getName() + ".xcode").getFile("project.pbxproj").exists();
            this.myXcodeProject = this.getXcodeProject(project, true);
            if (fullRebuild |= !exists || this.myProjectChanged) {
                this.fullVisit(kind, args, monitor, project, buildCache);
            }
        } else {
            this.myXcodeProject = null;
        }
        if (Preferences.shouldWriteXcodeProjOnBuild()) {
            exists = project.getFolder(project.getName() + ".xcodeproj").getFile("project.pbxproj").exists();
            this.myXcodeProjProject = this.getXcodeProjProject(project, true);
            if (fullRebuild |= !exists || this.myProjectChanged) {
                this.fullVisit(kind, args, monitor, project, buildCache);
            }
        } else {
            this.myXcodeProjProject = null;
        }
        this.myProjectChanged |= fullRebuild;
        return fullRebuild;
    }

    private void fullVisit(int kind, Map args, IProgressMonitor monitor, IProject project, Map buildCache) {
        BuilderWrapper[] wrappers = new BuilderWrapper[]{new BuilderWrapper((IBuilder)this, "DotXCode", "dontknow")};
        FullBuildDeltaVisitor fullBuildDeltaVisitor = new FullBuildDeltaVisitor(wrappers, monitor, buildCache);
        fullBuildDeltaVisitor.buildStarted(project);
        try {
            project.accept((IResourceVisitor)fullBuildDeltaVisitor);
            this.buildPreparationDone(kind, args, monitor, project, buildCache);
            fullBuildDeltaVisitor.visitingDone();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public boolean buildPreparationDone(int kind, Map args, IProgressMonitor monitor, IProject project, Map buildCache) {
        if (this.myProjectChanged) {
            this.myProjectChanged = false;
            if (this.myXcodeProject != null) {
                try {
                    this.writeXcodeProject(monitor, project, (PBXProject)this.myXcodeProject, project.getName() + ".xcode");
                }
                catch (Exception e) {
                    BuilderPlugin.getDefault().log(e);
                }
            }
            if (this.myXcodeProjProject != null) {
                try {
                    this.writeXcodeProject(monitor, project, (PBXProject)this.myXcodeProjProject, project.getName() + ".xcodeproj");
                }
                catch (Exception e) {
                    BuilderPlugin.getDefault().log(e);
                }
            }
        }
        return false;
    }

    protected void writeXcodeProject(IProgressMonitor monitor, IProject project, PBXProject xcodeProject, String projectFolderName) throws CoreException, PropertyListParserException, IOException {
        ProjectFrameworkAdapter projectAdapter = (ProjectFrameworkAdapter)project.getAdapter(ProjectFrameworkAdapter.class);
        List frameworkPaths = projectAdapter.getFrameworkPaths();
        for (IPath frameworkPath : frameworkPaths) {
            IContainer frameworkContainer = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(frameworkPath);
            if (frameworkContainer instanceof IProject) {
                IPath defaultOutputLocation;
                IProject frameworkProject = (IProject)frameworkContainer;
                IJavaProject frameworkJavaProject = JavaCore.create((IProject)frameworkProject);
                if (frameworkJavaProject == null || (defaultOutputLocation = frameworkProject.getLocation().append("build")) == null) continue;
                IPath builtFrameworkPath = defaultOutputLocation.append(frameworkProject.getName() + ".framework");
                xcodeProject.addFrameworkReference(builtFrameworkPath.toOSString());
                continue;
            }
            xcodeProject.addFrameworkReference(frameworkPath.toOSString());
        }
        IFile projectFolderFile = project.getFile(projectFolderName);
        if (projectFolderFile.exists()) {
            BuilderPlugin.getDefault().log("Specified Xcode project package (" + projectFolderName + ") is not a directory.");
        } else {
            IFolder projectFolder = project.getFolder(projectFolderName);
            if (!projectFolder.exists()) {
                projectFolder.create(false, true, monitor);
            }
            IFile pbxProjFile = projectFolder.getFile("project.pbxproj");
            xcodeProject.save(pbxProjFile.getLocation().toFile());
            pbxProjFile.refreshLocal(2, monitor);
        }
    }

    public void handleSourceDelta(IResourceDelta delta, IProgressMonitor monitor, Map buildCache) {
        IResource resource = delta.getResource();
        if (resource != null) {
            if (delta.getKind() == 1) {
                this.handleSource(resource, monitor, buildCache);
            } else if (delta.getKind() == 2) {
                String resourcePath = resource.getLocation().toOSString();
                if (this.myXcodeProject != null) {
                    this.myXcodeProject.removeSourceReference(resourcePath);
                }
                if (this.myXcodeProjProject != null) {
                    this.myXcodeProjProject.removeSourceReference(resourcePath);
                }
                this.myProjectChanged = true;
            }
        }
    }

    public void handleClassesDelta(IResourceDelta delta, IProgressMonitor monitor, Map buildCache) {
    }

    public void handleWoappResourcesDelta(IResourceDelta delta, IProgressMonitor monitor, Map buildCache) {
        IResource resource = delta.getResource();
        if (resource != null) {
            if (delta.getKind() == 1) {
                this.handleWoappResources(resource, monitor, buildCache);
            } else if (delta.getKind() == 2) {
                String resourcePath = resource.getLocation().toOSString();
                if (resource instanceof IFile) {
                    if (this.myXcodeProject != null) {
                        this.myXcodeProject.removeResourceFileReference(resourcePath);
                    }
                    if (this.myXcodeProjProject != null) {
                        this.myXcodeProjProject.removeResourceFileReference(resourcePath);
                    }
                    this.myProjectChanged = true;
                } else if (resource instanceof IFolder) {
                    if (this.myXcodeProject != null) {
                        this.myXcodeProject.removeResourceFolderReference(resourcePath);
                    }
                    if (this.myXcodeProjProject != null) {
                        this.myXcodeProjProject.removeResourceFolderReference(resourcePath);
                    }
                    this.myProjectChanged = true;
                }
            }
        }
    }

    public void handleWebServerResourcesDelta(IResourceDelta delta, IProgressMonitor monitor, Map buildCache) {
        IResource resource = delta.getResource();
        if (delta.getKind() == 1) {
            this.handleWebServerResources(resource, monitor, buildCache);
        } else if (delta.getKind() == 2) {
            if (resource instanceof IFile) {
                String resourcePath = resource.getLocation().toOSString();
                if (this.myXcodeProject != null) {
                    this.myXcodeProject.removeWSResourceFileReference(resourcePath);
                }
                if (this.myXcodeProjProject != null) {
                    this.myXcodeProjProject.removeWSResourceFileReference(resourcePath);
                }
                this.myProjectChanged = true;
            } else if (resource instanceof IFolder) {
                String resourcePath = resource.getLocation().toOSString();
                if (this.myXcodeProject != null) {
                    this.myXcodeProject.removeWSResourceFolderReference(resourcePath);
                }
                if (this.myXcodeProjProject != null) {
                    this.myXcodeProjProject.removeWSResourceFolderReference(resourcePath);
                }
                this.myProjectChanged = true;
            }
        }
    }

    public void handleOtherDelta(IResourceDelta delta, IProgressMonitor monitor, Map buildCache) {
    }

    public void classpathChanged(IResourceDelta delta, IProgressMonitor monitor, Map buildCache) {
    }

    public void handleSource(IResource resource, IProgressMonitor progressMonitor, Map buildCache) {
        if (resource != null) {
            String resourcePath = resource.getLocation().toOSString();
            if (this.myXcodeProject != null) {
                this.myXcodeProject.addSourceReference(resourcePath);
            }
            if (this.myXcodeProjProject != null) {
                this.myXcodeProjProject.addSourceReference(resourcePath);
            }
            this.myProjectChanged = true;
        }
    }

    public void handleClasses(IResource resource, IProgressMonitor progressMonitor, Map buildCache) {
    }

    public void handleClasspath(IResource resource, IProgressMonitor progressMonitor, Map buildCache) {
    }

    public void handleOther(IResource resource, IProgressMonitor progressMonitor, Map buildCache) {
    }

    public void handleWebServerResources(IResource resource, IProgressMonitor progressMonitor, Map buildCache) {
        if (resource instanceof IFile) {
            String resourcePath = resource.getLocation().toOSString();
            if (this.myXcodeProject != null) {
                this.myXcodeProject.addWSResourceFileReference(resourcePath);
            }
            if (this.myXcodeProjProject != null) {
                this.myXcodeProjProject.addWSResourceFileReference(resourcePath);
            }
            this.myProjectChanged = true;
        } else if (resource instanceof IFolder) {
            String resourcePath = resource.getLocation().toOSString();
            if (this.myXcodeProject != null) {
                this.myXcodeProject.addWSResourceFolderReference(resourcePath);
            }
            if (this.myXcodeProjProject != null) {
                this.myXcodeProjProject.addWSResourceFolderReference(resourcePath);
            }
            this.myProjectChanged = true;
        }
    }

    protected boolean shouldAddResource(IResource resource) {
        String parentName;
        IContainer parent;
        boolean shouldAddResource = true;
        if (resource instanceof IFolder) {
            shouldAddResource = false;
            if (resource.getName().endsWith(".wo") || resource.getName().endsWith(".eomodeld")) {
                shouldAddResource = true;
            }
        } else if (resource instanceof IFile && (parent = resource.getParent()) != null && ((parentName = parent.getName().toLowerCase()).endsWith(".eomodeld") || parentName.endsWith(".wo") || parentName.endsWith("~"))) {
            shouldAddResource = false;
        }
        return shouldAddResource;
    }

    public void handleWoappResources(IResource resource, IProgressMonitor progressMonitor, Map buildCache) {
        boolean shouldAddResource = this.shouldAddResource(resource);
        if (shouldAddResource) {
            String resourcePath = resource.getLocation().toOSString();
            if (resource instanceof IFolder) {
                if (this.myXcodeProject != null) {
                    this.myXcodeProject.addResourceFolderReference(resourcePath);
                }
                if (this.myXcodeProjProject != null) {
                    this.myXcodeProjProject.addResourceFolderReference(resourcePath);
                }
                this.myProjectChanged = true;
            } else if (resource instanceof IFile) {
                if (this.myXcodeProject != null) {
                    this.myXcodeProject.addResourceFileReference(resourcePath);
                }
                if (this.myXcodeProjProject != null) {
                    this.myXcodeProjProject.addResourceFileReference(resourcePath);
                }
                this.myProjectChanged = true;
            }
        }
    }
}

