/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.componenteditor.inspector;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.objectstyle.wolips.baseforplugins.util.ComparisonUtils;
import org.objectstyle.wolips.bindings.wod.BindingValueKey;
import org.objectstyle.wolips.bindings.wod.BindingValueKeyPath;
import org.objectstyle.wolips.componenteditor.inspector.IWOBrowserDelegate;
import org.objectstyle.wolips.componenteditor.inspector.WOBrowserColumn;
import org.objectstyle.wolips.wodclipse.core.completion.WodParserCache;

public class WOBrowser
extends ScrolledComposite
implements ISelectionChangedListener,
ISelectionProvider,
KeyListener {
    private Composite _browserComposite;
    private List<WOBrowserColumn> _columns;
    private List<ISelectionChangedListener> _listeners = new LinkedList<ISelectionChangedListener>();
    private IWOBrowserDelegate _browserDelegate;
    private StringBuffer _keypathBuffer = new StringBuffer();
    private long _lastKeyTime;

    public WOBrowser(Composite parent, int style) {
        super(parent, 0x100 | style);
        this._columns = new LinkedList<WOBrowserColumn>();
        this._browserComposite = new Composite((Composite)this, 0);
        this._browserComposite.setBackground(parent.getBackground());
        this.setContent((Control)this._browserComposite);
        this.setExpandVertical(true);
        GridLayout browserLayout = new GridLayout(1, false);
        browserLayout.horizontalSpacing = 0;
        browserLayout.marginWidth = 5;
        browserLayout.marginHeight = 5;
        browserLayout.horizontalSpacing = 5;
        this._browserComposite.setLayout((Layout)browserLayout);
    }

    public void setBrowserDelegate(IWOBrowserDelegate browserDelegate) {
        this._browserDelegate = browserDelegate;
        for (WOBrowserColumn column : this._columns) {
            column.setDelegate(browserDelegate);
        }
    }

    public IWOBrowserDelegate getBrowserDelegate() {
        return this._browserDelegate;
    }

    public WOBrowserColumn setRootType(IType type) throws JavaModelException {
        this.disposeToColumn(-1);
        return this.addType(type);
    }

    public WOBrowserColumn addType(IType type) throws JavaModelException {
        WOBrowserColumn newColumn = null;
        if (type != null) {
            newColumn = new WOBrowserColumn(this, type, this._browserComposite, 0);
            newColumn.getViewer().getTable().addKeyListener((KeyListener)this);
            newColumn.setDelegate(this._browserDelegate);
            newColumn.addSelectionChangedListener(this);
            GridData columnLayoutData = new GridData(1808);
            newColumn.setLayoutData(columnLayoutData);
            this._columns.add(newColumn);
            if (this._browserDelegate != null) {
                this._browserDelegate.browserColumnAdded(newColumn);
            }
            ((GridLayout)this._browserComposite.getLayout()).numColumns = this._columns.size();
            this._browserComposite.pack();
            for (WOBrowserColumn column : this._columns) {
                Object selectedElement = ((IStructuredSelection)column.getSelection()).getFirstElement();
                if (selectedElement == null) continue;
                column.getViewer().reveal(selectedElement);
            }
            this.getHorizontalBar().setSelection(this.getHorizontalBar().getMaximum());
            this.layout();
        }
        return newColumn;
    }

    public void disposeToColumn(WOBrowserColumn column) {
        int columnIndex = this._columns.indexOf((Object)column);
        if (columnIndex != -1) {
            this.disposeToColumn(columnIndex);
        }
    }

    public void disposeToColumn(int columnIndex) {
        for (int columnNum = this._columns.size() - 1; columnNum > columnIndex; --columnNum) {
            WOBrowserColumn column = this._columns.get(columnNum);
            if (this._browserDelegate != null) {
                this._browserDelegate.browserColumnRemoved(column);
            }
            column.dispose();
            this._columns.remove(columnNum);
        }
        this._browserComposite.pack();
    }

    public WOBrowserColumn selectKeyInColumn(BindingValueKey selectedKey, WOBrowserColumn column) {
        WOBrowserColumn addedColumn = null;
        this.disposeToColumn(column);
        if (selectedKey != null) {
            try {
                IType nextType;
                if (!selectedKey.isLeaf() && (nextType = selectedKey.getNextType()) != null) {
                    addedColumn = this.addType(nextType);
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
        return addedColumn;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        WOBrowserColumn selectedColumn = (WOBrowserColumn)((Object)event.getSource());
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        Object selectedObject = selection.getFirstElement();
        if (selectedObject instanceof BindingValueKey) {
            BindingValueKey selectedKey = (BindingValueKey)selectedObject;
            this.selectKeyInColumn(selectedKey, selectedColumn);
        } else {
            this.selectKeyInColumn(null, selectedColumn);
        }
        SelectionChangedEvent wrappedEvent = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        for (ISelectionChangedListener listener : this._listeners) {
            listener.selectionChanged(wrappedEvent);
        }
    }

    public WOBrowserColumn getFocusedColumn() {
        WOBrowserColumn focusedColumn = null;
        for (WOBrowserColumn column : this._columns) {
            if (!column.getViewer().getTable().isFocusControl()) continue;
            focusedColumn = column;
        }
        return focusedColumn;
    }

    public WOBrowserColumn getSelectedColumn() {
        WOBrowserColumn selectedColumn = null;
        for (WOBrowserColumn column : this._columns) {
            if (column.getSelectedKey() == null) continue;
            selectedColumn = column;
        }
        return selectedColumn;
    }

    public String getSelectedKeyPath() {
        return this.getSelectedKeyPath(null);
    }

    public String getSelectedKeyPath(WOBrowserColumn throughColumn) {
        StringBuffer keyPath = new StringBuffer();
        for (WOBrowserColumn column : this._columns) {
            BindingValueKey key = column.getSelectedKey();
            if (key == null) continue;
            if (keyPath.length() > 0) {
                keyPath.append('.');
            }
            keyPath.append(key.getBindingName());
            if (throughColumn != column) continue;
            break;
        }
        return keyPath.toString();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this._listeners.add(listener);
    }

    public ISelection getSelection() {
        return new StructuredSelection((Object)this.getSelectedKeyPath());
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this._listeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        block7: {
            Object selectedObject = ((IStructuredSelection)selection).getFirstElement();
            if (selectedObject == null || selectedObject instanceof String) {
                String selectedKeyPath = (String)selectedObject;
                if (selectedKeyPath == null) {
                    WOBrowserColumn column = this._columns.get(0);
                    this.selectKeyInColumn(null, column);
                    column.setSelection((ISelection)new StructuredSelection());
                } else {
                    try {
                        BindingValueKey[] bindingKeys;
                        if (ComparisonUtils.equals((Object)selectedKeyPath, (Object)this.getSelectedKeyPath())) break block7;
                        BindingValueKeyPath bindingValueKeyPath = new BindingValueKeyPath(selectedKeyPath, this._columns.get(0).getType(), WodParserCache.getTypeCache());
                        this.disposeToColumn(0);
                        if (bindingValueKeyPath == null || !bindingValueKeyPath.isValid() || (bindingKeys = bindingValueKeyPath.getBindingKeys()) == null) break block7;
                        for (BindingValueKey bindingValueKey : bindingKeys) {
                            WOBrowserColumn column = this._columns.get(this._columns.size() - 1);
                            column.setSelection((ISelection)new StructuredSelection((Object)bindingValueKey));
                            WOBrowserColumn newColumn = this.selectKeyInColumn(bindingValueKey, column);
                            if (newColumn != null) {
                                continue;
                            }
                            break;
                        }
                    }
                    catch (JavaModelException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    protected String getPreviousSelectedKeyPath() {
        int dotIndex;
        String previousSelectedKeyPath = null;
        String selectedKey = this.getSelectedKeyPath();
        if (selectedKey.length() > 0 && (dotIndex = selectedKey.lastIndexOf(46)) != -1) {
            previousSelectedKeyPath = selectedKey.substring(0, dotIndex);
        }
        return previousSelectedKeyPath;
    }

    public void selectPreviousColumn() {
        String previousSelectedKeyPath = this.getPreviousSelectedKeyPath();
        if (previousSelectedKeyPath != null) {
            this.setSelection((ISelection)new StructuredSelection((Object)previousSelectedKeyPath));
            WOBrowserColumn previousColumn = this.getSelectedColumn();
            if (previousColumn != null) {
                previousColumn.setFocus();
            }
        }
        this.clearKeyBuffer();
    }

    public void selectNextColumn() {
        int columnIndex;
        WOBrowserColumn column = this.getSelectedColumn();
        if (column != null && (columnIndex = this._columns.indexOf((Object)column)) < this._columns.size() - 1) {
            WOBrowserColumn nextColumn = this._columns.get(this._columns.size() - 1);
            Object firstElement = nextColumn.getViewer().getElementAt(0);
            nextColumn.setSelection((ISelection)new StructuredSelection(firstElement));
            nextColumn.setFocus();
        }
        this.clearKeyBuffer();
    }

    protected void clearKeyBuffer() {
        this._keypathBuffer.setLength(0);
    }

    protected void selectFromKeyBuffer() {
        WOBrowserColumn focusedColumn;
        if (this._keypathBuffer.length() > 0 && (focusedColumn = this.getFocusedColumn()) != null) {
            BindingValueKey matchingKey = focusedColumn.getBindingValueKeyStartingWith(this._keypathBuffer.toString());
            this.disposeToColumn(focusedColumn);
            if (matchingKey != null) {
                focusedColumn.setSelection((ISelection)new StructuredSelection((Object)matchingKey));
            }
        }
    }

    protected void deleteFromKeyBuffer() {
        if (this._keypathBuffer.length() > 0) {
            this._keypathBuffer.setLength(this._keypathBuffer.length() - 1);
        }
        this.selectFromKeyBuffer();
        this._lastKeyTime = System.currentTimeMillis();
    }

    protected void appendToKeyBuffer(char ch) {
        long keyTime = System.currentTimeMillis();
        if (keyTime - this._lastKeyTime > 1000L || this._keypathBuffer.length() == 0) {
            this._keypathBuffer.setLength(0);
        }
        this._keypathBuffer.append(ch);
        this.selectFromKeyBuffer();
        this._lastKeyTime = keyTime;
    }

    public void keyPressed(KeyEvent e) {
        if (e.keyCode == 0x1000003) {
            this.selectPreviousColumn();
        } else if (e.keyCode == 0x1000004) {
            this.selectNextColumn();
        } else if (e.keyCode == 27) {
            this.clearKeyBuffer();
        } else if (e.character == '.') {
            this.selectNextColumn();
        } else if (e.keyCode == 8 || e.keyCode == 127) {
            this.deleteFromKeyBuffer();
        } else if (e.character != '\u0000') {
            this.appendToKeyBuffer(e.character);
        }
    }

    public void keyReleased(KeyEvent e) {
    }
}

