/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.core;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.objectstyle.wolips.baseforuiplugins.AbstractBaseUIActivator;
import org.objectstyle.wolips.core.resources.builder.IBuilder;
import org.objectstyle.wolips.core.resources.internal.build.BuilderWrapper;
import org.osgi.framework.BundleContext;

public class CorePlugin
extends AbstractBaseUIActivator {
    public static final String PLUGIN_ID = "org.objectstyle.wolips.core";
    private static CorePlugin plugin;
    private BuilderWrapper[] builderWrapper;
    private static final String EXTENSION_POINT_ID = "org.objectstyle.wolips.builders";

    public CorePlugin() {
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
        this.builderWrapper = null;
    }

    public static CorePlugin getDefault() {
        return plugin;
    }

    private void loadBuilderExtensionPoint() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(EXTENSION_POINT_ID);
        IExtension[] extensions = extensionPoint.getExtensions();
        ArrayList<BuilderWrapper> arrayList = new ArrayList<BuilderWrapper>();
        for (int i = 0; i < extensions.length; ++i) {
            IConfigurationElement[] configurationElements = extensions[i].getConfigurationElements();
            for (int j = 0; j < configurationElements.length; ++j) {
                IConfigurationElement configurationElement = configurationElements[j];
                IBuilder currentBuilder = null;
                try {
                    currentBuilder = (IBuilder)configurationElement.createExecutableExtension("class");
                    String name = configurationElement.getAttribute("name");
                    String context = configurationElement.getAttribute("context");
                    arrayList.add(new BuilderWrapper(currentBuilder, name, context));
                    continue;
                }
                catch (CoreException e) {
                    this.log("Could not create executable from configuration element: " + configurationElement, e);
                }
            }
        }
        this.builderWrapper = arrayList.toArray(new BuilderWrapper[arrayList.size()]);
    }

    public BuilderWrapper[] getBuilderWrapper(String context) {
        if (this.builderWrapper == null) {
            this.loadBuilderExtensionPoint();
        }
        ArrayList<BuilderWrapper> builderWrapperList = new ArrayList<BuilderWrapper>();
        for (int i = 0; i < this.builderWrapper.length; ++i) {
            BuilderWrapper currentBuilderWrapper = this.builderWrapper[i];
            if (!currentBuilderWrapper.validInContext(context)) continue;
            builderWrapperList.add(currentBuilderWrapper);
        }
        return builderWrapperList.toArray(new BuilderWrapper[builderWrapperList.size()]);
    }
}

